#include <ctype.h>
#define Case	break; case

ptoi(s)
	char *s;
/*
** Convert pitch to int: 'ptoi("C#4")' is '61'.
** Pitch names may be upper or lower case;
** use '#', 'b', 'x' for sharp, flat, double sharp, respectively.
** Sharps may also be written as '+' and flats as '-'.
** Accidentals accumulate, so that 'c++' means 'c double sharp'.
** Octaves are numbers and may appear before or after accidentals.
** Without an octave, 'c' is taken to be pitch '0', 'b' is '11'.
** Return '-1' if 's' is weird.
*/
{
	int p = -1;
	static int pitch[] = {9,11,0,2,4,5,7}; /* a b c d e f g */
	char c;

	while (isspace(*s) && *s) ++s;
	if (!isalpha(*s)) return p;
	p = pitch[((isupper(*s)? tolower(*s) : *s) - 'a')];
	while (*s) switch (*++s) {
	Case 'b': case '-': p--;	/* sharp */
	Case '#': case '+': p++;	/* flat */
	Case 'x': p += 2;		/* double sharp */
	Case '0': case '1': case '2': case '3': case '4':
	case '5': case '6': case '7': case '8': case '9':
		p += 12 * (atoi(s) + 1); /* c0 = 12 */
		while (isdigit(*s) && *s) ++s;
	}
	return p;
}
/*
main(){
#define p(x) printf("%s => %d\n", x, ptoi(x));
	p("c#")
	p("c4")
	p("c#4")
	p("Ab4")
}
	
*/
