h23372
s 00113/00000/00000
d D 1.1 84/12/20 17:12:57 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>

/*
 * send_ch -	send channel info to midi
 * takes:
 * fid -	unix file id
 * 	cmd -	command to send, any of:
 * 		CH_KEY_OFF -	key off (dx never sends this)
 * 		CH_KEY_ON -	key on (used also for key off)
 * 		CH_CTL -	control change
 * 		CH_P_BEND -	pitch bend
 * 		CH_PRG -	program change
 * 		CH_POLY_KPRS -	polyphonic key pressure
 * 		CH_PRESSURE -	channel pressure
 * 	chan -	channel to send it on
 * 		0 - 15 (n == 0; ch1)
 * 	val1 -	first value, (0 - 127):
 * 		for CH_KEY_ON, CH_KEY_OFF:
 * 			key number:
 * 				for data from dx:
 * 					k == 36; C1 - k == 96; C6
 * 				for data to dx:
 * 					k == 0; C-2 - k == 127; G8
 * 		for CH_CTL, control number as follows for dx7:
 * 			CTL_DX7_MOD_WHEEL -	modulation wheel
 * 			CTL_DX7_BREATH - 	breath controler
 * 			CTL_DX7_AFTER -		after touch
 * 			CTL_DX7_FCONT -		foot controller
 * 			CTL_DX7_DE_KNOB -	data entry knob
 * 			CTL_DX7_SUST_FSW -	sostinuto foot switch
 * 			CTL_DX7_PORTA_FSW -	portamento foot switch
 * 			CTL_DX7_DE_PLUS -	data entry plus
 * 			CTL_DX7_DE_MINUS -	data entry minus
 * 		for CH_PRG:
 * 			0 - 127 
 * 			(for Yamaha dx7:  n == 0; v1 - n == 31; v32)
 * 		for CH_P_BEND
 * 			LS byte, 0 - 63
 * 			(for Yamaha: n == 64; at rest position)
 * 		for CH_POLY_KPRS
 * 			key number
 * 		for CH_PRESSURE
 * 			Channel pressure/after-touch amount, 0 - 127.
 * 			For Mono mode: channel (rather than key) is 
 * 			identified.
 * 	val2 -	next value 
 * 		for CH_KEY_OFF:
 * 			ignored
 * 		for CH_KEY_ON:
 * 			key velocity (Yamaha: v == 0; Key OFF, v == 1; 
 * 				ppp - v == 127; fff)
 * 		for CH_CTL:
 * 			control value, 0 - 127
 * 		for CH_PRG:
 * 			undefined
 * 		for CH_P_BEND:
 * 			MS byte, 64 - 127
 * 			(Yamaha: n == 64; at rest position)
 * 		for CH_POLY_KPRS
 * 			Pressure/After-touch value, 0 - 127.
 * 			Used in Omni mode. (Compare CH_PRESSURE in mono
 * 			mode.)
 * returns:
 * 	0 on success, -1 on failure
 * side effects:
 * 	writes data to synthesizer via midi_out()
 */

send_ch(fid, cmd, chan, val1, val2)
	int 	fid;
	u_char cmd;
	u_char chan;
	u_char val1, val2;
{
	switch (cmd) {
		case CH_KEY_ON:
		case CH_KEY_OFF:
		case CH_CTL:
		case CH_P_BEND:
		case CH_POLY_KPRS:
			if (midi_out(fid, cmd | (chan & M_CHAN_MASK)) == EOF)
				return(midi_out_err("midi_ch_1", -1));
			if (midi_out(fid, val1 & M_VAL_MASK) == EOF)
				return(midi_out_err("midi_ch_2", -1));
			if (midi_out(fid, val2 & M_VAL_MASK) == EOF)
				return(midi_out_err("midi_ch_3", -1));
			break;
		case CH_PRG:
		case CH_PRESSURE:
			if (midi_out(fid, cmd | (chan & M_CHAN_MASK)) == EOF)
				return(midi_out_err("midi_ch_4", -1));
			if (midi_out(fid, val1 & M_VAL_MASK) == EOF)
				return(midi_out_err("midi_ch_5", -1));
			break;
		default:
			fprintf(stderr, "midi_ch: invalid command=%x\n",
				cmd);
			return(-1);
	}
	return(0);
}

midi_out_err(str, stat)
	char *	str;
	int	stat;
{
	fprintf(stderr, "%s\n", str);
	return(stat);
}
E 1
