h35533
s 00043/00000/00000
d D 1.1 84/12/20 17:11:26 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/dx7.h>

/*
 * da_sx -	disassemble midi system exclusive commands
 * takes:
 * 	fid -	file descriptor for disassembly output
 * 	ch -	pointer to array of midi system exclusive commands
 * returns:
 * 	0 if ok, else -1 if no vector available for the synthesizer id
 * side effects:
 * 	prints disassembly on standard output
 * notes:
 * 	This routine vectors the system exclusive command to the proper
 * 	disassembler based on the decoded manufacturer's midi id number.
 * 	This routine must be modified to add system exclusive disassembly
 * 	for additional synthesizers.
 * 	1) add an #include statement for its library header file, which
 * 		must contain a macro for the manufacturer's midi ID number,
 * 	2) insert a case statement below to call the routine.
 * 	3) the routine should write its output on fid.
 */


da_sx(fid, ch)
	FILE *fid; 
	u_char *	ch; 
{
	switch (ch[1]) {
		case ID_DX7:
			da_dx7_sx(fid, ch);
			break;
		default:
		    fprintf(fid, 
			"da_sx: no system exclusive disassembler for id=%d\n",
			ch[1]);
		    return(-1);
	}
	return(0);
}
E 1
