/* sx_dx7_1v.c	1.1	(CARL)	5/31/85	16:16:25 */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

#define range(x, base, len) (x >= base && x < base + len)

sx_dx7_1v(fid, ch)
	FILE *fid;
	u_char *	ch;
{
	register int	i,
			j,
			opct;
	int 		check_sum = 0; 
	register u_char	val;

	fprintf(fid, "\t; voxname=\t");
	for (j = 0; j < VOX_NAME_LEN; j++)
	    fprintf(fid, "%c", ch[6 + VOX_NAME_BASE + j]);
	fprintf(fid, "\n");

	for (opct = 5, i = 0; i < DX7VOXLEN; i++) {
	    j = DX7_INI_IND(i);
	    val = ch[i + 6];
	    fprintf(fid, 
		(range(i, VOX_NAME_BASE, VOX_NAME_LEN))
		 ? "%2x\t; vox    [%3d]=\t%-10c%-10d%s"
		 : "%2x\t; vox    [%3d]=\t%-10d%-10d%s",
		    val,
		    i,
		    val,
		    dx7_ini_vox[j].par_ub,
		    dx7_ini_vox[j].par_name);
	    if (j == 0)
		    fprintf(fid, "\top[%d]\n", opct--);
	    else
		    fprintf(fid, "\n");
	    check_sum += val;
	}
	val = ch[DX7VOXLEN + 6];
	fprintf(fid, "%2x\t; check-sum=\t%d", val, val);
	check_sum = 0x80 - (0x7f & check_sum);
	if (val == check_sum)
	    fprintf(fid, "\t\tvalid check-sum\n");
	else
	    fprintf(fid, "\t\t%s %x != %x\n",
		"invalid check-sum",
		val,
		check_sum);
}
