#include <sundev/mpuvar.h>
#include <carl/libcarlmidi.h>

dx7SetVoice(midi,n)
/*
 * Set the dx7 program (ie, voice) to 'n'.
 * Note that 'n' is '0'-based; i.e., to simulate pressing
 * program button labeled '7' on the dx7, do 'dx7SetVoice(midi,6)'.
 */
{
	static unsigned char s[4] = {MPU_WANT_TO_SEND_DATA,CH_PRG,0,0};
	s[2] = n;
	MpuSetTrack(midi,MPU_TR_COM);
	write(midi,s,3);
	MpuSetTrack(midi,0);
}
