h25565
s 00067/00000/00000
d D 1.1 84/12/21 11:06:47 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

/*
 * send_dx7_bd -	send system exclusive bulk data to dx7 
 * send_dx7_bd(fid, fmt, chan, size, data)
 *	int	fid;
 * 	u_char	fmt;
 * 	u_char	chan;
 * 	u_short	size;
 * 	u_char	*data;
 * takes:
 *	fid -	unix file id
 * 	fmt -	format, bulk data for 1 or 32 voices
 * 		SX_DX7_1V - system exclusive, 1 voice
 * 		SX_DX7_32V - system exclusive, 32 voices
 * 	chan -	midi channel
 * 		(n == 0; ch1)
 * 	size -	size of array
 * 		for SX_DX7_1V, size must == 156
 * 		for SX_DX7_32V, size must == 4960
 * 	data -	system exclusive voice or function parameter data.
 * 		Refer to Yamaha dx7 midi data format documentation
 * returns:
 * 	-1 on errors, 0 otherwise
 * 	errors include: EOF on transmitted command, checksum error
 */

send_dx7_bd(fid, fmt, chan, size, data)
	int 	fid;
	u_char	fmt;		/* bulk data for 1, or 32 voices */
	u_char	chan;
	u_short	size; 		/* length of data array in bytes */
	u_char	*data;
{
	register u_short i, cksum = 0;

	if (fmt == SX_DX7_1V || fmt == SX_DX7_32V) {
		if (midi_out(fid, SX_CMD) == EOF)
			return(dx7_out_err("midi_bd", -1));
		if (midi_out(fid, ID_DX7) == EOF)
			return(dx7_out_err("midi_bd", -1));
		if (midi_out(fid, SX_DX7_BD << 4 | (chan & M_CHAN_MASK)) == EOF)
				return(dx7_out_err("midi_bd", -1));
		if (midi_out(fid, fmt & M_VAL_MASK) == EOF)
			return(dx7_out_err("midi_bd", -1));
		/* bits 7 - 13 of size */
		if (midi_out(fid, (size >> 7) & M_VAL_MASK) == EOF)
			return(dx7_out_err("midi_bd", -1));
		/* bits 0 - 6 of size */
		if (midi_out(fid, size & M_VAL_MASK) == EOF)
			return(dx7_out_err("midi_bd", -1));
	} else {
		fprintf(stderr, "midi_bd: invalid format=%x\n", fmt);
		return(-1);
	}
	for (i = 0; i < size; i++)
		if (midi_out(fid, cksum += data[i] & M_VAL_MASK) == EOF)
			return(dx7_out_err("midi_bd", -1));
	if (midi_out(fid, -cksum & M_VAL_MASK) == EOF)
		return(dx7_out_err("midi_bd", -1));
	return(0);
}
E 1
