/*
 * gen statements can be made directly within a voice and they behave 
 * somewhat similarly to the usage in cmusic.  Unlike cmusic however,
 * the second parameter, the one after the name of the gen function, 
 * is the length of the function, not an action time (obviously,
 * the action time is determined by when the voice is called).
 * Thus, the gen statement 
 * 	f1 = Gen("gen1 20 0 1 4 2 9 10 19 20");
 * in this example is equivalent to the shell command:
 * 	% gen1 -L20 0 1 4 2 9 10 19 20
 * 
 * Note that rhythmic values can be dotted.  The notation "4." implies a
 * duration of 3 8th. notes.  Note further that a rhythmic value can be
 * specified as a fraction.  The notation "3/8" can be thought of as
 * saying "three eights", and is equivalent to the notation "4.".
 * Any number of dots may follow a rhythmic value.  Each dot adds half again
 * to the value of a rhythm, e.g., 2. = 1/2 + 1/4 = 3/4, 2.. = 1/2 + 1/4 + 1/8
 * = 7/8.
 * 
 * In the notes statement, an "r" expression occurrs, which means this
 * voice will experience a rest when that point in the list is reached.
 * In a rest, all statements in the voice are executed normally, but the
 * result is not printed out.  The duration of the rest will be the 
 * value of P2.
 * 
 * Ordinarily, the score generated by ccmp goes from P1 up to the highest
 * numbered parameter (P field) referenced.  This can be changed by
 * calling the procedure hipn()
 * which sets the highest P field to be
 * printed.  In this example, even though P20 is used, only the first 6 P
 * fields will be printed.  Each voice is given 128 P fields.
 */

Player blat(0,30)
{
	Instance Function *f1;
	P_start {
		f1 = Gen("gen1 -L20 0 1 4 2 9 10 19 20");
		Pp5 = "Hz";
		Ps6 = "F1";
		Hipn(Self, 7);
	}
	P4 = Rhythms("4 4 4 4 4. 3/8 2. 3/4 1 4/4 2..");
	P5 = Pitches("a r a r a b c d e f g");
	P7 = Rel_func(f1, Rel_time(Self));
	P20 = 1.0;
	P2 = Now;
	Wait_until(P2 + P4);
}
