h04347
s 00000/00000/00033
d D 2.1 85/10/26 23:41:04 dgl 2 1
c changed variable names.
e
s 00033/00000/00000
d D 1.1 84/12/21 12:09:36 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

/*
 * Tempo -	compute tempo by integrating a function of time
 * takes:
 * 	tempofun -	function of time, monotonic in X
 * 	abstart -	un-tempo-factored start time
 * 	absdur -	un-tempo-factored duration
 * 	limit -		limit of integration
 * returns:
 * 	tempo factored time
 */

double 
Tempo(tempofun, abstart, absdur, limit)
	register Function *tempofun;
	register double *abstart, absdur, limit;
{
	register double 	dursum=0, 
				x, 
				ub, 
				absend = *abstart + absdur;

	for (x = *abstart; x < absend; x = ub) {
		ub = ceil(x) == x ? x+limit : ceil(x);
		ub = ub > absend ? absend : ub;
		dursum += (ub - x) * tempofun->fyval[(int)x];
	}
	*abstart += absdur;
	return(dursum);
}
E 1
