h22286
s 00001/00001/00101
d D 2.3 86/03/06 14:34:03 dgl 9 8
c 
e
s 00008/00004/00094
d D 2.2 86/01/30 16:36:03 dgl 8 7
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00024/00024/00074
d D 2.1 85/10/26 23:41:09 dgl 7 6
c changed variable names.
e
s 00003/00026/00095
d D 1.6 85/10/14 15:48:12 dgl 6 5
c removed P_INTEGER code, added P_KILLED test.
e
s 00012/00009/00109
d D 1.5 85/09/17 13:16:06 dgl 5 4
c changed representation of duration==infinity to -1.
e
s 00001/00001/00117
d D 1.4 85/02/25 14:13:53 dgl 4 3
c fixed buggy ifdef...
e
s 00017/00002/00101
d D 1.3 85/02/25 14:05:22 dgl 3 2
c in integer environment, having to sleep for a period of time
c is now done by stuffing the next Player to be awakened into nextPlayer,
c and returning.  The idea is that we will return to run_arbiter on the
c next clock tick, where we will do the sleep test again, eventually
c succeeding.
e
s 00008/00000/00095
d D 1.2 85/02/25 12:10:14 dgl 2 1
c added ifdefs to handle integer environment
e
s 00095/00000/00000
d D 1.1 84/12/21 12:08:59 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
D 9
#include "/carl/staff/dgl/Player/c/debug.h"
E 9
I 9
#include "debug.h"
E 9

/*
 * run_arbiter -	runtime scheduler
 * side effects:
 * 	Fetches next Player instance to run from get_wait().
 * 	Sets Player instance status to P_KILLED if 
 * 		action time >= begin time + duration.
 * 	Updates global time variable Now, and action time of Player.
 * 	Set Player status to P_RUNNING.
 * 	Sets global Player instance pointer Self.
 * 	Calls Player proc.
 */

I 3

E 3
run_arbiter()
{
I 3
D 6
# ifdef P_INTEGER
	extern Player *nextPlayer;
# endif P_INTEGER
E 6
E 3
	register Player *p, z;

	do {
		/* is it an active player? */
I 3
D 6
# ifdef P_INTEGER
		if (nextPlayer != NULL) {
			p = nextPlayer;
			nextPlayer = NULL;
		}
		else
D 4
# ifdef P_INTEGER
E 4
I 4
# endif P_INTEGER
E 6
E 4
E 3
		if ((p = get_wait()) == NULL)
			break;
D 7
		if (p->runstat > P_RUNNING) {
E 7
I 7
		if (p->P_runstat > P_RUNNING) {
E 7
# ifdef P_DEBUG
			if (_Pdebug & RUN_ARBITER)
			    fprintf(stderr, 
D 7
				"run_arbiter: runstat for %s:%x = %d\n",
				p->name, p, p->runstat);
E 7
I 7
				"run_arbiter: P_runstat for %s:%x = %d\n",
				p->P_name, p, p->P_runstat);
E 7
# endif P_DEBUG
			continue;
		}
D 5
		/* has it run its span? */
D 3
  		/* if (p->ptime >= p->beg + p->dur) { */
  		/* if (p->ptime > p->beg + p->dur) { */
E 3
		if (p->p_et == P_GT 
		    ? p->ptime > p->beg + p->dur
		    : p->ptime >= p->beg + p->dur) {
E 5
I 5
D 7
		if (p->dur >= 0) {
E 7
I 7
		if (p->P_dur >= 0) {
E 7
			/* has it run its span? */
D 7
			if (p->p_et == P_GT 
			    ? p->ptime > p->beg + p->dur
			    : p->ptime >= p->beg + p->dur) {
E 7
I 7
			if (p->P_et == P_GT 
			    ? p->P_time > p->P_beg + p->P_dur
			    : p->P_time >= p->P_beg + p->P_dur) {
E 7
E 5
# ifdef P_DEBUG
D 5
			if (_Pdebug & RUN_ARBITER) 
			    fprintf(stderr, "run_arbiter: killing %s:%x\n",
				p->name, p);
E 5
I 5
				if (_Pdebug & RUN_ARBITER) 
				    fprintf(stderr, 
					"run_arbiter: killing %s:%x\n",
D 7
					p->name, p);
E 7
I 7
					p->P_name, p);
E 7
E 5
# endif P_DEBUG
D 5
			Kill(p);
			continue;
E 5
I 5
				Kill(p);
				continue;
			}
E 5
		}
D 7
		if (p->ptime > Now) {
E 7
I 7
		if (p->P_time > Now) {
E 7
			if (Realtime) {
I 2
D 6
# ifdef P_FLOAT
E 6
E 2
D 7
				register double diff = p->ptime - Now;
E 7
I 7
				register double diff = p->P_time - Now;
E 7
I 2
D 6
# else P_FLOAT
				register long diff = p->ptime - Now;
# endif P_FLOAT
E 2

I 2
# ifdef P_FLOAT
E 6
E 2
				if (diff > .001) {
I 2
D 6
# else P_FLOAT
				if (diff > 0) {
# endif P_FLOAT
E 6
E 2
# ifdef P_DEBUG
					if (_Pdebug & RUN_ARBITER)
						fprintf(stderr, 
						    "Psleep:%s:%f==%f - %f\n",
D 7
							p->name,
E 7
I 7
							p->P_name,
E 7
							diff,
D 7
							p->ptime, Now);
E 7
I 7
							p->P_time, Now);
E 7
# endif P_DEBUG
I 3

D 6
# ifdef P_FLOAT
E 6
E 3
					Psleep(diff);
I 3
D 6
# else P_FLOAT
					nextPlayer = p;
					return;
# endif P_FLOAT
E 6
E 3
				}
			}
D 7
			Now = p->ptime;		/* update global time */
E 7
I 7
			Now = p->P_time;		/* update global time */
E 7
		} else
D 7
			p->ptime = Now;		/* update private time */
E 7
I 7
			p->P_time = Now;		/* update private time */
E 7
		Self = p;		/* set global who-am-i */
D 7
		p->runstat = P_RUNNING;	/* make this the running proc. */
E 7
I 7
		p->P_runstat = P_RUNNING;	/* make this the running proc. */
E 7
# ifdef P_DEBUG
		if (_Pdebug & RUN_ARBITER)
		    fprintf(stderr, "run_arbiter: %f:\trunning %s:%x\n", 
D 7
			Now, p->name, Self);
E 7
I 7
			Now, p->P_name, Self);
E 7
# endif P_DEBUG
D 7
		z = (p->cproc)(Self);	/* call it */
		p->icode = 1;		/* set init. flag done */
		if (p->runstat == P_RUNNING) {	/* still running? */
E 7
I 7
		z = (p->P_cproc)(Self);	/* call it */
		p->P_icode = 1;		/* set init. flag done */
D 8
		if (p->P_runstat == P_RUNNING) {	/* still running? */
E 8
I 8
		Player_stat &= ~(P_WAIT_FOR|P_WAIT_UNTIL);
		if (p->P_runstat == P_RUNNING
		    || p->P_runstat == P_STUNNED) {	/* still running? */
E 8
E 7
			if (Out_proc != NULL)
				(*Out_proc)(p);	/* call output routine */
D 7
			p->runstat = P_READY;	/* reset status */
D 6
		}
		Self = NULL;
E 6
I 6
		} else if (p->runstat == P_KILLED) 	/* killed self */
E 7
I 7
D 8
			p->P_runstat = P_READY;	/* reset status */
		} else if (p->P_runstat == P_KILLED) 	/* killed self */
E 7
			Kill(p);
E 8
I 8
			if (p->P_runstat == P_RUNNING)
				p->P_runstat = P_READY;	/* reset status */
			else
				Kill(p);
		} 
E 8
		Self = (Player *) NULL;
E 6
	} while (1);
}

/*
 * psPlayer(x)
 * 	Player *x;
 * {
 * fprintf((FILE *)stderr, 
D 7
 * 	"%s\tNow=%6.3f, beg=%6.3f, dur=%6.3f, ptime=%6.3f, %s\n",
 * 	x->name, Now, x->beg, x->dur, x->ptime, 
 * 	x->runstat == P_STOPPED ? "STOPPED" : "RUNNING");
E 7
I 7
 * 	"%s\tNow=%6.3f, beg=%6.3f, dur=%6.3f, time=%6.3f, %s\n",
 * 	x->P_name, Now, x->P_beg, x->P_dur, x->P_time, 
 * 	x->P_runstat == P_STOPPED ? "STOPPED" : "RUNNING");
E 7
 * }
 */
E 1
