h40934
s 00000/00000/00096
d D 2.2 86/01/30 16:35:14 dgl 4 3
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00024/00024/00072
d D 2.1 85/10/26 23:40:27 dgl 3 2
c changed variable names.
e
s 00027/00026/00069
d D 1.2 85/10/01 16:40:32 dgl 2 1
c mk_Player now links instance to list kept on class template,
c not on a global list.
e
s 00095/00000/00000
d D 1.1 84/12/21 12:08:05 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <carl/Player.h>

/*
 * mk_Player -	create and link Player instance data structure to list
 * takes:
 * 	list -	linked list of Player instance data structures
 * returns:
 * 	new instance structure linked to the list
 * diagnostics:
 *	mk_Player: append_Player failed
 */

Player *
D 2
mk_Player(list)
	register struct p_list *list;
E 2
I 2
mk_Player(ctempl)
	Player	*ctempl;
E 2
{
	register Player *p;
	
	if ((p = (Player *) calloc(1, sizeof(Player))) == NULL)
		malerr("mk_Player", 1);
D 2
	if (append_Player(list, p) != 0) {
		fprintf(stderr, "mk_Player: append_Player failed\n");
E 2
I 2
	if (append_Player(ctempl, p) != 0) {
		fprintf(
# ifdef P_FLOAT
			stderr, 
# else P_FLOAT
			1, 
# endif P_FLOAT
			"mk_Player: append_Player failed\n");
E 2
		return(NULL);
	}
	return(p);
}

/*
 * append_Player -	link Player instance structure to list
 * takes:
D 2
 * 	list -	linked list of Player instance data structures
E 2
I 2
 * 	ctempl -pointer to Player class structure from which to link this instance
E 2
 * 	p -	new Player instance data structure to attach
 * returns:
 * 	0 on success, -1 on failure
 */

D 2
append_Player(list, p)
	register struct p_list *list;
E 2
I 2
append_Player(ctempl, p)
	Player	*ctempl;
E 2
	register Player *p;
{
D 2
	if (list == NULL)
E 2
I 2
	if (ctempl == (Player *) NULL)
E 2
		return(-1);
D 2
	if (list->p_head == NULL) {	/* first time */
		list->p_head = p;
		list->p_tail = p;
		p->p_last = NULL;
		p->p_next = NULL;
		return(0);
E 2
I 2
D 3
	if (ctempl->p_next == (Player *) NULL) {
		ctempl->p_next = p;
		/* ctempl->p_last is already NULL */
		p->p_last = ctempl;
		p->p_next = (Player *) NULL;
E 3
I 3
	if (ctempl->P_next == (Player *) NULL) {
		ctempl->P_next = p;
		/* ctempl->P_last is already NULL */
		p->P_last = ctempl;
		p->P_next = (Player *) NULL;
E 3
E 2
	} else {
D 2
		list->p_tail->p_next = p;
		p->p_last = list->p_tail;
		list->p_tail = p;
		return(0);
E 2
I 2
D 3
		ctempl->p_next->p_last = p;
		p->p_next = ctempl->p_next;
		ctempl->p_next = p;
		p->p_last = ctempl;
E 3
I 3
		ctempl->P_next->P_last = p;
		p->P_next = ctempl->P_next;
		ctempl->P_next = p;
		p->P_last = ctempl;
E 3
E 2
	}
I 2
	return(0);
E 2
}

/*
 * umk_Player - remove Player x from linked list of Player instances
 * takes:
 * 	list -	list of Player instances
 * 	p -	Player to remove
 * side effects:
D 2
 * 	Unlinks Player x from list, and frees all memory it may have claimed.
E 2
I 2
 * 	Unlinks Player x from instance list, and frees all memory it may have claimed.
E 2
 */

D 2
umk_Player(list, x)
	struct p_list *list;
E 2
I 2
umk_Player(x)
E 2
	Player *x;
{
D 2
	if (list == NULL || x == NULL)
E 2
I 2
	if (x == NULL)
E 2
		return(-1);
D 3
	if (x->p_last != NULL)
		x->p_last->p_next = x->p_next;
	if (x->p_next != NULL)
		x->p_next->p_last = x->p_last;
D 2
	if (list->p_tail == x)
		list->p_tail = x->p_last;
	if (list->p_head == x)
		list->p_head = x->p_next;
E 2
	/* do not free x->name, as it was not malloc()'ed */
	if (x->nstnc != NULL)
		free(x->nstnc);
	if (x->pn != NULL)
		free(x->pn);
	if (x->ps != NULL)
		free(x->ps);
	if (x->pp != NULL)
		free(x->pp);
	if (x->pi != NULL)
		free(x->pi);
E 3
I 3
	if (x->P_last != NULL)
		x->P_last->P_next = x->P_next;
	if (x->P_next != NULL)
		x->P_next->P_last = x->P_last;
	/* do not free x->P_name, as it was not malloc()'ed */
	if (x->P_nstnc != NULL)
		free(x->P_nstnc);
	if (x->P_pn != NULL)
		free(x->P_pn);
	if (x->P_ps != NULL)
		free(x->P_ps);
	if (x->P_pp != NULL)
		free(x->P_pp);
	if (x->P_pi != NULL)
		free(x->P_pi);
E 3
	free(x);
}
E 1
