h14754
s 00005/00037/00103
d D 2.2 86/01/30 16:36:58 dgl 5 4
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00018/00018/00122
d D 2.1 85/10/26 23:41:55 dgl 4 3
c changed variable names.
e
s 00005/00005/00135
d D 1.3 85/09/20 16:15:02 dgl 3 2
c exit() is now Pexit().
e
s 00001/00000/00139
d D 1.2 85/01/11 16:47:10 dgl 2 1
c or'ed in P_KEYSIG to Player_stat.
e
s 00139/00000/00000
d D 1.1 84/12/21 12:07:32 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

set_keysig(keyspec, k)
	char *keyspec;
D 4
	struct keysig *k;
E 4
I 4
	struct sig_key *k;
E 4
{
	extern char *index(), *malloc(), *strcpy();
	register char *c, save;
	register int ks, dir, i;

	if (k == NULL)
		return;

	if ((k->key_sig = malloc(strlen(keyspec)+1)) == NULL)
		malerr("set_keysig", 1);
	(void) strcpy(k->key_sig, keyspec);

	if ((c = index(keyspec, 's')) == NULL)
		if ((c = index(keyspec, 'f')) == NULL) {
			fprintf(stderr, "invalid key signature: ``%s''\n",
				keyspec);
D 3
			exit(1);
E 3
I 3
			Pexit(1);
E 3
		}
	switch (*c) {
		case 's': dir = 1;	break;
		case 'f': dir = -1;
		default:
			fprintf(stderr, "invalid key signature: ``%s''\n",
				keyspec);
D 3
			exit(1);
E 3
I 3
			Pexit(1);
E 3
	}
	save = *c;
	*c =  '\0';
	ks = atoi(keyspec);
	*c = save;
	for (i = 0; i < 12; i++)	/* clear old key signature */
D 4
		k->key[i] = 0;
E 4
I 4
		k->key_pc[i] = 0;
E 4
	if (dir == 1) {			/* set new one */
		for (i = 5; ks > 0; i += 7, ks--) {
			if (i >= 12) 
				i -= 12;
D 4
			k->key[i] = dir;
E 4
I 4
			k->key_pc[i] = dir;
E 4
		}
	} else {
		for (i = 11; ks > 0; i -= 7, ks--) {
			if (i < 0) 
				i += 12;
D 4
			k->key[i] = dir;
E 4
I 4
			k->key_pc[i] = dir;
E 4
		}
	}
I 2
	Player_stat |= P_KEYSIG;
E 2
}

set_ac(pc, ac, k)
	int pc;
D 5
	char ac;
E 5
I 5
	int ac;
E 5
D 4
	struct keysig *k;
E 4
I 4
	struct sig_key *k;
E 4
{
	int dir;

	if (k == NULL)
		return;
D 5
	switch (ac) {
		case 's': dir = 1; break;
		case 'f': dir = -1; break;
		case 'S': dir = 2; break;
		case 'F': dir = -2; break;
		case 'n': dir = 32; break;
		default:
			fprintf(stderr, "set_ac: unknown accidental: %c\n", ac);
D 3
			exit(1);
E 3
I 3
			Pexit(1);
E 3
	}
E 5
I 5
	if (ac == 0)
		dir = 32;
	else
		dir = ac;
E 5
	if (0 <= pc && pc < 12)
D 4
		k->acc[pc] = dir;
E 4
I 4
		k->key_acc[pc] = dir;
E 4
	else {
		fprintf(stderr, "set_ac: invalid pitch class: %d\n", pc);
D 3
		exit(1);
E 3
I 3
		Pexit(1);
E 3
	}
}

clr_ac(k)
D 4
	struct keysig *k;
E 4
I 4
	struct sig_key *k;
E 4
{
	register int i;

	if (k == NULL)
		return;

	for (i = 0; i < 12; i++)
D 4
		k->acc[i] = 0;
E 4
I 4
		k->key_acc[i] = 0;
E 4
}

int
get_ac(pc, k)
	int pc;
D 4
	struct keysig *k;
E 4
I 4
	struct sig_key *k;
E 4
{
	if (k == NULL)
		return(0);
	if (0 <= pc && pc < 12) {
D 4
		if (k->acc[pc] != 0)
			return(k->acc[pc] == 32 ? 0 : k->acc[pc]);
E 4
I 4
		if (k->key_acc[pc] != 0)
			return(k->key_acc[pc] == 32 ? 0 : k->key_acc[pc]);
E 4
		else
D 4
			return(k->key[pc]);
E 4
I 4
			return(k->key_pc[pc]);
E 4
	} else {
		fprintf(stderr, "invalid pitch class: %d\n", pc);
D 3
		exit(1);
E 3
I 3
		Pexit(1);
E 3
	}
D 5
}


/*
D 4
 * Get_keysig -      get key signature structure of a cyclic list
E 4
I 4
 * Get_sig_key -      get key signature structure of a cyclic list
E 4
 * takes:   
 * 	nl -    string address of cyclic list 
 * returns:  
D 4
 * 	the struct keysig * of the cyclic list. 
E 4
I 4
 * 	the struct sig_key * of the cyclic list. 
E 4
 * side effects: 
 * 	none. 
 * notes:
 * 	For this to return non-NULL, Pitches() or Keys() must have
 * 	scanned a key signature in this list already.
 */

D 4
struct keysig *
Get_keysig(nl)
E 4
I 4
struct sig_key *
Get_sig_key(nl)
E 4
	register char *nl;
{
D 4
	register struct noteheader *h;
E 4
I 4
	register struct headcl_hcl *h;
E 4
	register double rtn;
	register char *c;

	h = getid(nl);
D 4
	return(&h->ac_list);
E 4
I 4
	return(&h->hcl_aclist);
E 5
E 4
}
E 1
