h50592
s 00009/00013/00020
d D 2.1 86/01/30 16:37:08 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00033/00000/00000
d D 1.1 85/11/05 16:26:45 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

I 2

double Tempo(tempofun, abstart, absdur, limit)
	register Function *tempofun;	/* function of time, monotonic in x */
	register double *abstart;	/* un-tempo-factored start time */
	register double	absdur;		/* un-tempo-factored duration */
	register double	limit;		/* limit of differential */
E 2
/*
D 2
 * Tempo -	compute tempo by integrating a function of time
 * takes:
 * 	tempofun -	function of time, monotonic in X
 * 	abstart -	un-tempo-factored start time
 * 	absdur -	un-tempo-factored duration
 * 	limit -		limit of integration
 * returns:
 * 	tempo factored time
E 2
I 2
 * Compute tempo coefficient by integrating a function of time.
 * Returns tempo-factored time according to position on \fBFunction\fP
 * determined by 'abstart', 'absdur', and 'limit'.
E 2
 */
D 2

double 
Tempo(tempofun, abstart, absdur, limit)
	register Function *tempofun;
	register double *abstart, absdur, limit;
E 2
{
	register double 	dursum=0, 
				x, 
				ub, 
				absend = *abstart + absdur;

	for (x = *abstart; x < absend; x = ub) {
		ub = ceil(x) == x ? x+limit : ceil(x);
		ub = ub > absend ? absend : ub;
		dursum += (ub - x) * tempofun->fyval[(int)x];
	}
	*abstart += absdur;
	return(dursum);
}
E 1
