h10731
s 00011/00020/00022
d D 2.2 86/01/30 16:34:11 dgl 4 3
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00002/00002/00040
d D 2.1 85/10/26 23:39:32 dgl 3 2
c changed variable names.
e
s 00009/00003/00033
d D 1.2 85/09/24 16:04:06 dgl 2 1
c added information in the comment.
e
s 00036/00000/00000
d D 1.1 84/12/21 12:04:59 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include "debug.h"
#define NULL 0
D 2
/* 
E 2
I 2

I 4

Stop(x)
	register Player *x;	/* Player instance structure address */
E 4
/*
E 2
D 4
 * Stop - set status of Player to P_STOPPED
 * takes:
D 2
 *	Player instance structure address
E 2
I 2
 * Player instance structure address
E 2
 * returns: 
 * 	previous status as follows
 * 		P_NOSTAT 	0
 * 		P_READY 	1
 * 		P_RUNNING 	2
 * 		P_STOPPED 	3
 * 		P_KILLED 	4
 * side effects:
D 2
 *	Sets Player_stat to P_NULL_PTR if no such Player,
E 2
I 2
 * Sets Player_stat to P_NULL_PTR if no such Player,
E 2
 * 	and returns P_NOSTAT.
I 2
 * notes:
 * The run-time arbiter run_arbiter() will delete any schedule entries
E 4
I 4
 * Stop Player instance immediately.
 * .LP
 * Returns previous status.
 * Sets \fBPlayer_stat\fP to \fBP_NULL_PTR\fP if no such Player,
 * and returns \fBP_NOSTAT\fP.
 * The scheduler will delete any entries
E 4
 * associated with a stopped Player.  Thus, schedule entries made for this
D 4
 * Player via either Wait_until() or Wait_for() will be voided as they
 * arise.  
E 4
I 4
 * Player via either \fBWait_until\fP() or \fBWait_for\fP() 
 * will be voided as they arise.  
E 4
E 2
 */
D 4

Stop(x)
	register Player *x;
E 4
{
	register unsigned i;

	Player_stat &= ~P_NULL_PTR;
	if (x != NULL) {
D 3
		i = x->runstat;
		x->runstat = P_STOPPED;
E 3
I 3
		i = x->P_runstat;
		x->P_runstat = P_STOPPED;
E 3
		return(i);
	} else {
		Player_stat |= P_NULL_PTR;
		return(P_NOSTAT);
	}
}
E 1
