h30157
s 00019/00121/00043
d D 2.2 86/01/30 16:36:28 dgl 8 7
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00012/00012/00152
d D 2.1 85/10/26 23:41:31 dgl 7 6
c changed variable names.
e
s 00009/00003/00155
d D 1.5 85/10/11 12:06:44 dgl 6 4
c added Kill directive.
e
s 00009/00003/00155
d R 1.5 85/10/10 16:51:44 dgl 5 4
c Added ``Kill'' cyclic list directive.
e
s 00001/00001/00157
d D 1.4 85/09/30 13:45:39 dgl 4 3
c s/clist_directive/clist_direct/
e
s 00020/00102/00138
d D 1.3 85/03/13 22:58:34 dgl 3 2
c Moved time signature handling to separate file.
c Made Rhythms check to clear accidentals after measure end.
e
s 00061/00031/00179
d D 1.2 84/12/30 23:50:33 dgl 2 1
c added code to make '+' rhythmic operator work, and fixed some bugs
e
s 00210/00000/00000
d D 1.1 84/12/21 12:03:27 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

D 2
/*
 * Rhythm -	evaluate string as Rhythm field
 * takes:	
 *	pointer to Rhythm string
 * returns:	
 *	duration in seconds at MM60
 * side effects: 
 *	Sets Player_stat:
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
 * 		to P_EXPR_ERR if denominator would cause division by 0
 * notes:	
 *	Does not stop Player on STOPSTR.
 *	Returns 1.0 if expression == HOLDSTR or STOPSTR.
 * Diagnostics: 
 *	Rhythm: ``EXPR'' would cause division by 0
 */


double 
Rhythm(str) 
	register char *str;
E 2
I 2
D 8
double
do_rhy(str)
	char *str;
E 2
{
	extern char *index();
	register char *numerator, *denominator, *slsh, *c, *save = NULL;
	register double n, d, rtn;
	register int cnt;

D 2
	Player_stat &= ~(P_STOP_SET | P_EXPR_ERR);
	if (!strcmp(str, STOPSTR)) {
		Player_stat |= P_STOP_SET;
		return(-1.0);			/* "Stop" seen */
	}
E 2
	slsh = index(str, '/');
	if (slsh != NULL) {
		save = slsh;
		*slsh++ = NULL;
		denominator = slsh;
		numerator = str;
	}
	else {
		denominator = str;
		numerator = NULL;
	}
	if (numerator != NULL) 
		n = atof(numerator);
	else
		n = 4.0;
	if (denominator != NULL) {
		c = index(denominator, '.');
		if (c != NULL) 
			*c = NULL;
		d = atof(denominator);
		if (c != NULL) 
			*c = '.';
	} else
		d = 1.0;
	if (d == 0) 
		goto rerr;
	rtn = n/d;
	if (numerator == NULL && index(denominator, '.')) {
		cnt = 2;
		for (c = index(denominator,'.'); c!=NULL; c = index(c+1, '.')) {
			if (d == 0) 
				goto rerr;
			rtn += n/(d*cnt);
			cnt *= 2;
		}
	}
	if (save != NULL)
		*save = '/';	/* put back the slash */
	if (slsh != NULL)
		rtn *= 4.0;
	return(rtn);
rerr:	
	if (save != NULL)
		*save = '/';	/* put back the slash */
	fprintf(stderr, "Rhythm: ``%s'' would cause division by 0\n", str);
	Player_stat |= P_EXPR_ERR;
	return(1.0);	/* return something safe */
}

E 8
I 8
double Rhythms(nl)
	register char *nl;
E 8
I 2
/*
D 8
 * Rhythm -	evaluate string as Rhythm field
 * takes:	
 *	pointer to Rhythm string
 * returns:	
 *	duration in seconds at MM60
 * side effects: 
 *	Sets Player_stat:
D 3
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
E 3
 * 		to P_EXPR_ERR if denominator would cause division by 0
 * notes:	
D 3
 *	Does not stop Player on STOPSTR.
 *	Returns 1.0 if expression == HOLDSTR or STOPSTR.
E 3
I 3
 *	Does not handle Hold or Stop.
E 3
 * Diagnostics: 
D 3
 *	Rhythm: ``EXPR'' would cause division by 0
E 3
I 3
 *	Rhythm: ``<expr>'' would cause division by 0
 * 	Rhythm: malformed expression:``<expr>''
E 8
I 8
 * Evaluate string as cyclic list in \fBRhythm\fP format.
 * .LP
 * Takes pointer to string of \fBRhythm\fP expressions in cyclic list format.
 * Returns duration in seconds at \fBMM\fP=60.
 * Increments pointer to next expression field.
 * Sets \fBPlayer_stat\fP:
 * .in +5
 * .nf
 * to \fBP_HOLD_SET\fP 'if expr ==' \fBHOLDSTR\fP,
 * to \fBP_STOP_SET\fP 'if expr ==' \fBSTOPSTR\fP,
 * to \fBP_KILL_SET\fP 'if expr ==' \fBKILLSTR\fP.
 * .in -5
 * .fi
 * Will stop Player 'if expr ==' \fBSTOPSTR\fP.
 * Will kill Player 'if expr ==' \fBKILLSTR\fP.
 * Returns last value if \fBHOLDSTR\fP is scanned, and does not increment
 * pointer to next expression field.
E 8
E 3
 */
D 8


double 
Rhythm(str) 
	register char *str;
{
	extern char *index();
	char *c, *d, save;
	double sum = 0.0;

D 3
	Player_stat &= ~(P_STOP_SET | P_EXPR_ERR);
	if (!strcmp(str, STOPSTR)) {
		Player_stat |= P_STOP_SET;
		return(-1.0);			/* "Stop" seen */
	}
E 3
I 3
	Player_stat &= ~P_EXPR_ERR;
E 3
	for (c = str, d = index(c, '+'); d != '\0'; d = index(c, '+')) {
		save = *d;
		*d = '\0';
		sum += do_rhy(c);
		*d = save;
		c = d + 1;
		if (*c == '\0') {
			fprintf(stderr, "Rhythm: malformed expression:``%s''",
				str);
			Player_stat |= P_EXPR_ERR;
			return(1.0);	/* return something safe */
		}
	}
	sum += do_rhy(c);
	return(sum);
}

E 2
D 3
double
set_timesig(h, c)
	register struct noteheader *h;
	char *c;
{
	extern char *malloc(), *index();
	register char *slsh, save, *numerator, *denominator;
	register struct timesig *t;

	slsh = index(c, '/');
	if (slsh != NULL) {
		save = *slsh;
		*slsh = NULL;
		denominator = slsh+1;
		numerator = c+1;
	} else {
		fprintf(stderr, "set_timesig: invalid time signature=%s\n", c);
		exit(1);
	}
	if ((t = (struct timesig *) malloc(sizeof(struct timesig))) == NULL)
D 2
		malerr("set_times", 1);
E 2
I 2
		malerr("set_timesig", 1);
E 2
	t->num = atoi(numerator);
	t->den = atoi(denominator);
	*slsh = save;
	if ((t->time_sig = malloc((unsigned) strlen(c)+1)) == NULL)
D 2
		malerr("set_times", 1);
E 2
I 2
		malerr("set_timesig", 1);
E 2
	(void) strcpy(t->time_sig, c);
I 2
	if (h->h_time_sig != NULL) {	/* free old timesig, if any */
		free(h->h_time_sig->time_sig);
		free(h->h_time_sig);
	}
E 2
	h->h_time_sig = t;
I 2
	Player_stat |= P_TIMESIG;
E 2
	return(-2.0);
}

E 3
/*
D 3
 * Get_timesig -      get time signature structure of a cyclic list
 * takes:   
 * 	nl -    string address of cyclic list 
 * returns:  
 * 	the struct timesig * of the cyclic list. 
 * side effects: 
 * 	none. 
 * notes:
 * 	For this to return non-NULL, Rhythms() must have
 * 	scanned a key signature in this list already.
 */

struct timesig *
Get_timesig(nl)
	register char *nl;
{
	register struct noteheader *h;
	register double rtn;
	register char *c;

	h = getid(nl);
	return(h->h_time_sig);
}


double
xRhythm(h, c)
	register struct noteheader *h;
	char *c;
{
	if (*c == TIMESIG)
		return(set_timesig(h, c));
	else
		return(Rhythm(c));
}


/*
E 3
 * Rhythms -	evaluate cyclic list as Rhythm fields
 * takes:	
 *	nl -	pointer to string of Rhythm fields in cyclic list format
 * returns:	
 *	duration in seconds at MM60
 * side effects:	
 *	Increments pointer to next expression field.
 * 	Sets Player_stat:
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
I 6
 * 		to P_KILL_SET if expr == KILLSTR
E 6
 * notes:	
D 6
 *	May stop Player if expr == STOPSTR
E 6
I 6
 *	Will stop Player if expr == STOPSTR
 *	Will kill Player if expr == KILLSTR.
E 6
 *	Returns last value if HOLDSTR is set and does not increment
 *		pointer to next expr field.
 */

double 
Rhythms(nl)
	register char *nl;
E 8
{
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
	register double rtn;
	register char *c;

	h = getid(nl);
	_motive(h, nl);
D 3
	(void) nextnot(h);
I 2
	Player_stat &= ~P_TIMESIG;
E 2
skip:	c = h->np->datum;
	Player_stat &= ~P_HOLD_SET;
	if (!strcmp(HOLDSTR, c)) {
		rtn = xRhythm(h, h->last_val);
E 3
I 3
	Player_stat &= ~(P_STOP_SET|P_HOLD_SET|P_TIMESIG|P_KEYSIG
D 6
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD);
E 6
I 6
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD|P_KILL_SET);
E 6
	do {
		if (nextnot(h) != 0)
D 7
			clr_ac(&h->ac_list);
E 7
I 7
			clr_ac(&h->hcl_aclist);
E 7
D 4
	} while (clist_directive(h) != 0);
E 4
I 4
	} while (clist_direct(h) != 0);
E 4
D 6
	if (h->np->n_stop) {
E 6
I 6
D 7
	if (h->np->n_kill) {	/* kill this player */
E 7
I 7
	if (h->hcl_np->cl_kill) {	/* kill this player */
E 7
		Player_stat |= P_KILL_SET;
D 7
		Self->runstat = P_KILLED;
E 7
I 7
		Self->P_runstat = P_KILLED;
E 7
		return(1.0);
D 7
	} else if (h->np->n_stop) {
E 7
I 7
	} else if (h->hcl_np->cl_stop) {
E 7
E 6
		Player_stat |= P_STOP_SET;
D 7
		Self->runstat = P_STOPPED;
E 7
I 7
		Self->P_runstat = P_STOPPED;
E 7
		return(1.0);
	}
D 7
	else if (h->np->n_hold) {
		rtn = Rhythm(h->last_val) * h->h_metronome;
E 7
I 7
	else if (h->hcl_np->cl_hold) {
		rtn = Rhythm(h->hcl_lastval) * h->hcl_metro;
E 7
E 3
		Player_stat |= P_HOLD_SET;
	} else {
D 3
		if ((rtn = xRhythm(h, c)) == -2.0) {
D 2
			/* part of a chord */
E 2
I 2
			/* just time signature, fetch next field */
E 2
			(void) nextnot(h);
			goto skip;
		}
E 3
I 3
D 7
		c = h->np->datum;
		rtn = Rhythm(c) * h->h_metronome;
E 3
D 2
		rtn = xRhythm(h, c);
E 2
		h->last_val = c;
		if (h->np->chord_element != 0)
E 7
I 7
		c = h->hcl_np->cl_datum;
		rtn = Rhythm(c) * h->hcl_metro;
		h->hcl_lastval = c;
		if (h->hcl_np->cl_chord != 0)
E 7
D 3
			Self->chordstat = TRUE;
		else
			Self->chordstat = FALSE;
	}
	if (Player_stat & P_STOP_SET) {	/* stop this player */
		Self->runstat = P_STOPPED;
		return(1.0);
E 3
I 3
			Player_stat |= P_CHORD;
E 3
	}
	return(rtn);
}
E 1
