h01968
s 00003/00008/00062
d D 2.1 86/01/30 16:39:20 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00070/00000/00000
d D 1.1 85/11/05 22:45:32 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/Player.h>
#include <ctype.h>

/*
 * get_clist -	get next cyclic list from file
 * takes:
 * 	fp -	file pointer
 * returns:	string form of cyclic list
 */

char *
get_clist(fp)
	register FILE *fp;
{
	register int c; 
	char *buf = NULL;

	for (;;) {
		if ((c = getc(fp)) == EOF || c == ';') {
			if (buf == NULL)		/* nothing saved? */
				break;			/* just return */
			else
				(void) strsav(&buf, '\0');/* else terminate */
			break;				/* and return */
		}
		if (buf == NULL && isspace(c))		/* kill initial */
			continue;			/* white space */
		else
			(void) strsav(&buf, c);
	}
	return(buf);
}


Read_lists(file)
D 2
	register char *file;
E 2
I 2
	register char *file;	/* file name containing cyclic list */
E 2
/*
D 2
 * Read all cyclic list strings from a file.
 * .TP 10
 * Takes:
 * file name containing cyclic list statements.
 * .TP 10
 * side effects:
 * Parses cyclic lists, installs them in
E 2
I 2
 * Read all cyclic lists from a file.
 * Parses cyclic lists and labels, and installs them in
E 2
 * symbol table, suitable for ``@'' macro expansion.
 */
{
	register char *cnotes;
	register FILE *fp;

	if ((fp = fopen(file, "r")) == NULL) {
		fprintf(stderr, "Read_list_file: can't read: %s\n", file);
		Pexit(1);
	}

	while ((cnotes = get_clist(fp)) != NULL) {
		extern struct headcl_hcl *newid();
		register struct headcl_hcl *h = newid(cnotes);

		if (buildnotes(h, cnotes) == 0) {
			/* skip over any initial branch nodes */
			nextnot(h);
		}
		free(cnotes);
	}
	(void) fclose(fp);
}
E 1
