h19986
s 00008/00020/00054
d D 2.2 86/01/30 16:32:41 dgl 3 2
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00000/00000/00074
d D 2.1 85/10/26 23:38:39 dgl 2 1
c changed variable names.
e
s 00074/00000/00000
d D 1.1 84/12/21 12:02:57 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <setjmp.h>
# include <signal.h>
# include <sys/time.h>
# include <math.h>

static jmp_buf	jbuf;

D 3
/*
 * Psleep -	floating point sleep routine
 * takes:
 * 	interval -	time in real seconds, including fractional time,
 * 	precise down to microseconds, accurate only to system
 * 	clock rate
 * note:
 *	preferred over sleep() because of the ability to specify
 *	fractions of seconds.
 * note:
 * 	if interval == 0, the timer is disabled, and Psleep hangs
 */

# ifdef P_FLOAT
E 3
Psleep(interval)
	float interval;
I 3
/*
 * Floating point sleep routine for 4.2BSD
 * .LP
 * Takes time in real seconds (including fractional time),
 * precise down to microseconds, accurate only to system
 * clock rate.
 * If 'interval == 0', the timer is disabled, and Psleep hangs.
 */
E 3
{
	extern void catchalarm();
	struct itimerval val, oval;
	register long tmp;

	signal(SIGALRM, catchalarm);

	if (setjmp(jbuf))
		return;

	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = 0;
	val.it_value.tv_sec = tmp = interval;
	val.it_value.tv_usec = (interval - tmp) * 1000000.0;

	setitimer(ITIMER_REAL, &val, &oval);

	pause();
}

void
catchalarm() 
{
	longjmp(jbuf, 1);
}
D 3
# else P_FLOAT
Psleep(interval)
	long interval;
{}
# endif P_FLOAT

E 3

/*
 * main(argc, argv)
 * 	char **argv;
 * {
 * 	extern char *ctime();
 * 	struct timeval timeval; 
 * 	struct timezone timezone;
 * 	printf("!\n");
 * 	if (argc > 1) {
 * 		gettimeofday(&timeval, &timezone);
 * 		printf(ctime(&timeval.tv_sec));
 * 		Psleep(atof(argv[1]));
 * 		gettimeofday(&timeval, &timezone);
 * 		printf(ctime(&timeval.tv_sec));
 * 	}
 * }
 */
E 1
