h61682
s 00012/00028/00017
d D 2.2 86/01/30 16:32:21 dgl 4 3
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00001/00001/00044
d D 2.1 85/10/26 23:38:24 dgl 3 2
c changed variable names.
e
s 00013/00001/00032
d D 1.2 85/09/30 13:54:11 dgl 2 1
c made return value contional on P_FLOAT.
e
s 00033/00000/00000
d D 1.1 84/12/21 12:02:18 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

I 4

P_TYPE P(vp, n)
	register Player	*vp;	/* pointer to Player instance data,
	register int	n;	/* P-variable index */
E 4
/*
D 4
 * P -	fetch P field from another Player
 * takes:
 * 	vp -	pointer to Player instance data
 * 	n -	P field index
 * returns:
 * 	value, if found, otherwise 0.0
 * side effects:
 * 	Sets Player_stat to P_NO_PARAM if no such P field.
 * 	Sets Player_stat to P_NULL_PTR if no such Player.
E 4
I 4
 * Fetch \fBP\fP-variable from a Player instance.
 * .LP
 * Returns value of \fBP\fP-variable.
 * Sets \fBPlayer_stat\fP to \fBP_NO_PARAM\fP if no such \fBP\fP-variable, 
 * and returns 0.
 * Sets \fBPlayer_stat\fP to \fBP_NULL_PTR\fP if no such Player, and returns 0.
E 4
 */
D 4

I 2
# ifdef P_FLOAT
E 2
double 
I 2
# else P_FLOAT
long
# endif P_FLOAT
E 2
P(vp, n)
	register Player *vp;
	register int n;
E 4
{
	Player_stat &= ~(P_NULL_PTR | P_NO_PARAM);
	if (vp == NULL) {
		Player_stat = P_NULL_PTR;
D 2
		return(NULL);
E 2
I 2
D 4
# ifdef P_FLOAT
		return(0.0);
# else P_FLOAT
		return(0);
# endif P_FLOAT
E 4
I 4
		return(ZERO);
E 4
E 2
	}
		
	if (ckmaxp(vp, n) == -1) {
		Player_stat = P_NO_PARAM;
I 2
D 4
# ifdef P_FLOAT
E 2
		return(0.0);
I 2
# else P_FLOAT
		return(0);
# endif P_FLOAT
E 4
I 4
		return(ZERO);
E 4
E 2
	}
D 3
	return(vp->pn[n]);
E 3
I 3
	return(vp->P_pn[n]);
E 3
}
E 1
