h48344
s 00018/00025/00058
d D 2.1 86/01/30 16:39:43 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00083/00000/00000
d D 1.1 85/11/06 12:38:21 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

extern double Scale[];

double Keys(nl)
	register char *nl;
/*
D 2
 * Evaluate string as cyclic list of Pitch expressions, return piano key index.
 * .TP
 * Takes:	
 * pointer to string of Pitch expressions in cyclic list format.
 * .TP
 * Returns:	
 * pitch in semitones above A0 of evaluated field.
 * .TP
 * Side effects:	
 * Increments pointer to next expression field.  Sets Player_stat:
 * .br
 * 		to P_HOLD_SET if expr == HOLDSTR
 * .br
 * 		to P_STOP_SET if expr == STOPSTR
 * .br
 * 		to P_REST_SET if expr == RESTR
 * .br
 * 		to P_KILL_SET if expr == KILLSTR
 * .TP
 * Notes:	
 * Will stop Player if expr == STOPSTR.
 * Will kill Player if expr == KILLSTR.
 * Effect can be undone by resetting Player_stat before Player returns.
 * Returns last value if HOLDSTR is set and does not increment
 * 	pointer to next expr field.
E 2
I 2
 * Evaluate string as cyclic list of \fBPitch\fP expressions, 
 * return piano key index.
 * .LP
 * Takes pointer to string of \fBPitch\fP expressions in cyclic list format.
 * Returns pitch in semitones above \fIA0\fP of evaluated field.
 * Increments pointer to next expression field.  Sets \fBPlayer_stat\fP:
 * .in +5
 * .nf
 * to \fBP_HOLD_SET\fP 'if expr == \fBHOLDSTR\fP',
 * to \fBP_STOP_SET\fP 'if expr == \fBSTOPSTR\fP',
 * to \fBP_REST_SET\fP 'if expr == \fBRESTR\fP',
 * to \fBP_KILL_SET\fP 'if expr ==' \fBKILLSTR\fP.
 * .in -5
 * .fi
 * Will stop Player if 'expr ==' \fBSTOPSTR\fP.
 * Will kill Player if 'expr ==' \fBKILLSTR\fP.
 * Returns previous value if \fBHOLDSTR\fP is scanned, and does not increment
 * pointer to next expression field.
E 2
 */
{
	struct headcl_hcl *h;
	int pc;
	double pitch;
	char *c;

	h = getid(nl);
	_motive(h, nl);
	Player_stat &= ~(P_STOP_SET|P_HOLD_SET|P_TIMESIG|P_KEYSIG
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD|P_KILL_SET);
	do {
		if (nextnot(h) != 0)
			clr_ac(&h->hcl_aclist);
	} while (clist_direct(h) != 0);
	if (h->hcl_np->cl_kill) {	/* kill this player */
		Player_stat |= P_KILL_SET;
		Self->P_runstat = P_KILLED;
		return(1.0);
	} else if (h->hcl_np->cl_stop) {	/* stop this player */
		Player_stat |= P_STOP_SET;
		Self->P_runstat = P_STOPPED;
		return(1.0);	/* return something safe */
	}
	else if (h->hcl_np->cl_hold) {
		c = h->hcl_lastval;
		pc = pc_oct(c, &h->hcl_oct, &h->hcl_aclist);
		Player_stat |= P_HOLD_SET;
	} else {
		c = h->hcl_np->cl_datum;
		pc = pc_oct(c, &h->hcl_oct, &h->hcl_aclist);
		h->hcl_lastval = c;
		if (h->hcl_np->cl_chord != 0)
			Player_stat |= P_CHORD;
	}
	if (Player_stat & P_REST_SET) {
 		Self->P_reststat = TRUE;
		return(1.0);	/* return something safe */
	}
	if (Player_stat & P_EXPR_ERR) {	/* unknown note specification */
		fprintf(stderr, "Keys: unknown note spec.:``%s''\n", c);
		return(1.0);
	}
	pitch = pc + (PITCHES * (h->hcl_oct + 4.0));
	return(pitch);
}
E 1
