h30088
s 00025/00019/00037
d D 2.2 86/01/30 16:31:57 dgl 4 3
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00009/00009/00047
d D 2.1 85/10/26 23:38:05 dgl 3 2
c changed variable names.
e
s 00006/00001/00050
d D 1.2 85/10/14 15:39:42 dgl 2 1
c fixed bug re. list traversal over null note data.
e
s 00051/00000/00000
d D 1.1 84/12/21 12:01:40 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

D 4
/*
 * Index -	move Finite State Automaton pointer
 * takes:	
 *	nl - pointer to string of fields in cyclic list format
 * 	offset - offset
 * 	whence - where to offset from
 * 		0 == offset from beginning of list
 * 		1 == offset from current field pointer position
 * 		2 == offset from end of list
 * returns:	
 *	string value of FSA
 * side effects:	
 *	Resets loop counts on cyclic list if whence == 0 or 2.
 *	Sets Player_stat to P_WRAP if the cyclic list wraps around or
 *	is reset as described in the previous sentence.
 */
E 4

char *
Index(nl, offset, whence)
D 4
	register char *nl;
	register int offset;
	register int whence;
E 4
I 4
	register char *nl;	/* pointer to string in cyclic list format */
	register int offset;	/* offset from */
	register int whence;	/* beginning, current, or end of list */
/*
 * Index a cyclic list.
 * .LP
 * Operation of offset and whence is like the standard UNIX `lseek`(2).
 * 'offset' may be negative.
 * Values for 'whence':
 * .RS
 * .TP 10
 * 0
 * offset from beginning of list,
 * .TP
 * 1
 * offset from current field pointer position,
 * .TP
 * 2
 * offset from end of list.
 * .RE
 * Returns string pointer to newly addressed cyclic list field.
 * Resets loop counts on cyclic list if 'whence == 0 or 2'.
 * Sets \fBPlayer_stat\fP to \fBP_WRAP\fP if the cyclic list wraps around or
 * if loop counts are reset.
 */
E 4
{
D 3
	register struct noteheader *h = getid(nl);
E 3
I 3
	register struct headcl_hcl *h = getid(nl);
E 3
	register int incr;

	_motive(h, nl);

	switch (whence) {
		case 1:	/* offset from current position */
			break;
		case 0:	/* offset from head of list */
I 2
D 3
			h->np = h->nh;
E 3
I 3
			h->hcl_np = h->hcl_nh;
E 3
			if (offset == 0)	/* skip dummy node */
D 3
				h->np = h->np->nxtnot;
E 3
I 3
				h->hcl_np = h->hcl_np->cl_next;
E 3
			rebuild_list(h);
			break;
E 2
		case 2:	/* offset from tail of list */
D 2
			h->np = whence == 0 ? h->nh : h->nt;
E 2
I 2
D 3
			h->np = h->nt;
E 3
I 3
			h->hcl_np = h->hcl_nt;
E 3
E 2
			rebuild_list(h);
			break;
	}
D 3
	incr = h->incr;		/* save list's increment */
	h->incr = offset;	/* stick in ours */
E 3
I 3
	incr = h->hcl_incr;		/* save list's increment */
	h->hcl_incr = offset;	/* stick in ours */
E 3
	if (nextnot(h) != 0)	/* do it */
D 3
		clr_ac(&h->ac_list);
	h->incr = incr;		/* put it back */
	return(h->np->datum);
E 3
I 3
		clr_ac(&h->hcl_aclist);
	h->hcl_incr = incr;		/* put it back */
	return(h->hcl_np->cl_datum);
E 3
}
E 1
