h30727
s 00007/00008/00028
d D 2.1 86/01/30 16:39:04 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00036/00000/00000
d D 1.1 85/11/05 22:04:49 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>
#include "debug.h"

D 2
/*
 * Direction - set direction of FSA traversal
 * takes:
 *	x -	string address of cyclic list
 *	increment - set direction and step size  
 */
E 2

Direction(x, increment)
D 2
	register char *x;
	register int increment;
E 2
I 2
	register char *x;	/* string address of cyclic list */
	register int increment;	/* sets direction and step size */
/*
 * Set direction of cyclic list traversal.
 * Subsequent evaluation routines will increment (or decrement)
 * the expression pointer by the value of 'increment', with wraparound.
 */
E 2
{
	register struct headcl_hcl *h;
	register struct hlist *hl;

	Player_stat &= ~P_NULL_PTR;
	if ((hl = lookup(x, AT_CYCLIST)) == NULL) {
		Player_stat |= P_NULL_PTR;
		return(0);
	}
	if ((h = hl->hl_val.st_cycl) != NULL) {
		register int dir = h->hcl_incr;

		h->hcl_incr = increment;
		return(dir);
	}
	Player_stat |= P_NULL_PTR;
	return(0);
}
E 1
