h26030
s 00014/00039/00415
d D 2.7 88/10/29 23:12:21 dgl 16 15
c Fixed usage() statement.
e
s 00003/00004/00451
d D 2.6 88/10/29 23:03:40 dgl 15 14
c Init file now in /tmp, and settable via -I.
e
s 00018/00013/00437
d D 2.5 88/10/28 22:12:56 dgl 14 13
c Initfile now generated from mktemp().
e
s 00039/00011/00411
d D 2.4 88/10/28 16:10:05 dgl 13 12
c Now works with remote directories.
e
s 00002/00000/00420
d D 2.3 88/09/20 15:37:01 dgl 12 11
c fixed cc to emit a -o flag for compiling in remote directories.
e
s 00024/00006/00396
d D 2.2 88/09/20 15:27:00 dgl 11 10
c added support for -D flags to C compiler.
e
s 00000/00000/00402
d D 2.1 85/10/26 23:48:29 dgl 10 9
c 
e
s 00001/00001/00401
d D 1.9 85/10/26 23:34:27 dgl 9 8
c changes to variable names.
e
s 00020/00008/00382
d D 1.8 85/10/14 10:51:10 dgl 8 7
c main() is now added by Player.c if not in users file.
e
s 00024/00016/00366
d D 1.7 85/10/09 09:32:39 dgl 7 6
c New regime for generating tmPlayer.c
e
s 00003/00003/00379
d D 1.6 85/10/01 16:44:33 dgl 6 5
c modified generation of tmPlayer.c to conform to new startup
c procedure for Players with mk_Player.
e
s 00003/00002/00379
d D 1.5 85/10/01 14:15:29 dgl 5 4
c in integer mode, put main() in tmPlayer.c.
e
s 00004/00004/00377
d D 1.4 85/09/20 12:16:32 dgl 4 3
c fixed up usage() statements.
e
s 00021/00016/00360
d D 1.3 85/09/19 14:14:33 dgl 3 2
c now emits instantiation routine names without '$' char in them.
e
s 00010/00004/00366
d D 1.2 85/01/10 15:15:08 dgl 2 1
c added -L flag to avoid loading
e
s 00370/00000/00000
d D 1.1 84/12/21 11:52:06 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/Player.h>
I 13
#include <strings.h>
E 13
#define CPP "/lib/cpp"
#define CC "cc -c"
D 14
#define LD "ld -X /lib/crt0.o -o "
E 14
I 14
#define LD "ld -X /lib/crt0.o "
E 14
#define NM "nm -n"
/* make this get dynamic files */
D 14
#define TMP "mpXXXXXX"
E 14
I 14
D 15
#define TMP "PXXXXXX"
E 15
I 15
#define TMP "/tmp/PXXXXXX"
E 15
E 14
#define FHEADER "<carl/Player.h>"
#define IHEADER "<carl/iPlayer.h>"
#define LIBS " -lPlayer -lcarl -lm -lc"
#define iLIBS " -liPlayer -lcarl -lc"
#define SUN_gLIBS " -lPlayer -lcarl -lm -lc -lg"
#define SUN_giLIBS " -liPlayer -lcarl -lm -lc -lg"
#define QP "cueue_players"
#define M_START "M_start"
#define M_TER "M_ter"
I 8
#define MAIN "main"
E 8
#define MSTART 	1
#define MTER 	2
I 8
#define HASMAIN	4
E 8

#define MONLY 1
#define CONLY 2

#define DOTPFILE 'P'
D 13
#define DOTmFILE 'm'
E 13
#define DOTcFILE 'c'
#define DOToFILE 'o'
D 13
extern char *chsuf(), filtyp(), *mkinit();
E 13
I 13
D 14
#define LFILE	 ".L.c"
E 14
D 16
extern char *suf(), *chsuf(), filtyp(), *mkinit();
E 16
I 16
extern char *chsuf(), filtyp(), *mkinit();
E 16
E 13
extern char *malloc();
int m_flag;
int p_flag = 1;
int r_flag;
int globs;
char *globstr = "-g ";
I 11
char *defstrs[32];
int	defcnt;
E 11
char **symary;
long symcnt;
int integer;
int optimize;
I 2
int loader = 1;
E 2

main(argc, argv)
	int argc;
	char **argv;
{
I 14
	extern char *mktemp();
E 14
	float input, output;
	int cnt, cmpflg = 0;
D 13
	char ch, *exe = NULL, *initc, *inito;
E 13
I 13
D 14
	char ch, *exe = "a.out", *initc, *inito;
E 14
I 14
	char ch, *Ifile, *initc, *inito;
E 14
E 13

I 14
D 15
	if ((Ifile = (char *) malloc(128)) == NULL) {
E 15
I 15
	if ((Ifile = (char *) malloc(strlen(TMP)+3)) == NULL) {
E 15
		perror("malloc");
		exit(1);
	}
	sprintf(Ifile, "%s%s", mktemp(TMP), ".c");

E 14
D 2
	while ((ch = crack(argc, argv, "imPOchprg|o|", 0)) != NULL) {
E 2
I 2
D 11
	while ((ch = crack(argc, argv, "imPLOchprg|o|", 0)) != NULL) {
E 11
I 11
D 15
	while ((ch = crack(argc, argv, "imPLOchprD|g|o|", 0)) != NULL) {
E 15
I 15
	while ((ch = crack(argc, argv, "iPLOchprD|g|I|", 0)) != NULL) {
E 15
E 11
E 2
		switch (ch) {
			case 'i':
				integer = 1;
				break;
			case 'P':
D 15
			case 'm':
E 15
				cmpflg = MONLY;
				break;
I 2
			case 'L':
				loader = 0;
				break;
E 2
			case 'O':
				optimize = 1;
				break;
			case 'c':
				cmpflg = CONLY;
				break;
D 14
			case 'o':
				exe = arg_option;
E 14
I 14
			case 'I':
				Ifile = arg_option;
E 14
				break;
			case 'p':
				p_flag = 0;
				break;
			case 'r':
				r_flag++;
				break;
			case 'g':
				globs++;
				r_flag++;
				globstr[2] = arg_option[0];
				break;
I 11
			case 'D':
				defstrs[defcnt] = (char *) malloc(strlen(arg_option)+3);
				strcpy(defstrs[defcnt++], arg_option-2);
				break;
E 11
			case 'h':	
				usage(0);
				break;
			default:
				usage(1);
				break;
		}
	}

	for (cnt = arg_index; cnt < argc; cnt++) {
		switch(filtyp(argv[cnt])) {
			case DOTPFILE:	/* x.P ==> x.c */
D 13
			case DOTmFILE:	/* x.m ==> x.c */
E 13
				if (Playery(argv[cnt])) 
					exit(1);
				if (cmpflg == MONLY) 
					exit(0);
				/* no break */
			case DOTcFILE: 	/* x.c ==> x.o */
				if (cc(chsuf(argv[cnt], DOTcFILE))) 
					exit(1);
				if (cmpflg == CONLY) 
					exit(0);
				/* no break */
			case DOToFILE: 	/* collect symbols from x.o */
				if (nm(chsuf(argv[cnt], DOToFILE))) exit(1);
				break;
			default:	/* who knows? */
				break;
		}
	}
	if (symcnt == 0) {
		fprintf(stderr, "Player: no Players!\n");
		exit(1);
	}
	/* make init_players() subroutine to call players */
D 13
	initc = mkinit();
E 13
I 13
D 14
	initc = mkinit(suf(exe, LFILE));
E 14
I 14
	initc = mkinit(Ifile);
E 14
E 13
	/* glue the whole thing together */
D 2
	ld(exe, inito = chsuf(initc, DOToFILE), &argv[arg_index]);
E 2
I 2
	if (loader)
D 14
		ld(exe, inito = chsuf(initc, DOToFILE), &argv[arg_index]);
E 14
I 14
		ld(inito = chsuf(initc, DOToFILE), &argv[arg_index]);
E 14
E 2
	if (!r_flag) {
		if (p_flag) fprintf(stderr, "rm %s\n", initc);
		unlink(initc);
		if (p_flag) fprintf(stderr, "rm %s\n", inito);
		unlink(inito);
	}
	exit(0);
}

usage(exitcode)
	int exitcode;
{
D 16
fprintf(stderr, "usage: Player [flags] {file.P,file.c,file.o}... -l...\n");
D 2
fprintf(stderr, "%s%s%s%s%s%s%s%s",
E 2
I 2
fprintf(stderr, "%s%s%s%s%s%s%s%s%s",
E 2
"flags:\n",
D 4
"-c\tcompile only, do not load\n",
"-P\trun Player preprocessor only, do not compile\n",
D 2
"-oX\tname of output file is X (default: a.out)\n",
E 2
I 2
"-L\tcompile only, do not load\n",
E 4
I 4
"-P\trun Player preprocessor only\n",
"-c\trun preprocessor and C compiler only\n",
"-L\trun preprocessor, C compiler and nm, do not run ld\n",
E 4
"-oX\tname the output file X (default: a.out)\n",
E 2
"-g\tload symbol table\n",
"-p\tdo not print actions on stderr\n",
D 4
"-r\tdo not remove temporary C files tmPlayer.{c,o}\n",
E 4
I 4
D 13
"-r\tdo not remove temporary C files tmPlayer.[co]\n",
E 13
I 13
"-r\tdo not remove temporary Player link files\n",
E 13
E 4
"-h\tprint this message\n"
E 16
I 16
fprintf(stderr, 
"usage: Player [Player flags] file.[Pco]... [other files, flags]...\n");
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s",
"Player flags:\n",
"\t-P\trun Player preprocessor only\n",
"\t-c\trun preprocessor and C compiler only\n",
"\t-L\trun preprocessor, C compiler and nm, do not run ld\n",
"\t-g\tload symbol table\n",
"\t-p\tdo not print actions on stderr\n",
"\t-IX.c\tname temporary Player init file X.c\n",
"\t-r\tdo not remove temporary Player init files\n",
"\t-h\tprint this message\n",
"other files and flags include libraries, loader options, etc.\n"
E 16
);
exit(exitcode);
}


char *chsuf(file, sub)
	char *file, sub;
{
	extern char *rindex();
	char *c, *x; 
	int len = strlen(file);

	if (len <= 0)
		return(NULL);
D 13
	if (rindex(file, '.') == NULL)
E 13
I 13
	if ((x = rindex(file, '.')) == NULL)
E 13
		return(NULL);
I 13
	if (*(x+1) == '/')
		return(file);
E 13
	if ((x = malloc(len+1)) == NULL) {
		perror("malloc");
		exit(1);
	}
	(void) strcpy(x, file);
	if ((c = rindex(x, '.')) != NULL) {
		if (*(c+1) == 'a')	/* library */
			return(NULL);
		else
			*(c+1) = sub;
D 16
	} else
		return(NULL);
	return(x);
}

I 13
char *suf(file, suf)
	char *file, *suf;
{
	extern char *rindex();
	char *c, *x; 
	int flen, slen;

	flen = strlen(file);
	slen = strlen(suf);

	if (flen <= 0)
		return(NULL);
	if (rindex(file, '.') == NULL)
		return(NULL);
	if ((x = malloc(flen+slen+1)) == NULL) {
		perror("malloc");
		exit(1);
	}
	(void) strcpy(x, file);
	if ((c = rindex(x, '.')) != NULL) {
		*c = '\0';
		(void) strcat(x, suf);
E 16
	} else
		return(NULL);
	return(x);
}

E 13
char filtyp(file)
	char *file;
{
	extern char *rindex();
	char *c; 

	if (file == NULL)
		return('\0');
	if ((c = rindex(file, '.')) == NULL)
		return(-1);
	return(*(c+1));
}

Playery(mfile)
	char *mfile;
{
D 11
	char buf[BUFSIZ], *cfile, *flags;
E 11
I 11
	char buf[BUFSIZ], *cfile, *flags, cpp[BUFSIZ];
E 11

	cfile = chsuf(mfile, DOTcFILE);
	if (integer)
		flags = "-i";
	else
		flags = " ";
I 11
	sprintf(cpp, "%s ", CPP);
	if (defcnt != 0) {
		int	i;
		for (i = 0; i < defcnt; i++)
			sprintf(cpp, "%s %s ", cpp, defstrs[i]);
	}
E 11
	/* /lib/cpp ${ofile} | ${PLAYERY} > ${rofile}.c */
D 11
	sprintf(buf, "%s %s | %s %s > %s", CPP, mfile, PLAYERY, flags, cfile);
E 11
I 11
	sprintf(buf, "%s %s | %s %s > %s", cpp, mfile, PLAYERY, flags, cfile);
E 11
	free(cfile);
	if (p_flag) 
		fprintf(stderr, "%s\n", buf);
	if (system(buf)) {
		fprintf(stderr, "Player failed on Playery\n");
		return(-1);
	}
	return(0);
}

cc(cfile)
	char *cfile;
{
	char buf[BUFSIZ];
I 12
	char *ofile;
E 12

	if (globs)
D 11
		sprintf(buf, "%s %s %s", CC, globstr, cfile);
E 11
I 11
		sprintf(buf, "%s %s ", CC, globstr);
E 11
	else if (optimize)
D 11
		sprintf(buf, "%s %s %s", CC, "-O", cfile);
E 11
I 11
		sprintf(buf, "%s %s ", CC, "-O");
E 11
	else
D 11
		sprintf(buf, "%s %s", CC, cfile);
E 11
I 11
		sprintf(buf, "%s ", CC);
	if (defcnt != 0) {
		int	i;
		for (i = 0; i < defcnt; i++)
			sprintf(buf, "%s %s ", buf, defstrs[i]);
	}
	sprintf(buf, "%s %s", buf, cfile);
I 12
	sprintf(buf, "%s -o %s", buf, chsuf(cfile, DOToFILE));
E 12
E 11
	if (p_flag) 
		fprintf(stderr, "%s\n", buf);
	if (system(buf)) {
		fprintf(stderr, "Player failed on cc\n");
		return(-1);
	}
	return(0);
}

char *
D 3
vsymp(symbol)
E 3
I 3
Psymp(symbol)
E 3
	char *symbol;
{
D 3
	char *c, *index();
E 3
I 3
	char	*c,
		*index();
	char	name[128];
	int	addr;
	char	type;
E 3

D 8
	/* is it an m_start or m_ter symbol? */
E 8
I 8
	/* is it a main(), m_start() or m_ter() symbol? */
E 8
	if ((c = index(symbol, '_')) != NULL) {
D 8
		if (!strcmp(c+1, M_START)) {
E 8
I 8
		if (!strcmp(c+1, MAIN)) {
			m_flag |= HASMAIN;
			return(NULL);
		} else if (!strcmp(c+1, M_START)) {
E 8
			m_flag |= MSTART;
			return(NULL);
		} else if (!strcmp(c+1, M_TER)) {
			m_flag |= MTER;
			return(NULL);
		}
	}
	/* is it a player initialization symbol? */
D 3
	if ((c = index(symbol, '$')) == NULL)
E 3
I 3
	if (sscanf(symbol, "%x %c %s", &addr, &type, name) != 3)
E 3
		return(NULL);
D 3
	/* _$$<player_name> ==> vlist initialization */
	if (*(c-1) == '_' && *(c+1) == '$')
		return(c);
	/* __$<player_name> ==> init static players */
	if (*(c-1) == '_' && *(c-2) == '_')
		return(c-1);
E 3
I 3
	/* is it a class template-stuffing routine? */
	if (!strncmp("_PC_", name, 4))
		return(c+1);
	/* is it a preset instance-stuffing routine? */
	if (!strncmp("_PP_", name, 4))
		return(c+1);
E 3
	return(NULL);
}


nm(file)
	char *file;
{
	FILE *pp, *popen();
	char tmp[BUFSIZ], *c;
	char *base, *sym;

	sprintf(tmp, "%s %s", NM, file);
	if (p_flag) 
		fprintf(stderr, "%s\n", tmp);
	pp = popen(tmp, "r");
	if (pp == NULL) {
		fprintf(stderr, "Player: nm: popen failed: %s\n", tmp); 
		return(-1);
	}
	while (fgets(tmp, BUFSIZ, pp) != NULL) {
		c = (char *) index(tmp, '\n'); 	/* zap return */ 
		if (c != NULL) 
			*c = NULL;
D 3
		if ((sym = vsymp(tmp)) != NULL)
E 3
I 3
		if ((sym = Psymp(tmp)) != NULL)
E 3
			symcnt = strsav(&symary, sym);
	}
	pclose(pp);
	return(0);
}


char *
D 13
mkinit()
E 13
I 13
mkinit(file)
	char *file;
E 13
{
	int i, j, k;
	FILE *fp, *fopen();
	static char *buf[13];
	char *c;

D 7
# ifdef NOTDEF
	strcpy(buf, TMP);
	mktemp(buf);
	strcat(buf, ".c");
	if ((fp = fopen(buf, "w")) == NULL) {
		perror("fopen");
		return(NULL);
	}
# endif NOTDEF
E 7
D 13
	strcpy(buf, "tmPlayer.c");
E 13
I 13
	strcpy(buf, file);
E 13
	if ((fp = fopen(buf, "w")) == NULL) {
		perror("fopen");
		return(NULL);
	}
D 5
	if (integer)
E 5
I 5
D 8
	if (integer) {
E 8
I 8
	if (integer)
E 8
E 5
D 7
		fprintf(fp, "# include %s\n", IHEADER);
E 7
I 7
		fprintf(fp, "# define P_INTEGER\n");
D 8
/*		fprintf(fp, "# include %s\n", IHEADER); */
		fprintf(fp, "# include %s\n", FHEADER);
E 7
D 5
	else
E 5
I 5
		fprintf(fp, "main()\n{\n\tPmain();\n}\n");
D 7
	} else
E 7
I 7
	} else {
E 8
I 8
	else
E 8
		fprintf(fp, "# define P_FLOAT\n");
E 7
E 5
D 8
		fprintf(fp, "# include %s\n", FHEADER);
E 8
I 8
	fprintf(fp, "# include %s\n", FHEADER);
	if (!(m_flag & HASMAIN)) {
		if (integer) {
			fprintf(fp, "main()\n{\n");
			fprintf(fp, "\tPmain();\n");
		} else {
			fprintf(fp, "main(argc, argv)\n\tchar **argv;\n{\n");
			fprintf(fp, "\tPmain(argc, argv);\n");
		}
		fprintf(fp, "\tPexit(0);\n");
		fprintf(fp, "}\n");
E 8
I 7
	}
E 7
	fprintf(fp, "%s() \n{\n", QP);
	for (i = j = k = 0; i < symcnt; i++) {
D 3
		if (!strncmp(symary[i], "$$", 2))
E 3
I 3
		if (!strncmp(symary[i], "PC_", 3))
E 3
D 6
			fprintf(fp, "\tPlayer *\tC%s = mk_Player(&plist);\n", 
E 6
I 6
D 7
			fprintf(fp, "\tPlayer *\tC%s = (Player *) calloc(1, sizeof(Player));\n", 
E 6
				symary[i]);
E 7
I 7
			fprintf(fp, "\textern void %s();\n", symary[i]);
E 7
		else
I 7
			fprintf(fp, "\textern Player *%s();\n", symary[i]);
	}
	fprintf(fp, "\n");
	for (i = j = k = 0; i < symcnt; i++) {
		if (!strncmp(symary[i], "PC_", 3))
			fprintf(fp, "\tPlayer *\tC%s = (Player *) calloc(1, sizeof(Player));\n", symary[i]);
# ifdef NOTDEF
		else
E 7
D 3
			fprintf(fp, "\tPlayer *\tI%s = mk_Player(&ilist);\n", 
E 3
I 3
D 6
			fprintf(fp, "\tPlayer *\tP%s = mk_Player(&ilist);\n", 
E 3
				symary[i]);
E 6
I 6
			fprintf(fp, "\tPlayer *\tP%s =  mk_Player(CPC%s);\n", 
				symary[i], &symary[i][2]);
I 7
# endif NOTDEF
E 7
E 6
	}
	for (i = j = k = 0; i < symcnt; i++) {
D 3
		if (!strncmp(symary[i], "$$", 2))
E 3
I 3
D 7
		if (!strncmp(symary[i], "PC_", 3))
E 3
			fprintf(fp, "\t%s(C%s);\n", 
				symary[i], symary[i]);
E 7
I 7
		if (!strncmp(symary[i], "PC_", 3)) {
			fprintf(fp, "\t%s(C%s);\n", symary[i], symary[i]);
D 9
			fprintf(fp, "\twhile (C%s->n_children--)\n",symary[i]);
E 9
I 9
			fprintf(fp, "\twhile (C%s->P_children--)\n",symary[i]);
E 9
			fprintf(fp, "\t\t(void) PP_%s(C%s);\n", 
				&symary[i][3], symary[i]);
		}
# ifdef NOTDEF
E 7
D 3
		else
			fprintf(fp, "\t%s(I_%s, C$%s);\n", 
				symary[i], symary[i]+1, symary[i]+1);
E 3
I 3
		else {
			fprintf(fp, "\t%s(P%s, CPC%s);\n", 
				symary[i], symary[i], &symary[i][2]);
		}
I 7
# endif NOTDEF
E 7
E 3
	}
	fprintf(fp, "}\n");
	if (!(m_flag & MSTART)) 
		fprintf(fp, "%s()\n{\n}\n", M_START);
	if (!(m_flag & MTER)) 
		fprintf(fp, "%s()\n{\n}\n", M_TER);
	fclose(fp);
	if (cc(buf)) 
		exit(1);
	return((char *) buf);
}

D 14
ld(exe, initfile, ftl)
	char 	*exe, 		/* name of executable file */
		*initfile,	/* name of init file */
E 14
I 14
ld(initfile, ftl)
	char 	*initfile,	/* name of init file */
E 14
		**ftl;		/* names of files to be loaded */
{
	char buf[BUFSIZ], *ofile, *name;

D 13
	if (exe == NULL)
		exe = "a.out";
E 13
D 14
	/* ld -X /lib/crt0.o -o a.out vXX.o PlayerXXXXXX.o -l... -lc */
	(void) sprintf(buf, "%s %s ", LD, exe);
E 14
I 14
	/* ld -X /lib/crt0.o vXX.o PlayerXXXXXX.o -l... -lc */
	(void) sprintf(buf, "%s ", LD);
E 14
	for ( ; *ftl != NULL; ftl++) {
		if ((name = chsuf(*ftl, DOToFILE)) != NULL)
			(void) strcat(buf, name);
		else
			(void) strcat(buf, *ftl);
		(void) strcat(buf, " ");
	}
	strcat(buf, initfile);
	if (globs && !integer)
		strcat(buf, SUN_gLIBS);
	else if (globs && integer)
		strcat(buf, SUN_giLIBS);
	else if (!globs && integer)
		strcat(buf, iLIBS);
	else if (!globs && !integer)
		strcat(buf, LIBS);
	if (p_flag) 
		fprintf(stderr, "%s\n", buf);
	if (system(buf)) {
		fprintf(stderr, "Player failed on ld\n");
		return(-1);
	}
	return(0);
}
E 1
