#include <stdio.h>
#include <carl/carl.h>
#include <carl/defaults.h>
#include <carl/procom.h>

/*
 * rdheader - read a header from stdin, format and print it on stdout,
 * optionally print any samples after the header.
 * If no header, data read will be interpreted as floats.
 */

main(argc, argv)
	char **argv;
{
	register int (*getsamp)(), (*putsamp)();
	PROP *proplist;
	short pdata;
	float f, *pf = &f;
	short s, *ps = &s;
	unsigned *x;
	char ch;
	register int otty = isatty(1), cnt = 0;

	while ((ch = crack(argc, argv, "d", 0)) != NULL) {
		if (ch == 'd')
			pdata++;
	}

	if ((proplist = getheader(stdin)) != NULL) {	/* there is a header */
		noautocp();				/* suppress hdr copy */
		printprop(proplist, stdout);		/* print it on stdout */
	} else {
		fprintf(stderr, "rdheader: no header\n");
	}
	if (pdata) {
		if (!strcmp(H_SHORTSAM, getprop(stdin, H_FORMAT))) {
			getsamp = fgetshort;
			putsamp = fputfloat;
			x = (unsigned *) ps;
		} else {
			getsamp = fgetfloat;
			putsamp = fputfloat;
			x = (unsigned *) pf;
		}
		while ((*getsamp)(x, stdin) > 0) {
			if (otty)
				printf("%d\t%f\n",
					cnt++,
					x == (unsigned *) pf
						? f
						: (s/32767.0));
			else
				(*putsamp)(&x, stdout);
		}
	}

	exit(0);
}
