#include <stdio.h>
#include <carl/carl.h>
#include <carl/defaults.h>
#include <sys/types.h>

/*
 * to compile: cc btoa.c -lsf 
 */

/* define some useful data formats we want to print */
# define FLOAT 		1
# define DECIMAL 	2
# define OCTAL 		4
# define HEXIDECIMAL 	8
# define DEFAULT 	16
# define MAX		32

/* largest positive integer, machine-independent representation */
# define INT_INFINITY ((unsigned) -1 >> 1)

main(argc, argv)
	int argc;
	char **argv;
{
	float 
		input, 		/* input sample */
		srate = FDEFSR;	/* default sampling rate */
				/* defined in sndio.h, = 16384.0 */
	int 
		fflag = 0, 	/* format flag */
		rflag = 0, 	/* print time in samples or time? */
		i, 
		val;
	long 			/* these are long since they can be large */
		begin, 			/* starting sample */
		end = INT_INFINITY, 	/* ending sample */
		cnt;			/* current sample */
	char ch;

	/* look on command line for sample rate flag, ignore the rest */
	while ((ch = crack(argc, argv, "R|", 1)) != NULL) {
		if (ch == 'R')
			srate = sfexpr(arg_option, 1.0);
	}
	arg_index = 0;		/* reset crack's argument index */

	/* parse the rest of the command line */
	while ((ch = crack(argc, argv, "R|b|e|fdoxtsh", 0)) != NULL) {
		switch (ch) {
			case 'R': break;
			case 'b': begin = sfexpr(arg_option, srate); break;
			case 'e': end =   sfexpr(arg_option, srate); break;
			case 'f': fflag |= FLOAT; 	break;
			case 'd': fflag |= DECIMAL; 	break;
			case 'o': fflag |= OCTAL; 	break;
			case 'x': fflag |= HEXIDECIMAL;	break;
			case 't': rflag = 1;		break;
			case 's': rflag = 2;		break;
			case 'h': usage(0);		break;
			default: usage(2);
		}
	}

	/* is input a file or pipe? */
	if (isatty(0))
		usage(1);	/* no, go complain */

	if (fflag == 0)	/* no output format set, use default */
		fflag = DEFAULT;


	/* read up samples */
	for (cnt = 0; getfloat(&input) > 0; cnt++) { 
		/* throw away unwanted samples */
		if (cnt < begin) 	
			continue;
		else if (cnt >= end)
			continue;

		/* print time or sample number? */
		if (rflag == 1) 
			printf("%6.3f\t", cnt/srate);
		else if (rflag == 2)
			printf("%d\t", cnt);

		/* print samples */
		val = input * 32767.0;
		for (i = 1; i < MAX; i <<= 1)  {
			switch (i & fflag) {
				case DEFAULT:
				case FLOAT: 
					printf("%f\t", input); 
					break;
				case DECIMAL: 
					printf("%d\t", val); 
					break;
				case OCTAL: 
					printf("0%o\t", val & (u_short) -1); 
					break;
				case HEXIDECIMAL: 
					printf("0x%x\t", val & (u_short) -1); 
					break;
				default: break;
			}
		}
		printf("\n");
	}
	exit(0);
}

usage(errorcode)
	int errorcode;
{
	switch (errorcode) {
		case 0:
		    fprintf(stderr, "usage: btoa [flags] < floatsams > floatsams\n");
		    pflags();
		    break;
		case 1:
		    fprintf(stderr, "input must be a file or pipe\n");
		    break;
		case 2:
		    fprintf(stderr, "unknown flag\n");
		    pflags();
		    break;
		default:
		    break;
	}
	exit(errorcode);
}

pflags()
{
	fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s",
		"RN set sampling rate to N (",
		DEFSR,
		" Hz)\n",
		"bN set begin time to N\n",
		"eN set end time to N\n",
		"f print samples as floating point numbers\n",
		"d print samples as decimal numbers\n",
		"o print samples as octal numbers\n",
		"x print samples as hexidecimal numbers\n",
		"t index samples with time in seconds\n",
		"s index samples with sample numbers\n",
		"h usage statement\n"
		);
}
