/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

/* from crack() */
extern int      arg_index;
extern char    *arg_option;

int     wizard,
        readonly;

main (argc, argv)
	int     argc;
	char  **argv;
{
	extern char    *mktemp ();
	extern char    *strcpy (), *strcat ();
	extern char    *getprown ();
	char    tmp[BUFSIZ],
	        tmpfile[BUFSIZ];
	FILE   *fp;
	char   *getsfn (), *sfile, ch, getans ();
	struct sndesc  *rsdf (), *sfd, *osfd, *mergesdf (), *cpsfd ();
	int     help = 0,
	        wmode = 0;
	int     status,
	        pid,
	        w;

	if (argc < 2) {
		fprintf (stderr, "usage: visf [flags] soundfile\n");
		fprintf (stderr, " flags= -h(elp) -w(izard) -r(eadonly\n");
		exit (1);
	}

	while ((ch = crack (argc, argv, "hwr", 0)) != NULL) {
		switch (ch) {
			case 'h': 
				visfhelp ();
				break;
			case 'w': 
				wizard++;
				break;
			case 'r': 
				readonly++;
				break;
		}
	}
	if (arg_index >= argc)
		exit (1);

	(void) strcpy (tmp, "tmpXXXXXX");
	(void) mktemp (tmp);
	strcpy (tmpfile, "/tmp/");
	(void) strcat (tmpfile, tmp);
	setsfile (argv[arg_index]);
	sfile = getsfn (argv[arg_index], 0);
	sfd = rsdf ((char *) NULL, sfile);
	if (sfd == NULL || sfd -> err) {
		fprintf (stderr, 
			"visf: error or non-existant file: %s\n", sfile);
		exit (1);
	}
	if (ownspath (sfd -> sfn, getprown ()) < 0) {
		fprintf (stderr, "visf: %s is readonly\n", sfd -> sfn);
		wmode = 1;
	}
redo: 
	if ((pid = fork ()) == 0) {
		if (setuid (getuid ()) < 0) {/* unset user-id mode */
			perror ("setuid");
			exit (1);
		}
		if (wizard) {
			if (ingroup (SUPERGROUP) < 1) {
				printf ("sorry, you are not a wizard.\n");
				exit (1);
			}
			if ((fp = fopen (tmpfile, "w")) == NULL) {
				perror ("fopen");
				exit (1);
			}
			if (wsdf (fp, sfd) != 0) {
				fprintf (stderr, 
					"visf: error writing sdf file \n");
				exit (1);
			}
			if (fclose (fp) < 0) {
				perror ("fclose");
				exit (1);
			}
			if (sfd == NULL) {
				fprintf (stderr, 
				    "visf: error writing file %s\n", tmpfile);
				exit (1);
			}
		}
		else
			if (wmodsdf (sfd, tmpfile)) {
				fprintf (stderr,
				    "visf: error writing file %s\n", tmpfile);
				exit (1);
			}
		(void) sprintf (tmp, "vi %s", tmpfile);
		if (system (tmp))
			exit (1);
		if (wmode) {
			fprintf (stderr, 
			    "visf: file %s unchanged.\n", sfd -> sfn);
			exit (0);
		}
		exit (0);	/* child dies */
	}
	/* parent - wait for process, or interrupts */
	while ((w = wait (&status)) != pid && w != -1)
		/* empty */;

	osfd = cpsfd (sfd);
	sfd = mergesdf (sfd, tmpfile);
	if (sfd == NULL) {
		fprintf (stderr, "visf: mergesdf failed.\n");
		exit (1);
	}
	/* don't let the file size grow! */
	if (!wizard)
		if (osfd -> fs < sfd -> fs)
			sfd -> fs = osfd -> fs;
	if (readonly)
		goto quit;
	do {
		char    c;
		c = getans ("Press [RETURN] to finish, x for abort, ? for help.\t");
		if (c == 'x' || c == 'X')
			goto quit;
		if (c != '\n') {
			visfhelp ();
			help = 1;
			goto redo;
		}
		else
			help = 0;
	}
	while (help);
	if (wsdf ((FILE *) NULL, sfd)) {
		fprintf (stderr, "visf: can't write %s\n", sfd -> sfn);
		exit (1);
	}
quit: 
	if ((pid = fork ()) == 0) {
		(void) setuid (getuid ());/* unset user-id mode */
		sprintf (tmp, "rm %s", tmpfile);
		if (system (tmp)) {
			fprintf (stderr, "visf: error removing %s\n", tmpfile);
			exit (1);
		}
		exit (0);
	}
	while ((w = wait (&status)) != pid && w != -1);
	exit (0);
}

wmodsdf (sdp, file)
	struct sndesc  *sdp;
	char   *file;
{
	struct inclist *inc;
	struct comlist *com;
	FILE * fopen (), *fp;

 /* is there any reason to go on? */
	if (sdp == NULL)
		return (-1);
	if ((fp = fopen (file, "w")) == NULL) {
		fprintf (stderr, "wmodsdf: error opening file %s\n", file);
		return (-1);
	}

	fprintf (fp, "%c %o\n", FPROT, sdp -> fprot);

 /* write sample parameters. (sb and tb are not part of sdf) */
	fprintf (fp, "%c %f\n%c %c\n%c %u\n%c %d\n%c %c\n",
		FSR, sdp -> sr, FPM, sdp -> pm, FNC, sdp -> nc, FFS, sdp -> fs,
		FHOLD, sdp -> fhold);

 /* write comment(s) */
	for (com = sdp -> comsdf; com != NULL; com = com -> comnext)
		fprintf (fp, "%c %s\n", FREM, com -> cmt);

 /* write include file strings */
	for (inc = sdp -> inclsdf; inc != NULL; inc = inc -> incnext)
		fprintf (fp, "%c %s\n", FINC, inc -> fn);

	if (fclose (fp) < 0) {
		perror ("fclose");
		return (-1);
	}
	return (0);
}

struct sndesc  *mergesdf (sfd, name)
	struct sndesc  *sfd;
	char   *name;
{
	struct sndesc  *setsfd ();
	char    buf[BUFSIZ],
	       *bufp1 = buf + 1,
	       *bufp2 = buf + 2;
	char   *nl,
	       *rindex ();
	FILE   *fp;
	struct dskblk  *addcp ();
	struct inclist *inc;
	struct comlist *com;

	if ((fp = fopen (name, "r")) == NULL)
		return (NULL);

	/* wipe out old comment string */
	if (sfd -> comsdf != NULL) {
		for (com = sfd -> comsdf; com != NULL; com = com -> comnext) {
			free ((char *) com -> cmt);
			free ((char *) com);
		}
		sfd -> comsdf = NULL;
	}

	/* and include list */
	if (sfd -> inclsdf != NULL) {
		for (inc = sfd -> inclsdf; inc != NULL; inc = inc -> incnext) {
			free ((char *) inc -> fn);
			free ((char *) inc);
		}
		sfd -> inclsdf = NULL;
	}

	while (fgets (buf, BUFSIZ, fp) != NULL) {
		*bufp1 = NULL;
		if (*buf == FCP) {/*  cp - cylinder pointer list */
			if (addcp (sfd, bufp2) == NULL)
				return (NULL);
		}
		else {
			nl = rindex (bufp2, '\n');/* zap the \n */
			if (nl != NULL)
				*nl = NULL;
			if ((sfd = setsfd (sfd, buf, bufp2)) == NULL)
				return (NULL);
		}
	}
	if (fclose (fp) < 0) {
		perror ("fclose");
		return (NULL);
	}
	return (sfd);
}


visfhelp () 
{
	char    c,
	        getans ();
	printf ("%s%s%s%s%s%s",
"visf will allow you to alter selected parameters of a sound file.  The\n",
"parameters are presented one to a line.  The first thing on the line is\n",
"a code for what the parameter means, which is followed by the actual\n",
"parameter.  You can alter any of these parameters to any value you know\n",
"is ok, or add or delete comments or include files.  Numeric values may\n",
"not be expressions.\n");

	c = getans ("Press [RETURN] to see more\t");

	printf ("%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
"The meaning of the parameter codes is as follows:\n",
"p file protection code (default = ", DEFPC, ")\n",
"R sample rate (range = 64 to 49152) (default = ", DEFSR, ")\n",
"P packing mode (s or f) (default = ", DEFPM, ")\n",
"c number of channels (1,2 or 4) (default = ", DEFNC, ")\n",
"# number of samples in file (you can only make this number smaller!)\n",
"r comment string\n",
"I include file\n");

	if (wizard)
		printf ("%s%s%s%s%s%s%s%s%s%s%s%s",
"t realtime flag (r or n)\n",
"C number of cylinders (default = ", DEFNC, ")1\n",
"f file name (don't change, use mvsf!)\n",
"o owner\n",
"v cylinder allocation blocks (careful!)\n",
"w creation date\n",
"x last referenced date\n",
"y last altered\n",
"z date dumped\n",
"k tape key\n");

	c = getans ("Press [RETURN] to continue, x for abort, ? for help.\t");
	if (c == 'x' || c == 'X')
		exit (0);
	if (c != '\n')
		visfhelp ();
}
