h10112
s 01238/00000/00000
d D 1.1 87/06/12 17:41:49 root 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# define CARL
# define BERKELEY
/* DEFINE CONTIGUOUS */

#ifndef LINT
static char SccsId[] = "@(#)tarsf.c	1.2	4/17/85	IRCAM";
#endif


/* This is a highly altered version of the UNIX V7 tar program. 
   The alterations are for archiving sound files. 
   The tape directory structure has been changed to include the 
   sound file information. 

   This version will do multi volume tar tapes, that is to say it will
   break up larges files across volumes.

   Berkeley systems have a tape driver that will allow updating raw magtapes.
   If BERKELEY is defined then the sftar program will take advantage of this
   and write long records by default.

   Both CCSS (R. Gross) and CARL (D. G. Loy) files can use this program.
   If CARL is defined it will read/write CARL type soundfiles.

   If IRCAM is defined it will use some routines to speed up sound file
   reading/writing. Can't do non-contigous files!!! If CONTIGUOUS is defined
   then CARL files created will be created with contigous space. 

   If RTAPE is defined then the library of remote machine tape access
   will be used. This is not standard 4.2BSD.

   The tapes written by this program can be read by a normal 'tar' but
   of course all the soundfile information will not be used.
   This program will also know if a normal tar tape has been read and
   will ask the user for the soundfile information directly.
 */


#include <stdio.h>
#include <signal.h>

#ifdef CARL
/* #include <sys/types.h> */
#else
#include "../H/soundfile.h"   /* Soundfile definition stuff */
#endif

#ifdef BERKELEY

#ifdef BSD42
static	char *sccsid = "@(#)tar.c	4.14 (Berkeley) 83/01/05";
#include <sys/ioctl.h>
#endif

#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/mtio.h>
#endif BERKELEY

#include <sys/stat.h>
#include <sys/dir.h>

/* Name of Default tape drive */
#ifdef BERKELEY
char	magtape[]	= "/dev/rmt8";
#else
char	magtape[]	= "/dev/mt0";
#endif

#define MAXTAPE	2300

#ifndef RTAPE
/* These are for the remote tape access load with -ltio. */
#define rcreat creat
#define ropen open
#define rioctl ioctl
#define rread read
#define rwrite write
#define rclose close
#endif

#ifdef CARL

#include <carl/sndio.h>
#define sfclose(x) sclosesf(x)
#define READ 0
#define WRITE 1
#define READWRITE 2
#define sf_srate sr
#define sf_name sfn
#define sf_class ssize
#define SFPBSIZE(ptr)	((ptr)->fs * (ptr)->ssize)
#define SFSBSIZE(str)	((str).fs * (str).ssize)
#define sf_chans nc
char	sf_orchestra[16];


#else CARL

#define SFPBSIZE(ptr)	((ptr)->sf_bsize)
#define SFSBSIZE(str)	((str).sf_bsize)

#endif CARL

char	*sprintf(),*strcpy();
long  lseek();

#define TBLOCK	512             /* Block writes and read for tape */
#define NBLOCK	20              /* Max record size for raw tape */
#define NAMSIZ	100


union hblock {
	char dummy[TBLOCK];             /* Anything but directory */
	struct header {                 /* Directory structure */
		char name[NAMSIZ];
		char tpmode[8];
		char uid[8];
		char gid[8];
		char tpsize[12];
		char mtime[12];
		char chksum[8];
		char linkflag;
		char linkname[NAMSIZ];
		char tp_srate[12];
		char tp_chans[8];
		char tp_class[8];
		char tp_type[8];
		char tp_orchestra[16];
		char tp_sftarinfo[8];  	  /* For I/O across tapes */
		char comment[NAMSIZ];     /* Added line of english */
	} 
	dbuf;
} 
dblock, tbuf[NBLOCK];

#define PARTIAL 01                      /* Partial read or write */
#define LAST    02                      /* Last part of a file */
#define TAPENUMBER(a) ((a) >> 8)        /* Sequence number */

/* Bytes to tape blks */
#define BTOTB(bytes)  (((bytes) + TBLOCK -1) / TBLOCK)


struct stat stbuf;

#ifdef CARL

extern CSNDFILE *rootsfd;
CSNDFILE sfd,tapesfd,sfdesc,*sfdptr;

#else

struct SFDESC tapesfd,sfdesc,*sfdptr;
short *cyllist;

#endif CARL

short sftarinfo;

int	pflag,rflag,xflag,vflag,tflag,mt,aflag,cflag;
int	(*sig)();
int	term, chksum, wflag, recno, first;

#ifdef BERKELEY
int	nblock = NBLOCK;
#else
int	nblock = 1;
#endif

long    tapeloc;
long    density = 1600;
long	tapesize = 2300; /* Feet of tape */
long	maxtape;

char	*usefile;

char	*realloc(),*malloc();
long    atol();
double 	atof();
char	*progname;

main(argc, argv)
int	argc;
char	*argv[];
{
	char *cp;
	int onintr(), onquit(), onhup(), onterm();
	if (argc < 2)
		usage();

	progname = *argv;
	usefile =  magtape;
	argv[argc] = 0;
	argv++;
	for (cp = *argv++; *cp; cp++) 
		switch(*cp) {
		case 'f':
			usefile = *argv++;
			if (nblock == 1)
				nblock = 0;
			break;
		case 'c':
			cflag++;
			rflag++;
			break;
		case 'r':
			rflag++;
#ifndef BERKELEY
			if (nblock != 1 && cflag == 0) {
noupdate:
				fprintf(stderr,
				"%s: Blocked tapes cannot be updated (yet)\n",
				progname);
				done(1);
			}
#endif
			break;
		case 'v':
			vflag++;
			break;
		case 'w':               /* Seletive write or read */
			wflag++;
			break;
		case 'x':
			xflag++;
			break;
#ifndef CARL
		case 'p':
			pflag++;
			break;
#endif
		case 't':
			tflag++;
			break;
		case 'm':
			fprintf(stderr,"Times are always extraction time\n");
			break;
		case '-':
			break;
		case '8':
		case '0':
		case '1':
#ifdef BERKELEY
			magtape[8] = *cp;
#else
			magtape[7] = *cp;
#endif
			usefile = magtape;
			break;
		case 'b':
			nblock = atoi(*argv++);
			if (nblock > NBLOCK || nblock <= 0) {
				fprintf(stderr, "Invalid blocksize. (Max %d)\n", NBLOCK);
				done(1);
			}
#ifndef BERKELEY
			if (rflag && !cflag)
				goto noupdate;
#endif
			break;
		case 'd':	
			density = atol(*argv++);
			switch((int) density) {
				case 1600:
				case  800:
				case 6250:
					break;
				default:
					fprintf(stderr,"%s: Invalid density (%d).\n",
						progname,density);
					done(1);
					break;
			}
			break; 
		case 's':	
			tapesize = atol(*argv++);
			if(tapesize < 0 || tapesize > MAXTAPE) {
				fprintf(stderr,"%s: Invalid tapesize (%d).\n",
					progname,tapesize);
				done(1);
			}
			break; 
		case 'a':               /* Add a line of description */
			if((sig = signal(SIGINT,SIG_IGN)) != SIG_IGN) {
				aflag++;
				signal(SIGINT,sig);
			}
			break;
		default:
			fprintf(stderr, "%s: %c: unknown option\n",
				progname,*cp);
			usage();
		}


		/* Compute number of blocks on the tape */
		{
			double record;

			record = (1.0/ (double) density) * 
				(double) TBLOCK * (double) nblock; 

			/* Add size of the interrecord gap */
			record += (density == 6250 ? .3 : .7);

			/* Record has the amount of tape needed by one
			   record and the record gap */
			maxtape = (tapesize * 12L) / record;
			maxtape *= nblock; /* Now in 512 byte blocks */
		}

	if (rflag) {            /* Write on the tape */

		if (signal(SIGINT, SIG_IGN) != SIG_IGN)
			signal(SIGINT, onintr);
		if (signal(SIGHUP, SIG_IGN) != SIG_IGN)
			signal(SIGHUP, onhup);
		if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
			signal(SIGQUIT, onquit);
		if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
			signal(SIGQUIT, onterm);

tpopen:		
		if ((mt = ropen(usefile, READWRITE)) < 0) {
			if (cflag == 0 || (mt =  creat(usefile, 0666)) < 0) {
				fprintf(stderr, "%s: cannot open %s\n",
				progname,usefile);
				fprintf(stderr,"Write ring on?\n");
				fprintf(stderr,"Try again?\n");
				if(response() == 'y') goto tpopen;
				done(0);
			}
		}
		if (cflag == 0 && nblock == 0)
			nblock = 1;
		dorep(argv);
		done(0);
	}

	else if(!xflag && !tflag) {
		usage();
		done(0);
	}
xtpopen:	
	if ((mt = ropen(usefile, READ)) < 0) {
		fprintf(stderr, "%s: cannot open %s\n",progname,usefile);
		fprintf(stderr,"Try again?\n");
		if(response() == 'y') goto xtpopen;
		done(1);
	}

	if(xflag)
		doxtract(argv);
	else
		dotable();
}

usage()
{
	fprintf(stderr, 
	"%s: usage  tar -{txru}[cvfblm] [tapefile] [blocksize] file1 file2...\n",
	progname);
	done(1);
}

dorep(argv)             /* Write on the tape */
char	*argv[];
{

	if (!cflag) {   /* If not creating the tape */
		getdir();       /* Read a directory block */
		do {
			passtape();     /* Skip the samples */
			if (term)       /* Bad */
				done(0);
			getdir();       /* Read until we reach an empty block */
		} 
		while (!endtape());
	}

	while (*argv && !term) 
		putfile(*argv++);

	putempty();                     /* Empty block */
	putempty();
	flushtape();                    /* Write tape out if middle of big block */
}

endtape()
{
	if(dblock.dbuf.name[0] == '\0') {      /* is directory block null? */
		backtape();                     /* Yes so back up over one block */
		return(1);
	}
	else
		return(0);
}

getdir()
{

	readtape( (char *) &dblock);            /* Read directory block */
	if (dblock.dbuf.name[0] == '\0')        /* Empty directory */
		return;

	/* Checksum on the directory */

	sscanf(dblock.dbuf.chksum, "%o", &chksum);
	if (chksum != checksum()) {
		fprintf(stderr, "directory checksum error (%d != %d).\n",
			chksum,checksum());
		done(2);
	}

	fmodes();	/* Pointer to soundfile structure */
	sfdptr = &tapesfd;

}

passtape()
{
	long blocks;
	char buf[TBLOCK];

	blocks = BTOTB(SFPBSIZE(sfdptr));	/* Skip over entire file */
	while (blocks-- > 0)
		readtape(buf);
}

putfile(sfname)            /* Put a file onto the tape */
char *sfname;
{
#ifdef CARL
	CSNDFILE *sffd;
	char *rindex();
#else
	int sffd;
#endif
	long totalbytes = 0L;
	long blocks,bytes;
	char buf[TBLOCK];
	short tape = 0;           /* First tape for this file */
	int i;

	register char *cp,*cp2;


#ifdef CARL
	sffd = sopensf(sfname,"r",NULL);

	sfdptr = sffd;
#else CARL
	sffd = sfopen(sfname,READ);
	sfdptr = &sfdesc;
#endif

#ifdef CARL
	if (sffd == NULL) {
#else
	if (sffd < 0) {

#endif CARL
		fprintf(stderr, "%s: %s: cannot open file\n",progname,sfname);
		return;
	}

#ifdef CARL
	{
		char full[120],*fullname,*getsfn();

	if((fullname = getsfn(sfname,0))  == NULL) {
		fprintf(stderr,"%s: Can't getsfn %s\n",progname,sfname);
		return;
	}
	sprintf(full,"%s.sdf",fullname);
	if(stat(full,&stbuf)) {
		fprintf(stderr,"Can't stat file %s\n",full);
		free(fullname);
		return;
		
	}
	free(fullname);
	}
#else
	if(sffstat(sffd,&sfdesc,&stbuf,&cyllist)) {
		fprintf(stderr,"Can't sfstat file %s\n",sfname);
		return;
	}
#endif

	if (checkw('r', sfname) == 0) { /* Check if we want to do it */
		
		sfclose(sffd);
		return;
	}

	if ((stbuf.st_mode & S_IFMT) != S_IFREG) {
		fprintf(stderr, "%s: %s is not a file. Not dumped.\n",
			progname, sfname);
		sfclose(sffd);
		return;
	}

	/* Copy discriptor */
	copy((char *) &sfdesc,(char *) sfdptr,sizeof(sfdesc));

#undef IRCAM
#ifdef CARL
#ifdef IRCAM
	set_fast_sndi(sffd);
#endif IRCAM
#endif CARL

	while(totalbytes < SFSBSIZE(sfdesc)) { /* Until file is used up */

		bytes = SFSBSIZE(sfdesc) - totalbytes;
		blocks = BTOTB(bytes);

		if((tapeloc + blocks + 1) > maxtape) 
			blocks = maxtape - tapeloc - 1; /* Blocks to put */

		/* How man bytes are then in this chunk */
		bytes = (bytes < (blocks * TBLOCK) ? bytes : blocks * TBLOCK);

		/* Set up the size of this file if it was UNIX file */
		stbuf.st_size = bytes; 

		sftarinfo = ((tape << 8) & ~0377); /* tape number */
		if((tapeloc + BTOTB(SFSBSIZE(sfdesc) - totalbytes) + 1L) > maxtape) { 
			if(!changetapes(blocks,BTOTB(SFSBSIZE(sfdesc) - totalbytes))) 
				return;
			 /* Partial write desired */
			tape++; /* Next tape number */
			sftarinfo |= PARTIAL;    /* Partial write */
		}
		else 
			if(tape) /* If partial and all fits on the tape */ 
				sftarinfo |= (LAST | PARTIAL);

		tomodes(&stbuf);

#ifdef CARL
		cp2 = rindex(sfdptr->sf_name,'/');
		if(cp2 != NULL)
			cp2++;
		else
#endif
			cp2 = sfdptr->sf_name;


		/* copy information to the tape header block */
		for (cp = dblock.dbuf.name, i=0; (*cp++ = *cp2++) && i < NAMSIZ; i++);
		if (i >= NAMSIZ) {      /* Impossible */
			fprintf(stderr, "%s: file name too long\n", sfname);
			sfclose(sffd);
			return;
		}

		if(aflag) getcomment(sfname);

		totalbytes += bytes;  /* This many bytes of the file are done */

		if (vflag) {
			fprintf(stderr, "adding  %s ", sfname);
			fprintf(stderr, "%ld blocks\n", blocks);
		}

		sprintf(dblock.dbuf.chksum, "%6o", checksum());
		writetape( (char *) &dblock);   /* Directory block onto tape */

#ifdef CARL
#ifdef IRCAM
		while (blocks > 0 && (i = fast_sndi( buf,TBLOCK)) > 0) {
			writetape((char *) buf); /* Block by block */
			blocks--;
		}
#else IRCAM
 		i = 0;
 		while (blocks > 0 && (i += sndi(sfdptr, buf, i,
 		    TBLOCK/sfdptr->ssize, 
 		    sfdptr->pm == PM16BIT ? "s" : "f")) > 0) {
 			writetape((char *) buf); /* Block by block */
 			blocks--;
 		}
#endif IRCAM
#else CARL
		while (blocks > 0 && (i = sfread(sffd, buf,TBLOCK)) > 0) {
			writetape((char *) buf); /* Block by block */
			blocks--;
		}
#endif CARL

		if (blocks != 0)
			fprintf(stderr, "%s: Incomplete transfer\n", sfname);

		while (blocks-- >  0)
			putempty();     /* Finish off the record */
		if(totalbytes < SFSBSIZE(sfdesc))
			if(!newtape(WRITE,tape)) done(1);
	}
	sfclose(sffd);

#ifdef CARL
#ifdef IRCAM
	end_fast_sndi(sffd);
	sffd->fs = SFSBSIZE(sfdesc); /* Reset size of 512 setting of fast_sndo */
#endif IRCAM
#endif CARL
}

changetapes(cando,total)
long cando,total;
{
	fprintf(stderr,"Tape doesn't have enough room for soundfile.\n");
	fprintf(stderr,"I can copy %D blocks out of %D left in the file.\n",
	cando,total);
	fprintf(stderr,"Partial copy?\t");
	if(response() == 'y') return(1);
	return(0);      /* Signal to close and end */
}

newtape(flag,seqtape)
int flag;                  /* READ or WRITE (1) */
int seqtape;               /* Tape number for this file */
{
	/* Change the tapes and setup for either a write or a read */

	if(flag) { /* Write */
		putempty();
		putempty();
		flushtape();    /* Finish I/O on this tape */
	}

	rclose(mt);          /* Rewind */
	first = recno = tapeloc = 0;        /* Reset */
tpopen: 
	fprintf(stderr,"Type 'yes' when newtape is loaded\t");
	if(response() != 'y') done(0);
	if(flag) { /* Write setup */
		if((mt = ropen(usefile,READWRITE)) < 0) {       /* Reopen file */
			if((mt = rcreat(usefile,0666)) < 0) {
				fprintf(stderr,"Can't open tape. Write locked?\n");
				goto tpopen;  /* Try again */
			}
		}
		fprintf(stderr,"Create tape?\t");
		if(response() != 'y') { /* Tape is already used */
			getdir();
			do { /* Find the end */
				passtape();
				if(term) done(0);
				getdir();
			} 
			while(!endtape());
		}
		return(1);
	}
	else { /* Read case */
		if((mt = ropen(usefile,READ)) < 0) { /* Tape gone */
			fprintf(stderr,"Can't open %s, on line?\n",usefile);
			goto tpopen;
		}

		for(;;) { /* find the next part, return 0 if not on tape  */
			getdir();
			if(endtape()) return(0);
			if((!strcmp(sfdesc.sf_name,sfdptr->sf_name))
			    && (TAPENUMBER(sftarinfo) == seqtape)) return(1);
			passtape();
		}
	}
}

doxtract(argv)
char	*argv[];
{
	long blocks;
	char buf[TBLOCK];
	char **cp;

#ifdef CARL
	CSNDFILE *ofile,*sfcreat();
#else
	int ofile;
#endif
	short sftsave;	/* Sftarinfo save */
	short tape = 0;
	int uid,gid;

	for (;;) {
		getdir();
		if (endtape())
			break;

		if (*argv == 0)
			goto gotit;

		for (cp = argv; *cp; cp++)
			if (prefix(*cp, dblock.dbuf.name))
				goto gotit;
		passtape();
		continue;

gotit:
		if (checkw('x', dblock.dbuf.name) == 0) {
			passtape();
			continue;
		}

		/* Check if this is a partial file and if it is the first */
		if(sftarinfo & PARTIAL 
		    && (TAPENUMBER(sftarinfo) != 0)) {
			fprintf(stderr,"File %s doesn't start on this tape.\n",
			dblock.dbuf.name);
			passtape();
			continue;
		}

		sscanf(dblock.dbuf.uid,"%o",&uid);
		sscanf(dblock.dbuf.gid,"%o",&gid);

#ifdef CARL
		if((ofile = sfcreat(dblock.dbuf.name)) == NULL)
#else
		if ((ofile = sfcreat(sfdptr->sf_class,sfdptr->sf_type,
		PRIVATE,sfdptr->sf_srate,sfdptr->sf_chans,
		sfdptr->sf_orchestra,sfdptr->sf_name)) == -1) 
#endif
		{
			fprintf(stderr, "%s: %s - cannot create\n",
			progname,dblock.dbuf.name);
			passtape();
			continue;
		}
#ifdef CARL
#ifdef IRCAM
		set_fast_sndo(ofile);
#endif IRCAM
#endif CARL

		for(;;) { /* Until all of file has been recovered */
			copy((char *) &sfdesc,(char *)sfdptr,sizeof sfdesc); /* Save */
			sftsave = sftarinfo;
			blocks = BTOTB(SFSBSIZE(sfdesc));
			if (vflag)
				fprintf(stderr, "x %s, %ld tape blocks\n",
				dblock.dbuf.name, blocks);
			while (blocks-- > 0) {
				readtape((char *) buf);
#ifdef CARL
#ifdef IRCAM
				if(fast_sndo(buf,TBLOCK) < 0) {
#else IRCAM
 				if (sndo(ofile, buf, ofile->fs, 
 				    TBLOCK/ofile->ssize, 
 				    ofile->pm == PM16BIT ? "s" : "f") < 0) {
#endif IRCAM
#else CARL
				if (sfwrite(ofile, buf, TBLOCK) < 0) {
#endif CARL
					fprintf(stderr, "%s: %s: HELP - extract error\n",
					progname,sfdesc.sf_name);
					done(2);
				}
			}
			if(sftsave & PARTIAL && !(sftsave & LAST)) { /* Not done */
				tape++;
				if(!newtape(READ,tape)) break;
			}
			else break; /* all done */
		}
#ifdef CARL
		ofile->fs = sfdesc.fs;
#ifdef IRCAM
		end_fast_sndo(ofile);
#endif IRCAM
#endif CARL
		sfclose(ofile);


#ifdef CARL

#else CARL
		if(pflag) /* Correct ownership */
			if(sfchown(sfdptr->sf_name,uid,gid))
				fprintf(stderr,"Can't sfchown %s\n",sfdptr->sf_name);
#endif CARL
	}
}

dotable()
{
	for (;;) {
		getdir();
		if (endtape())
			break;
		printf("%s\n", dblock.dbuf.name);
		if (vflag)
			sflongt(sfdptr,dblock.dbuf.mtime,READ);
		passtape();
	}
}

putempty()
{
	char buf[TBLOCK];
	char *cp;

	for (cp = buf; cp < &buf[TBLOCK]; )
		*cp++ = '\0';                   /* Zero buffer to tape */
	writetape(buf);
}

sflongt(sfd,mtime,flag)

#ifdef CARL
	CSNDFILE *sfd;
#else CARL
	struct SFDESC *sfd;
#endif CARL
	char *mtime;
	int flag;       /* Flag tells if reading or writing to tape */
{
	register char *cp = mtime;
	char *ctime();
	float dur;
	time_t time;

	/* print the structure */

	printf("\tsrate: %f\tChannels: %d",sfd->sf_srate,sfd->sf_chans);
#ifdef CARL
	if(flag == READ)
		printf("\t Orchestra: %s\n",sf_orchestra);
	else
		printf("\n");
#else
	printf("\tOrchestra: %s\n",sfd->sf_orchestra);
#endif
	dur = (float)(SFPBSIZE(sfd)  / (float) sfd->sf_srate /
	(float) sfd->sf_class /(float) sfd->sf_chans);

	printf("Duration:\t%f\t",dur);
	if(flag == READ) {
		sscanf(mtime,"%O",&time);
		cp = ctime(&time);
	}
	printf("Date: %-12.12s %-4.4s\n", cp+4, cp+20);
	if(flag == READ && dblock.dbuf.comment[0] != '\0')
		printf("Comment:\n%s\n",dblock.dbuf.comment);
	if(flag == READ && sftarinfo & PARTIAL) 
		printf("Partial file. Tape number %d%s.\n",
		TAPENUMBER(sftarinfo),(sftarinfo  & LAST ?", last tape." : ""));
}



onintr()
{
	signal(SIGINT, SIG_IGN);
	term++;
}

onquit()
{
	signal(SIGQUIT, SIG_IGN);
	term++;
}

onhup()
{
	signal(SIGHUP, SIG_IGN);
	term++;
}

onterm()
{
	signal(SIGTERM, SIG_IGN);
	term++;
}

fmodes()
{
	short tmp;	/* Can sscanf into a char */

#ifdef CARL
	long tmp2;
#endif

	/* Check if this is really a tar tape not a soundfile tar tape */
	if(dblock.dbuf.tp_srate[0] == NULL && !tflag)
		gtarinfo();

	/* Convert ASCII tape information to internal structure */
	/* Get info from tar structure */

#ifdef CARL
	sscanf(dblock.dbuf.tpsize,"%O",&tmp2);
	if(tapesfd.sf_name[0] == NULL) /* Allocate */
		tapesfd.sf_name = malloc((unsigned) strlen(dblock.dbuf.name) + 1);
	else
		tapesfd.sf_name = realloc(tapesfd.sf_name,
					(unsigned) (strlen(dblock.dbuf.name) + 1));
	if(tapesfd.sf_name == NULL) {
		perror("Tarsf");
		exit(1);
	}
#else
	sscanf(dblock.dbuf.tpsize,"%O",&tapesfd.sf_bsize);
#endif

	strcpy(tapesfd.sf_name,dblock.dbuf.name);

	/* get info from sftar par of the tape structure */
	sscanf(dblock.dbuf.tp_srate,"%f",&tapesfd.sf_srate);
	sscanf(dblock.dbuf.tp_class,"%ho",&tmp);
	tapesfd.sf_class = (char) tmp;

#ifdef CARL
	tapesfd.fs = tmp2 / tapesfd.sf_class;
	strncpy(sf_orchestra,dblock.dbuf.tp_orchestra,14);
#endif

	sscanf(dblock.dbuf.tp_type,"%ho",&tmp);
	sscanf(dblock.dbuf.tp_chans,"%ho",&tapesfd.sf_chans);
	sscanf(dblock.dbuf.tp_sftarinfo,"%o",&sftarinfo);

#ifndef CARL
	strcpy(tapesfd.sf_orchestra,dblock.dbuf.tp_orchestra);
	tapesfd.sf_type = (char) tmp;
#endif
}


tomodes(sp)
register struct stat *sp;
{
	register char *cp;

	for (cp = dblock.dummy; cp < &dblock.dummy[TBLOCK]; cp++)
		*cp = '\0';
	sprintf(dblock.dbuf.tpmode, "%6o ", sp->st_mode & 07777);
	sprintf(dblock.dbuf.uid, "%6o ", sp->st_uid);
	sprintf(dblock.dbuf.gid, "%6o ", sp->st_gid);
	sprintf(dblock.dbuf.tpsize, "%11lo ", sp->st_size);
	sprintf(dblock.dbuf.mtime, "%11lo ", sp->st_mtime);
	sprintf(dblock.dbuf.tp_srate,"%10.4f ",sfdesc.sf_srate);
	sprintf(dblock.dbuf.tp_chans,"%6o ",sfdesc.sf_chans);
	sprintf(dblock.dbuf.tp_class,"%6o ",sfdesc.sf_class);

#ifdef CARL
	strcpy(dblock.dbuf.tp_orchestra,"CARL");
	sprintf(dblock.dbuf.tp_type,"%6o " ,01);	/* SAMPLES */
#else
	strcpy(dblock.dbuf.tp_orchestra,sfdesc.sf_orchestra);
	sprintf(dblock.dbuf.tp_type,"%6o " ,sfdesc.sf_type);
#endif CARL

	sprintf(dblock.dbuf.tp_sftarinfo,"%6o ",sftarinfo);
}

checksum()
{
	register i;
	register char *cp;

	for (cp = dblock.dbuf.chksum; cp < &dblock.dbuf.chksum[sizeof(dblock.dbuf.chksum)]; cp++)
		*cp = ' ';
	i = 0;
	for (cp = dblock.dummy; cp < &dblock.dummy[TBLOCK]; cp++)
		i += *cp;
	return(i);
}

checkw(c, name)
char *name;
{
	if (wflag) {
		printf("%c ", c);
		if (vflag) if(c == 'x')
			sflongt(sfdptr,dblock.dbuf.mtime,READ);
		else 
		    sflongt(sfdptr,ctime(&stbuf.st_mtime),WRITE);
		printf("Sftape %s %s?\t",(c == 'x' ? "extract" : "write"),name);
		if (response() == 'y'){
			return(1);
		}
		return(0);
	}
	return(1);
}

response()
{
	char c;

	c = getchar();
	if (c != '\n')
		while (getchar() != '\n');
	else c = 'n';
	return(c);
}


done(n)
{
	exit(n);
}

prefix(s1, s2)
register char *s1, *s2;
{
	while (*s1)
		if (*s1++ != *s2++)
			return(0);
	if (*s2)
		return(*s2 == '/');
	return(1);
}


readtape(buffer)
char *buffer;
{
	int i, j;

	if (recno >= nblock || first == 0) {
		if (first == 0 && nblock == 0)
			j = NBLOCK;
		else
			j = nblock;
		if ((i = rread(mt, (char *) tbuf, TBLOCK*j)) < 0) {
			fprintf(stderr, "%s: tape read error\n",progname);
			done(3);
		}
		if (first == 0) {
			if ((i % TBLOCK) != 0) {
				fprintf(stderr, "%s: tape blocksize error,\n",
					progname);
				done(3);
			}
			i /= TBLOCK;
#ifndef BERKELEY
			if (rflag && i != 1) {
				fprintf(stderr, "%s: Cannot update blocked tapes (yet)\n.",
				progname);
				done(4);
			}
#endif
			if (i != nblock && i != 1) {
				fprintf(stderr, "%s: blocksize = %d\n",
					progname,i);
				nblock = i;
			}
		}
		recno = 0;
	}
	first = 1;
	copy(buffer, (char *) &tbuf[recno++],TBLOCK);
	tapeloc++;
	return(TBLOCK);
}

writetape(buffer)
char *buffer;
{
	first = 1;
	if (nblock == 0)
		nblock = 1;
	if (recno >= nblock) {
		if (rwrite(mt, (char *) tbuf, TBLOCK*nblock) < 0) {
			fprintf(stderr, "%s: tape write error\n.",
			progname);
			done(2);
		}
		recno = 0;
	}
	copy((char *) &tbuf[recno++], buffer,TBLOCK);
	if (recno >= nblock) {
		if (rwrite(mt,(char *)  tbuf, TBLOCK*nblock) < 0) {
			fprintf(stderr, "%s: tape write error\n",progname);
			done(2);
		}
		recno = 0;
	}
	tapeloc++;
	return(TBLOCK);
}

#ifdef BERKELEY
backtape()
{
	static int mtdev = 1;
	static struct mtop mtop = {
		MTBSR, 1	};
	struct mtget mtget;

	if (mtdev == 1)
		mtdev = rioctl(mt, MTIOCGET, &mtget);
	if (mtdev == 0) {
		if (rioctl(mt, MTIOCTOP, &mtop) < 0) {
			fprintf(stderr, "Tar: tape backspace error\n");
			done(4);
		}
	} 
	else
		lseek(mt, (long) -TBLOCK*nblock, 1);
	recno--;
}
#else
backtape()
{
	lseek(mt, (long) -TBLOCK, 1);
	if (recno >= nblock) {
		recno = nblock - 1;
		if (rread(mt,(char *)  tbuf, TBLOCK*nblock) < 0) {
			fprintf(stderr, "%s: tape read error after seek.\n",
				progname);
			done(4);
		}
		lseek(mt, (long) -TBLOCK, 1);
	}
	tapeloc--;
}
#endif

flushtape()
{
	rwrite(mt, (char *) tbuf, TBLOCK*nblock);
}

copy(to, from, how_many)
register char *to, *from;
register int how_many;
{
	for(;how_many;how_many--) *to++ = *from++;
}


getcomment(sfname)
char *sfname;
{
	fprintf(stderr,"Please add a line of comment on file %s:\n",sfname);
	gets(dblock.dbuf.comment);
	if(dblock.dbuf.comment[0] < ' ') gets(dblock.dbuf.comment);
}

#ifdef CARL
#define TRUE 1
#define FALSE 0
#define IGNORE TRUE
#define DONT_IGNORE FALSE
#define SFMAXOPT 2

#define DEFINSIZ float		/* size of default input sample */
#define ALTINSIZ short
#define DEFINPAK 'f'
#define ALTINPAK 's'
char *dfltvals[] = DFLTVALS;


char *args[] = {
	"tarsf (CARL VERSION)",
	"-RSAMPLINGRATE",
#ifdef CONTIGUOUS
	"-TDURATION_IN_TIME",
#endif
	"-cCHANNELS",
	"-pPROTECTION",
	"NAME_OF_THE_FILE",
	0
};

struct sndesc *sfcreat(name)
	char *name;
{

	/* Taken from sndout.c */
	CSNDFILE *sfoargs(),*tmp;
	char sfopt[2];		/* holds string passed to sndo */
	char ipak=DEFINPAK;		/* set default input packing */
	long start = 0, end;
	short argcnt = 1;
	extern int arg_index;

	ipak = (sfdptr->ssize == 2 ? ALTINPAK : DEFINPAK); 
	end = (sfdptr->fs / sfdptr->nc);

	sprintf(args[argcnt++]+2,"%-10.5f",sfdptr->sr);
#ifdef CONTIGUOUS
	sprintf(args[argcnt++]+2,"%-10.5f",(float) end / sfdptr->sr );
#endif
	sprintf(args[argcnt++]+2,"%-2D",sfdptr->nc);
	sprintf(args[argcnt++]+2,"%-o",0644);
	strncpy(args[argcnt++],name,13); /* Old style directory */

	arg_index = 0;
	if ((tmp = sfoargs(argcnt, args, &ipak, &start, &end, DFLTARGS, 
		dfltvals, usage, DONT_IGNORE, TRUE)) == NULL)
			return((CSNDFILE *) NULL);
	return(tmp);
}
#endif

gtarinfo()
{
	/* This isn't a soundfile tape so ask the user for help. */
	/* Check for sure if allowing stdin as a file */

	fprintf(stderr,"This appears to not be a soundfile tape but a tar tape\n");
	fprintf(stderr,"Please enter the following values:\n");
	getstr("Sampling rate:\t",dblock.dbuf.tp_srate,11);
	getstr("Number of bytes per sample:\t",dblock.dbuf.tp_class,7);
	getstr("Orchestra name:\t",dblock.dbuf.tp_orchestra,14);
	strcpy(dblock.dbuf.tp_type,"01 ");
	getstr("Number of channels:\t",dblock.dbuf.tp_chans,7);

}

getstr(ask,place,size)
char *ask,*place;
{
	register char *cp;
	*place = NULL;
	do {
		fputs(ask,stderr);
		fgets(place,size,stdin);
		if(*place < ' ') 
			*place = NULL;
	} while(*place == NULL);
	for(cp = place; *cp; cp++)
		if(*cp == '\n') 
			*cp = NULL;
}

E 1
