h26491
s 00130/00000/00000
d D 1.1 84/07/25 14:31:22 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/sndio.h>

extern int sferror;
extern CSNDFILE *rootsfd;

int otty, header = 1;
char *chanspec, endfmt;
long beg = 0, tend;
char *cbeg, *cend, *name;

main(argc, argv)
	char **argv;
{
	char opak = PMFLOAT;
	CSNDFILE *sfd;
	char ch;

	otty = isatty(1);

	while ((ch = crack(argc, argv, "b|e|d|o|c|Hht", 0)) != NULL) {
		switch (ch) {
			case 'b': cbeg = arg_option; break;
			case 'e': endfmt = ch; cend = arg_option; break;
			case 'd': endfmt = ch; cend = arg_option; break;
			case 'o': opak = *arg_option; break;
			case 'c': chanspec = arg_option; break;
			case 't': otty = 1; break;	/* force tty output */
			case 'H': header = 0; break;	/* no output header */
			case 'h': usage(0);
			default: usage(1);
		}
	}
	if (otty) 
		header = 0;	/* no header if output is a tty */
	/* open sound file */
	if (argc == arg_index) 
		name = DEFNM;
	else 
		name = argv[arg_index];
	if ((sfd = sopensf(name, "r", (char *) NULL)) == NULL) { 
		ssfallclose(); 	/* close all open sound files */
		exit(1); 
	}

	/* do all boundary calculations in sample frames */
	if (cbeg != NULL) {
		beg = sfexpr(cbeg, sfd->sr);
		if (beg < 0) 
			beg = 0;
	}
	if (cend != NULL) {
		if (endfmt == 'e')
			tend = sfexpr(cend, sfd->sr);
		else
			tend = beg + sfexpr(cend, sfd->sr);
	} else 
		tend = sfd->fs / sfd->nc;

	if (setchan(chanspec, sfd->nc)) 
		usage(2);

	if (header)
		if (whead(sfd, chanspec, opak) != 0) {
			fprintf(stderr, "sndin: error writing header\n");
			exit(1);
		}

	switch (opak) {
		case PM16BIT:	
			switch (sfd->pm) {
				case PM16BIT:	
					if (stos(sfd, beg, tend) != 0)
						oerr();
					break;
				case PMFLOAT:
					if (ftos(sfd, beg, tend) != 0)
						oerr();
					break;
			}
		break;
		case PMFLOAT:
			switch (sfd->pm) {
				case PM16BIT:	
					if (stof(sfd, beg, tend) != 0)
						oerr(); 
					break;
				case PMFLOAT:
					if (ftof(sfd, beg, tend) != 0)
						oerr();
					break;
			}
		break;
		default: 
			usage(2);
	}
		
	ssfallclose();	/* open files must explicitly be closed */
	exit(sferror);
}

oerr()
{
	fprintf(stderr, "sndin: error writing samples\n");
}

usage(x)
{
fprintf (
stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
"usage: sndin [flags] [filename] > output\n",
"output format:\n",
"\tif stdout is a tty, writes arabic numbers,\n",
"\telse if stdout is a file or pipe, writes floatsams\n",
"flags:\n",
"-oX\tX overrides default output format, X can be\n",
"\t\tf pipe: floatsams, tty: floating point\n",
"\t\ts pipe: shortsams, tty: integer\n",
"-t force arabic output (even if output is file or pipe)\n",
"-bN\t set begin time to N\n",
"-eN\t set end time to N\n",
"-dN\t set duration to N\n",
"-cS\tS is a comma-separated list of selected channel numbers\n",
"-H\t  suppress generating header.\n",
"default usage: sndin -of test\n"
);
ssfallclose();
exit(x);
}
E 1
