h50306
s 00070/00000/00000
d D 1.1 84/07/25 14:31:18 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/sndio.h>
#define BUFSIZE	4096
#define min(a,b) ((a)<(b)?(a):(b))

extern int sferror;
extern long filsfb();
extern char *chans;	/* from setchan() */
extern char *chanspec;
extern int otty;

ftos(sfd, begin, end)
	CSNDFILE *sfd; long begin, end;
{
	register long i;
	register float *fp;
	register int nsib, nc;
	register float sscale = 32767.0;
	int fs_fn = 0, fs_fpos = 0;
	short buffer[BUFSIZE / sizeof(short)];


	if (getsfbuf(sfd))
		{ sferror = -1; return(-1); }
	fp = sfd->fb;
	nc = sfd->nc;
	nsib = sfd->nsib;
	begin *= nc;
	end *= nc;	/* convert to sample frames */
	begin = begin > 0 ? begin : 0;
	end = min(sfd->fs, end);

	for (i = begin; i < end; i++) {
		register long x;
		register long block; 
		register int bs = BUFSIZE / sizeof(short);

		if (!chans[i%nc]) continue;
		block = i / nsib;			
		if (block != sfd->secptr) 
		    if ((sfd->secptr = filsfb(sfd, block)) < 0)
			    { sferror = SFBNDER; break; }
		x = i % nsib;	/* get samp in buf */

		if (otty)  {
			register long s = *(fp+x)*sscale;
			printf("%d\t%d\n", i, s);
		} else {
			*(buffer + fs_fpos++) = (*(fp+x)*sscale);
			if (fs_fpos >= bs) {
				if ((fs_fn = write(1, (char *) buffer, BUFSIZE))
				    <=0) {
					sferror++;
					break;
				}
				fs_fpos = 0;
			}
		}
	}
	if (!otty) 
		if (fs_fpos > 0) {
			if ((fs_fn = write(1, (char *) buffer, 
			  fs_fpos*sizeof(short)))
			    <= 0)
				sferror++;
			fs_fpos = 0;
		}
	return(sferror);
}
E 1
