h57319
s 00002/00002/00407
d D 1.2 84/09/08 21:17:16 root 2 1
c Mark: corrected spelling of "losers" in printf's!
e
s 00409/00000/00000
d D 1.1 84/07/25 14:30:21 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <syslog.h>
#ifdef DEBUG
#endif

/* place to deposit list of who got clobbered */
char *Loosers;
#define LOOSERS "/loosers"

/*
 * regenfree - build a new free list from sdf files.  Works by making a
 * linked list of all blocks claimed by sdf files.  Conflicts between sdf
 * files over a particular block or block segment are resolved in favor of
 * who last successfully wrote the block, as determined by most recent
 * sfd->cp->cd of all files in contention.  
 * All files that loose are reported and logged.  
 */
/*
 * The use of this routine is if the free list gets garbaged either by the
 * sound file management system, or by a disk crash.  Note that if for
 * some reason the sound file system garbages it, many unpredictable
 * things can have happened, most of which can be recovered from by this
 * routine.  One which cannot is in the following scenario: one sdf file
 * claims a block.  Disaster occurs and another sdf file claims the same
 * one.  If it is caught at this point, file 1 is lost and we know it is
 * lost.  If however time passes and file 2 is deleted before the error is
 * checked, file 1 will appear to be ok, but will contain garbage.
 * Nothing whatever can be done about this.
 */

#ifdef DEBUG
int ferr=0;
int autopilot=0;
#else
extern int ferr;
extern int autopilot;
extern char sfdevice[];
extern char lockdevice[];
extern int boot;
#endif


regenfree(alloc)
	char *alloc;
{
	extern char *malloc(), *index(), *strcpy(), *strcat();
    FILE *fopen(), *fd;
    struct dskblk *cp;
    struct dskblk  **blkary, *mknewfree(), *newfree;
    int blklen, i;
    char errstr[80], *getsfile();
    struct sndesc *getsdfs(), *rootsfd, *sfd;

    if (boot || ingroup(SUPERGROUP)==1) {
	    rootsfd = getsdfs(sfdevice, &blklen);
	    if (ferr) {
		fprintf(stderr, "some sdf files are garbaged.\n");
		fprintf(stderr, "either delete the sdf files or fix them,\n");
		fprintf(stderr, "then run sfck again.\n");
		exit(ferr);
	    }
	    if (blklen == 0) {
		fprintf(stderr, "sfck: %s %s", sfdevice, 
			"no sound files found."); 
		if (yes("Want to make new free list?\n", autopilot))
		    if (inifree(sfdevice, alloc)) {
			char *x ="sfck: error making scratch free list.";
			fprintf(stderr, x);
			return(++ferr);
		    }
		return(0);
	    }
	    /* how many disk blocks */
	    for (sfd = rootsfd, blklen=0; sfd != NULL; sfd = sfd->nxtsdf) {
		    for (cp = sfd->cp; cp != NULL; cp = cp->next) {
			blklen++;
		    }
	    }
	    if ((blkary = (struct dskblk **) 
		malloc((unsigned) sizeof(struct dskblk *) * blklen)) == NULL) { 
		    perror("malloc");
		    exit(++ferr); 
	    }
	    for (sfd = rootsfd, i=0; sfd != NULL; sfd = sfd->nxtsdf) {
		    for (cp = sfd->cp; cp != NULL; cp = cp->next) {
			blkary[i++] = cp; 	/* fill the list */
		    }
	    }
	    blksort(blkary, blklen); 		/* sort it */
	    if (arbitrate(blkary, blklen) > 0 	/* if conflicts, */
		|| nothere(alloc))		/* or no free list */
	    {					/* make new one. */
		    if (!boot) {
			if (!yes("Want to fix free list?", autopilot)) {
			    fprintf(stderr, "ok, bye\n");
			    exit(++ferr);
			}
			(void) sprintf(errstr, 
				"sfck: creating file: %s", alloc);
			fprintf(stderr, "%s\n", errstr);
			/*VARARGS1*/ syslog(LOG_CRIT, errstr);
		    }
		    newfree = mknewfree(blkary, blklen);
		    /*
		     * fool wlist into thinking it can save "curent", 
		     * but nonexistant alloc while writing new free list
		     */
		    fd = fopen(alloc, "w");	/* write null length file */
		    if (fd == NULL) {
			perror("fopen");
			fprintf(stderr, "can't open file: %s\n", alloc);
			exit(++ferr);
		    }
		    if (fclose(fd) < 0) {
			    perror("fclose");
			    return(-1);
		    }
		    if (wlist(newfree, alloc, 1))/* overwrite with new one */ {
			fprintf(stderr, "wlist error on file: %s\n", alloc);
			exit(++ferr);
		    }
	    }
    } else {
	    fprintf(stderr, "sfck: sorry, you are not a wizard.\n");
	    exit(++ferr);
	}
    return(ferr);
}

struct sndesc *getsdfs(dir, cnt)
	char *dir; int *cnt;
{
	FILE *popen(), *pp, *fopen(), *fp;
	struct sndesc *rsdf(), *sfd, *rootsfd=NULL, *cursfd;
	char tmp[1024];
	char *pre = " -name \'*";
	char *sdfext = SDFEXT;
	char *post = "\' -a -print";
	int first=0, i=0;

	(void) strcpy(tmp, "find ");
	(void) strcat(tmp, dir);
	(void) strcat(tmp, pre);
	(void) strcat(tmp, sdfext);
	(void) strcat(tmp, post);
	pp = popen(tmp, "r");
	if (pp == NULL) {
		fprintf(stderr, "popen failed: %s\n", tmp); 
		exit(++ferr);
	}
	while (fgets(tmp, 1024, pp) != NULL) {
	    char *c;
	    c = (char *) index(tmp, '\n'); 	/* zap return */ 
	    *c = NULL;
	    fp = fopen(tmp, "r");
	    if (fp == NULL) {
		    perror("fopen");
		    fprintf(stderr, "can't open %s\n",tmp); 
		    ++ferr; 
		    continue; 
	    }
	    sfd = rsdf(fp, tmp);
	    if (sfd == NULL) {
		    fprintf(stderr, "sfck: can't read or parse %s\n", tmp); 
		    syslog(LOG_CRIT, "sfck: can't read or parse %s", tmp); 
		    if (autopilot) {
			    fprintf(stderr, "sfck: unlinking %s\n", tmp);
			    syslog(LOG_CRIT, "sfck: unlinking %s", tmp);
			    if (unlink(tmp) != 0) {
				perror("unlink");
				++ferr;
				return(NULL);
			    }
			    if (fclose(fp) < 0) {
				++ferr;
				perror("fclose");
				return(NULL);
			    }
			    continue;
		    } else {
			    ++ferr; 
			    return(NULL); 
		    }
	    }
	    if (fclose(fp) < 0) {
		++ferr;
		perror("fclose");
		return(NULL);
	    }
	    if (!first) { 
		rootsfd = cursfd = sfd; 
		first++; 
	    } else {
		cursfd->nxtsdf = sfd;
		sfd->lstsdf = cursfd;
		cursfd = sfd;
		}
	    i++;
	}
	*cnt = i;
	return(rootsfd);
}

blksort(ary, len)
	struct dskblk *ary[]; int len;
{
    int gap, i, j;

    for (gap = len/2; gap > 0; gap /= 2)
	for (i = gap; i < len; i++)
	    for (j = i-gap; j >= 0; j -= gap) {
		if (ary[j]->base <= ary[j+gap]->base)
		    break;
		swap(&ary[j], &ary[j+gap]);
	    }
}

swap(px, py)	/* interchange *px and *py */
	char **px, **py;
{
    char *temp;

    temp = *px;
    *px = *py;
    *py = temp;
}


/*
 * arbitrate - take a free list, sorted by increasing block bases, consisting
 * of an array of pointers to free blocks, and look at them with a combinatorial
 * search for blocks that overlap, even by only one cylinder.  
 * If two blocks overlap, the one with the
 * latest altered date wins.  Various combinations are handled, such as n blocks
 * overlapping, or n small non-overlapping blocks which overlap a larger
 * inclusive one, and other such nightmares.
 */

arbitrate(ary, len)
	struct dskblk *ary[]; int len;
{
    int i, j, k, winner, looser, hit, winptr, looseptr, argument=0;
    int arberr=0;
    struct dskblk *loosers[512], *winners[512];	/* temp array for combatants */
    char *ptime();
    FILE *fopen(), *loosefd=NULL;

   
    for (i = 0; i < len-1; i++) {
	for (j = i+1, winptr=looseptr=0; j < len; j++) {
#ifdef DEBUG
	    printf("%d %d ", i, j);
#endif
	    if (ary[i]->dsksfd->err != 0) {
#ifdef DEBUG
		printf("skipping %s %d %d\n", 
		    ary[i]->dsksfd->sfn, ary[i]->base, ary[i]->len);
#endif
		break;	/* we've already nailed this guy */
	    }
	    if ((ary[i]->base + ary[i]->len) <= ary[j]->base) {	
		/* no conflict */
#ifdef DEBUG
		printf("no conflict between %s %d %d and %s %d %d\n",
		    ary[i]->dsksfd->sfn, ary[i]->base, ary[i]->len,
		    ary[j]->dsksfd->sfn, ary[j]->base, ary[j]->len);
#endif
		ary[i]->dsksfd->err = 0;
		continue;
	    }
	    argument++;
	    fprintf(stderr, "sfck: block overlap for files:\n");
	    fprintf(stderr, "\t\t%s, date= %s\n", ary[i]->dsksfd->sfn, 
		ptime(ary[i]->dsksfd->cdate));
	    fprintf(stderr, "\t\tflag=%c, base=%d, len=%d\n", 
		 ary[i]->flag, ary[i]->base, ary[i]->len);
	    fprintf(stderr, "\tand\n");
	    fprintf(stderr, "\t\t%s, date= %s\n", ary[j]->dsksfd->sfn, 
		ptime(ary[j]->dsksfd->cdate));
	    fprintf(stderr, "\t\tflag=%c, base=%d, len=%d\n", 
		 ary[j]->flag, ary[j]->base, ary[j]->len);
	    /* winner is whoever last successfully wrote the block */
	    winner = (ary[i]->dsksfd->cdate > ary[j]->dsksfd->cdate) ? i : j;
	    looser = (winner==i) ? j : i;
	    /* sort for duplication on win/loss lists */
	    for ( hit = 0, k = 0; k < winptr; k++ )
		if (winners[k] == ary[winner]) hit++;
	    if (!hit) winners[winptr++] = ary[winner];
	    for ( hit = 0, k = 0; k < looseptr; k++ )
		if (loosers[k] == ary[looser]) hit++;
	    if (!hit) loosers[looseptr++] = ary[looser];
	}
	if (argument) { /* oh-oh, somebody's in trouble! */
	    argument=0;
	    fprintf(stderr, "The winners are:\n"); 
	    for (k = 0; k < winptr; k++) {
		fprintf(stderr, "\t\t%s\n", winners[k]->dsksfd->sfn);
		winners[k]->dsksfd->err = 0;
	    }
D 2
	    fprintf(stderr, "The loosers are:\n");
E 2
I 2
	    fprintf(stderr, "The losers are:\n");
E 2
	    for (k = 0; k < looseptr; k++)
		fprintf(stderr,"\t\t%s\n", loosers[k]->dsksfd->sfn);
	    for (k = 0; k < looseptr; k++) {
		char tmp[32];
		(void) strcpy(tmp, loosers[k]->dsksfd->sfn);
		(void) strcat(tmp, SDFEXT);
		if (unlink(tmp) != 0)
		    fprintf(stderr, "sfck: (warning) can't unlink %s\n", tmp); 
		/* start logging complaints */
		if (loosefd == NULL)
		    {
		    char *z = "sfck: log of deleted sound files:";
		    setsfile(sfdevice);
		    Loosers = getsfile(LOOSERS);
		    fprintf(stderr, 
D 2
			"Will log loosers by appending file %s\n", 
E 2
I 2
			"Will log losers by appending file %s\n", 
E 2
			Loosers);
		    loosefd = fopen(Loosers, "a");
		    if (loosefd == NULL)
			{ 
			fprintf(stderr, "can't open file %s\n", Loosers); 
			exit(++ferr); 
			}
		    fprintf(loosefd, "\n");
		    fprintf(loosefd, z);
		    /*VARARGS1*/log(LOG_CRIT, z);
		    }
		fprintf(loosefd, "\t%s\n", tmp);
		log(LOG_CRIT, "sfck:\t%s\n", tmp);
		loosers[k]->dsksfd->err = 1;
		arberr++;
	    }
	}
    }
    if (loosefd != NULL) {
	fprintf(stderr, "Closing file: %s\n", Loosers);
	if (fclose(loosefd) < 0) {
		++ferr;
		perror("fclose");
		return(++arberr);
	}
	loosefd = NULL;
    }
    return(arberr);
}

/* 
 * mknewfree - setup new free list, copy block nodes from ary,
 * filling in with free blocks wherever there is a gap.
 */

struct dskblk *mknewfree(ary, len)
	struct dskblk *ary[]; int len;
{
    struct dskblk *ptr, *makenew(), *newfree, *claim();
    int i; 
    long curbase=0;
    struct sfstab *sfs, *dirinfo();

    sfs = dirinfo(sfdevice);
    if (sfs == NULL) { 
	fprintf(stderr, "sfgetfl: dirinfo failed\n"); 
	exit(1); 
    }
    newfree = makenew(sfs->devlen);
    for (i = 0; i < len; i++) {
	if (ary[i]->dsksfd->err != 0)
		continue;	/* this guy no good. */
	if (ary[i]->base > curbase) { /* fill gap with a free block */
	    ptr = claim(newfree, ary[i]->base - curbase);
	    curbase = ptr->base + ptr->len;
	    ptr->flag = FREED;	/* comes back ALLOCATED, change it */
	    ptr->seq = ptr->cd = 0;
	    ptr->dfn = (char *) malloc(5);
	    if (ptr->dfn == NULL) {
		perror("malloc");
		exit(++ferr); 
	    }
	    (void) strcpy(ptr->dfn, "none");
	}
	/* now make a node for this block */
	ptr = claim(newfree, ary[i]->len);
	curbase = ptr->base + ptr->len;
	ptr->dfn = (char *) malloc((unsigned) strlen(ary[i]->dsksfd->sfn)+1);
	if (ptr->dfn == NULL) { 
		perror("malloc"); 
		exit(++ferr); 
	}
	(void) strcpy(ptr->dfn, ary[i]->dsksfd->sfn);
	ptr->dsksfd = ary[i]->dsksfd;
	ptr->cd = ary[i]->dsksfd->cdate;
	ptr->seq = ary[i]->seq;
	/* leave their flags ALLOCATED */
    }
    /* finally, mark freed blocks unused, allocated blocks used */
    for ( ptr = newfree; ptr->flag != EOLIST; ptr = ptr->next )
	if ( ptr->flag == ALLOCATED ) ptr->flag = USED;
	else ptr->flag = UNUSED;
    return(newfree);
}

#ifdef DEBUG
main()
{
    regenfree();
}
#endif
E 1
