h02655
s 00002/00001/00804
d D 1.4 84/10/04 21:33:00 root 4 3
c this time for sure...
e
s 00007/00005/00798
d D 1.3 84/10/04 21:30:55 root 3 2
c removed spurious diagnostics
e
s 00001/00001/00802
d D 1.2 84/08/27 10:17:23 root 2 1
c fixed print statement in help() routine
e
s 00803/00000/00000
d D 1.1 84/07/25 14:29:22 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
D 3
/* %M%	%I%	(CARL)	%G%	%U% */
E 3
I 3
D 4
/* restorsf.c	1.2	(CARL)	8/27/84	10:17:23 */
E 4
I 4
/* %M%	%I%	(CARL)	%G%	%U% */

E 4
E 3
#include <stdio.h>
#include <carl/dumpsf.h>
#include <carl/libsf.h>
/* restorsf - see note at bottom */

extern char *malloc(), *calloc(), *strcpy();
#define lmin(A,B) ((A)<(B)?(A):(B))

/* source found on tape */
#define SRCEXISTS 01
/* destination already exists */
#define DESTEXISTS 02
/* wants to overwrite */
#define OVERWRITE 04
/* done */
#define RESTORED 08
/* can't override protection */
#define ERPROT 020


#define BIGBUF (20*TP_BSIZE)
/* general input buffer */
char    inbuf[BIGBUF],
       *ip = inbuf;

char   *sndumphed = SNDUMPHED;
char   *sntapehed = SNDTAPEHED;

/* what part of tape are we reading or about to read? */
int     whereontape = 0;
#define DUMPDIR 1
#define TAPEDIR 2
#define FILES 4

/* howmany files to restore */
int     filcnt = 0;

/* print directory only? */
int     pdir = 0,
        list = 0;

int     verbose;
int     badtape;
int     verify;
int     ferr;
int     autopilot;

/* current tape in this dump sequence */
int     curtseq;
/* next lowest numbered tape in this dump sequence */
int     mintseq;
/* kludge to be able to read a file off of the wrong tape */
int     tapeno;

struct retsnd {
    struct sndesc  *sfd;
    struct sfentry *sfe;
    char   *src;
    char   *dst;
    int     flg;
    struct retsnd  *nxtret;
    struct retsnd  *lstret;
};

pret (x)
struct retsnd  *x;
{
    struct retsnd  *y;
    for (y = x; y != NULL; y = y -> nxtret)
	printf ("sfd=%x sfe=%x src=%s dst=%s flg=%d nxtret=%x lstret=%x\n",
		y -> sfd, y -> sfe, y -> src, y -> dst, y -> flg, y -> nxtret, 
		y -> lstret);
}

/* these two from crack.c */
extern int  arg_index;
extern char *arg_option;

/* no rewind raw tape device, 1600 bpi, odd parity */
char   *tape = "/dev/rmt12";
/* rewind raw tape device, 1600 bpi, odd parity */
char   *rewtape = "/dev/rmt8";
int     tp;			/* fid for tape device */
int	noncontig;

main (argc, argv)
int     argc;
char  **argv;
{
	extern char *getprown();
    int     n;
    int     toggle = 0;
    char    ch;
    struct sndesc  *sopensf ();
    struct retsnd  *rootret = NULL,
                   *ret = NULL,
                   *cur = NULL;

    sfsetiname (argv[0]);

 /* get all -s and -d filenames */
    while ((ch = crack (argc, argv, "s|d|", 1)) != NULL) {
	if (toggle > 1 || toggle < 0) {
	    fprintf (stderr, "restorsf: arg. mismatch on or before arg: %s\n",
		    arg_option);
	    exit (1);
	}
	if (ch == 's') {
	    ret = (struct retsnd   *) calloc ((unsigned)1, 
		(unsigned) sizeof (struct retsnd));
	    if (ret == NULL) {
		perror ("restorsf");
		exit (1);
	    }
	}
	switch (ch) {
	    case 's': 
		ret -> src = (char *) malloc ((unsigned)
			strlen (arg_option) + 1);
		if (ret -> src == NULL) {
		    perror ("restorsf");
		    exit (1);
		}
		strcpy (ret -> src, arg_option);
		toggle++;
		break;
	    case 'd': 
		ret -> dst = (char *) malloc ((unsigned) 
			strlen (arg_option) + 1);
		if (ret -> dst == NULL) {
		    perror ("restorsf");
		    exit (1);
		}
		strcpy (ret -> dst, arg_option);
		toggle--;
		break;
	}
	if (ch == 'd') {
	/* got one more file */
	    if (rootret == NULL)
		rootret = cur = ret;
	    else {
		cur -> nxtret = ret;
		ret -> lstret = cur;
		cur = ret;
	    }
	}
    }

 /* get all other flags */
    arg_index = 0;		/* reset to scan all flags again */
    while ((ch = crack (argc, argv, "t|i|I|o|O|DLbvVyhn", 1)) != NULL) {
	switch (ch) {
	    /* set mode of restored files to be non-contiguous */
	    case 'n':
		noncontig = 1;
		break;
	    /* tape to use besides default */
	    case 't': 
		tapeno = atoi (arg_option);
		break;
	    case 'i': 
		tape = (char *) malloc ((unsigned)
			strlen (arg_option) + 1);
		strcpy (tape, arg_option);
		break;
	    /* rewind tape besides default */
	    case 'I': 
		rewtape = (char *) malloc ((unsigned)strlen (arg_option) + 1);
		strcpy (rewtape, arg_option);
		break;
	    /* output device */
	    case 'o': 		/* not implemented (stay tuned!) */
	    case 'O': 
		break;		/* imagine this sets an output device */
	    case 'L': 		/* just print filenames */
		list++;		/* no break - this also turns on pdir */
	    case 'D': 		/* user wants to print out directory only */
		pdir++;
		break;
	    case 'b': 
		badtape++;
		break;
	    case 'V': 
		verify++;
		break;
	    case 'v': 
		verbose++;
		break;
	    case 'y': 
		autopilot++;
		break;
	    case 'h': 
		help (0);
		break;
	}
    }

 /* get the rest of the files */
    if (!pdir)			/* then skip this step */
	for (; arg_index < argc; arg_index++) {
	    ret = (struct retsnd   *) malloc ((unsigned)sizeof (struct retsnd));
	    if (ret == NULL) {
		perror ("restorsf");
		exit (1);
	    }
	    ret -> src = (char *) malloc ((unsigned)strlen (argv[arg_index]) + 1);
	    if (ret -> src == NULL) {
		perror ("restorsf");
		exit (1);
	    }
	    strcpy (ret -> src, argv[arg_index]);
	    ret -> dst = (char *) malloc ((unsigned)strlen (argv[arg_index]) + 1);
	    if (ret -> dst == NULL) {
		perror ("restorsf");
		exit (1);
	    }
	    strcpy (ret -> dst, argv[arg_index]);
	    if (rootret == NULL)
		rootret = cur = ret;
	    else {
		cur -> nxtret = ret;
		ret -> lstret = cur;
		cur = ret;
		cur -> nxtret = NULL;
	    }
	}

/*    inbuf = (char *) malloc((unsigned)BIGBUF);*/

    if (!pdir && !isatty (0))	/* input from pipe or file? */
	while (fgets (inbuf, BUFSIZ, stdin) != NULL) {
				/* pick up some more file names */
	    extern char   *rindex (), *get1field (), *get2field ();
	    ret = (struct retsnd   *) malloc ((unsigned)sizeof (struct retsnd));
	    if (ret == NULL) {
		perror ("restorsf");
		exit (1);
	    }
	    ret -> src = get1field (inbuf);
	    if (ret -> src == NULL) {
		perror ("restorsf");
		exit (1);
	    }
	    ret -> dst = get2field ();
	    if (ret -> dst == NULL)
		ret -> dst = ret -> src;
	    if (rootret == NULL) {
		rootret = cur = ret;
		rootret -> nxtret = rootret -> lstret = NULL;
	    }
	    else {
		cur -> nxtret = ret;
		ret -> lstret = cur;
		cur = ret;
		cur -> nxtret = NULL;
	    }
	}

    if (verbose) {
	if (rootret != NULL)
	    printf ("File list:\n");
	for (cur = rootret; cur != NULL; cur = cur -> nxtret)
	    printf ("source: %-20s\tdestination: %-20s\n",
		    cur -> src, cur -> dst);
    }

 /* check write permission, and overwrite permission */
    if (!verify) {
	for (cur = rootret; cur != NULL; cur = cur -> nxtret) {
	    char    msg[80];
	    struct sndesc  *sfd,
	                   *accesf ();
	    sfd = accesf (cur -> dst);
	    if (sfd == NULL)	/* no existing file */
		continue;
	    else {		/* file already there, can we clobber it? 
	    *//* file in use? write permission? */
		cur -> flg |= DESTEXISTS;
		if (sfd -> rw != 0) {
		    fprintf (stderr,
			    "i/o in progress on file %s, will not restore.\n",
			    sfd -> sfn);
		    cur -> flg |= ERPROT;
		    continue;
		}
		if (ownspath (sfd -> sfn, getprown ()) < 0) {
		    fprintf (stderr,
			    "You do not have write permission for path %s\n",
			    sfd -> sfn);
		    cur -> flg |= ERPROT;
		    continue;
		}
		sprintf (msg, "File %s exists, overwrite?", sfd -> sfn);
		if (yes (msg, autopilot))
		    cur -> flg |= OVERWRITE;
		else
		    cur -> flg |= ~OVERWRITE;
	    }
	}

    /* make complete pathnames for all files */
	for (cur = rootret; cur != NULL; cur = cur -> nxtret) {
	    char   *o,
	           *getsfn ();
	    if (cur -> flg & ERPROT)
		continue;
	    o = getsfn (cur -> src, 0);
	    free (cur -> src);
	    cur -> src = (char *) malloc ((unsigned)strlen (o) + 1);
	    strcpy (cur -> src, o);
	    free (o);
	    o = getsfn (cur -> dst, 0);
	    free (cur -> dst);
	    cur -> dst = (char *) malloc ((unsigned)strlen (o) + 1);
	    strcpy (cur -> dst, o);
	    free (o);
	}
    }

    /* open tape, read tape header.  */
    if ((tp = open (tape, 0)) < 0) {
	perror ("restorsf:open");
	exit (1);
    }
    /* get directory header descriptor */
    if (rbuf (tp, inbuf) < 0) {
	perror ("restorsf:rbuf");
	exit (1);
    }
    if (strncmp (inbuf, sndumphed, strlen (sndumphed)) == 0) {
	/* we are looking at a sndump master directory */
	whereontape = DUMPDIR;
    }
    else if (strncmp (inbuf, sntapehed, strlen (sntapehed)) == 0) {
	/* we are looking at a sndump tape directory */
	whereontape = TAPEDIR;
    } else {
	fprintf (stderr, 
	    "Tape is not a sndump tape.  First line reads:\n%s",
		inbuf);
	fprintf (stderr, "Is the tape rewound correctly?\n");
	exit (1);
    }

 /* print out the header message, only for D mode, not for L */
    if (pdir && !list)
	printf ("%s", inbuf);

 /* read sndump tape or dump directory to see if file is on tape */
    while ((rbuf (tp, inbuf)) > 0) {
	register int    hit = 0,
	                tmp;
	struct sfentry *sfe,
	               *strsfe ();
	sfe = strsfe (inbuf);
	if (sfe == NULL)
	    continue;
	if (pdir)
	    if (list) {		/* name only */
		char   *stripsuf ();
		stripsuf (sfe -> nsnd, SNDEXT);
		printf ("%s\n", sfe -> nsnd);
	    }
	    else		/* whole thing */
		plentry (sfe, 1, 0);
	for (cur = rootret; cur != NULL; cur = cur -> nxtret) {
	    /* is it one we want? */
	    char   *c,
	           *stripsuf ();
	    c = stripsuf (sfe -> nsdf, SDFEXT);
	    if (!strcmp (cur -> src, sfe -> nsdf) && !(cur -> flg & ERPROT)) {
		hit++;
		break;
	    }			/* we've found one */
	    if (c != NULL)
		*c = '.';	/* put back the dot */
	}
	if (hit) {		/* yes, save the sfe */
	    cur -> flg |= SRCEXISTS;
	    cur -> sfe = sfe;
	    filcnt++;
	    hit--;
	    tmp = QTAPESEQ (sfe -> tapekey);
	    if (tmp < curtseq)
		curtseq = tmp;	/* lowest tape in sequence? */
	}
	else
	    fresfe (sfe);
    }

    if (pdir)
	goto rew1;		/* if only printing directory of tape we
				   are done */

 /* check to see if we have all files requested */
    for (cur = rootret; cur != NULL; cur = cur -> nxtret) {
	if (cur -> flg & ERPROT)
	    continue;		/* we've already complained */
	if (!(cur -> flg & SRCEXISTS)) {
	    fprintf (stderr, "File %s not on this", cur -> src);
	    if (whereontape == DUMPDIR)
		fprintf (stderr, " set of dump tapes.\n");
	    else
		fprintf (stderr, " tape.\n");
	}
    }

    if (!filcnt)
	goto rew;		/* nothing to do */

    /* get to start of files */
    if (whereontape == DUMPDIR) {
    /* step around master directory EOF */
	if (read (tp, inbuf, BIGBUF) != 0) {
	    perror("restorsf:read");
	    fprintf (stderr, "restorsf: error reading master directory\n");
	    exit (1);
	}
    /* get past tape dir and tape dir EOF */
	while ( read (tp, inbuf, BIGBUF) > 0)
	    /* empty */ ;
    }
    whereontape = FILES;

    /* what tape in the sequence do we start with? */
    /* step through tape looking for files */
    while (filcnt) {
	int     hit = 0;
	struct sndesc  *sdf,
	               *scansdf ();

	/* 
	 * find lowest numbered tape in sequence that still has files
	 * that need to be restored.
	 */
	if (tapeno)
	    mintseq = tapeno;
	else {
	    mintseq = 1000000;
	    for (cur = rootret; cur != NULL; cur = cur -> nxtret) {
		/* if not yet restored  and  no errors */
		/* 
		 * anybody who ever dumps more than 1000000 tapes 
		 * in one dump deserves a medal, or the electric chair. 
		 */
		if ((!(cur -> flg & RESTORED)) && (!(cur -> flg & ERPROT))) {
		    /* what tape in this sequence is it on? */
		    register int    foo;
		    foo = QTAPESEQ (cur -> sfe -> tapekey);
		    if (foo < mintseq)
			mintseq = foo;
		}
	    }
	}
    /* are we done with the current tape? */
	if (mintseq > curtseq) {/* yes we are done */
	    fprintf (stderr, "restorsf: mount tape %d\n", mintseq);
	    rewnd ();
mounted:    if (yes ("Is the tape mounted?", 0)) {
		int e;
		/* open tape, read tape header.  */
		if ((tp = open (tape, 0)) < 0) {
		    perror ("restorsf:open");
		    exit (1);
		}
		curtseq = mintseq;/* reset tape sequence counter */
		/* get directory header descriptor */
		if (rbuf (tp, inbuf) < 0) {
		    perror ("restorsf:rbuf");
		    exit (1);
		}
		if (strncmp (inbuf, sntapehed, strlen (sntapehed)) != 0) {
		    fprintf (stderr,
			    "Tape is not a sndump tape.  First line reads:\n%s",
			    inbuf);
		    exit (1);
		}
		/* read down the tape directory and its EOF */
		while ((e = read (tp, inbuf, BIGBUF)) > 0)
D 3
			fprintf(stderr, "count=%d\n", e);
E 3
I 3
			continue;
			/* fprintf(stderr, "count=%d\n", e); */
E 3
	    /* we should now be looking at the next sdf file */
	    }
	    else
		if (yes ("Do you want to abort?", autopilot))
		    exit (1);
		else
		    goto mounted;
	}

	if (badtape) {
	    if (close (tp) < 0)
		perror ("close");
	    printf ("restorsf is initialized. ^Z to suspend restorsf,\n");
	    printf("adjust tape to head of desired descriptor file with mt,\n");
	    printf ("then wake restorsf up and type  y  to continue.\n");
	    if (!yes ("Type  y  to continue.", 0))
		/* empty */;
	    if ((tp = open (tape, 0)) < 0) {
		perror ("restorsf:open");
		exit (1);
	    }
	}

	/* snarf sdf */
	rebuf ();		/* reset rbuf to read next time */
	if (rbuf (tp, inbuf) < 0) {
	    perror ("restorsf:rbuf");
	    exit (1);
	}
	if ((sdf = scansdf (inbuf)) == NULL) {
	    fprintf (stderr, "restorsf: error scanning sdf from tape.\n");
	    exit (++ferr);
	}
	else {			/* get rid of invalid cylinder list that
				   scansdf() gives us */
	    delink (sdf -> cp);
	    sdf -> cp = NULL;
	/* 
	 * don't zero sdf->ncyls which we need when we opensf the
	 * soundfile to restore the sounds into.
	 */
	}
	/* fprintf(stderr, "scansdf: sdf->fs = %d\n", sdf->fs); */
	/* get past EOF of sdf file */
	while (read (tp, inbuf, BIGBUF) > 0)
		/* empty */ ;
	/* see if it's anybody we want, good old linear searches */
	for (cur = rootret; cur != NULL; cur = cur -> nxtret)
	    if (cur -> flg & RESTORED)
		continue;
	    else {
		if (!strcmp (cur -> src, sdf -> sfn)/* names match */
			&&!(cur -> flg & ERPROT)) {
				/* and we can restore it */
		    hit++;
		    break;
		}
	    }
	if (hit) {		/* this one is on our hit list */
	    cur -> sfd = sdf;
	    if (verify) {
		if (verify_read (cur)) {
		    fprintf (stderr, "can't read %s\n", cur -> src);
		    ferr++;
		}
	    }
	    else {
		if (restore (cur)) {
		    fprintf (stderr, "error restoring %s to %s\n",
			    cur -> src, cur -> dst);
		    exit (-1);
		}
	    }
	    filcnt--;		/* got one */
	    hit = 0;
	}
	else {			/* don't want this guy */
	    freesfd (sdf);	/* back to the bit bucket */
	    /* get past sound samples to next file */
	    while (read (tp, inbuf, BIGBUF) > 0)
		/* empty */ ;
	}
    }
     /* 
      * for now this reads only one tape.  Stuff needs to be added
      * to make it read multiple tapes. 
      */

     /* how did we make out? */
rew: 
    if (!verify) {
	for (cur = rootret; cur != NULL; cur = cur -> nxtret) {
	    if (!(cur -> flg & RESTORED))
		fprintf (stderr, "file %s not restored to %s\n",
			cur -> src, cur -> dst);
	}
    }

     /* rewind the tape */
rew1: rewnd ();
    exit (ferr);
}

help (x) 
{
    fprintf (stderr,
	    "%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	    "usage: restorsf [flags] [names] [ < namelist ]\n",
	    "flags:\n",
	    "-sS\tS is the name of a source file on the tape\n",
	    "-dD\tD is destination file name on the disk \n",
	    "NB: each -s flag must be followed by a -d flag\n",
	    "-iT\tuse device T as input device instead of /dev/rmt0\n",
	    "-IT\tuse device T as rewind device besides /dev/rmt0\n",
I 2
	    "-D\tprint directory of the tape\n",
E 2
	    "-L\tjust print filenames on the tape\n",
D 2
	    "-L\tprint directory of the tape\n",
E 2
	    "-V\tverify readability of tape. \n",
	    "-n\tmake all restored files non-contiguous.\n",
	    "NB: you must supply a list of files on the tape to verify.\n",
	    "-v\tverbose mode\n",
	    "-y\tautomatically answer yes to all questions\n"
	    );
	    exit (x);
}

rewnd () 
{
    if (close (tp)) {
	perror ("restorsf:close");
	exit (1);
    }
    if ((tp = open (rewtape, 0)) < 0) {
	perror ("restorsf:open");
	exit (1);
    }
    if (close (tp)) {
	perror ("restorsf:close");
	exit (1);
    }
}

/* restore - read in sound samples, write the file on disk */

restore (ret)
struct retsnd  *ret;
{
    extern long sndo();
    long     st,
            nsamps;
    int     n,
            ibps,
            rtnval;
    long    fsamps;
    char   *buf;
    struct sndesc  *sfd,
                   *sopensf ();
    char    sfopt[2];


    sfd = ret -> sfd;
    free (sfd -> sfn);		/* change src name to dst name */
    sfd -> sfn = (char *) malloc ((unsigned) strlen (ret -> dst) + 1);
    if (sfd -> sfn == NULL) {
	perror("malloc");
	exit(1);
    }
    strcpy (sfd -> sfn, ret -> dst);
    fsamps = sfd -> fs;
D 3
    fprintf (stderr, "restore: fsamps = %d\n", fsamps);
E 3
I 3
    /* fprintf (stderr, "restore: fsamps = %d\n", fsamps); */
E 3
    sfd -> tpkey = ret -> sfe -> tapekey;
				/* copy the valid tape key from sfe */
    sfd -> dumpd = ret -> sfe -> dumpdate;/* and the valid dump date */
    if (noncontig)
	sfd -> rtflag = NRT;
    if ((sfd = sopensf((char *) NULL, "w", sfd)) == NULL || sfd -> err)
	return (1);
D 3
    printf ("restoring %s to %s\n", ret -> src, sfd -> sfn);
E 3
I 3
    if (verbose)
	    printf ("restoring %s to %s\n", ret -> src, sfd -> sfn);
E 3
     /* set input and output packing */
    ibps = (sfd -> pm == PM16BIT) ? sizeof (short) : sizeof (float);
    sfopt[0] = (sfd -> pm == PM16BIT) ? PM16BIT : PMFLOAT;
    sfopt[1] = NULL;
    buf = (char *) malloc ((unsigned) TBLKLEN);
    if (buf == NULL) {
	perror("malloc");
	exit(1);
    }
     /* snarf them samples */
    for (st = 0; ((n = read (tp, buf, TBLKLEN)) > 0); st += nsamps) {
	nsamps = n / ibps;
	if (n == TBLKLEN)
	    nsamps = lmin (fsamps - st, TBLKLEN / ibps);
	rtnval = sndo (sfd, buf, st, nsamps, sfopt);
	if (rtnval < 0)
	    break;
    }
    if (n < 0) {
	fprintf (stderr, "restorsf: read error\n");
	if (closesf (sfd)) {
	    fprintf (stderr, "restorsf: error closing file %s\n", sfd -> sfn);
	    exit (1);
	}
	return (-1);
    }
    else
	if (n > 0 && rtnval == 0)/* we hit the end of file on writing */
	    fprintf (stderr,
D 3
		    "sndo: hit EOF\n");
E 3
I 3
		    "restosf: sndo hit EOF\n");
E 3

    sfd -> fs = fsamps;

     /* add comment to restored file saying where it came from */
    sprintf (buf, "Restored from file: %s", ret -> src);
    linkcom (sfd, buf);
    if (sclosesf (sfd)) {
	fprintf (stderr, "restorsf: error closing file %s\n", sfd -> sfn);
	exit (1);
    }
    ret -> flg |= RESTORED;
    free (buf);
    return (0);
}

verify_read (ret)
struct retsnd  *ret;
{
    int     n,
            nsamps,
            ibps;
    char   *buf;
    struct sndesc  *sfd,
                   *sopensf ();
    sfd = ret -> sfd;
    printf ("verify read: %s\n", sfd -> sfn);
    buf = (char *) malloc ((unsigned) TBLKLEN);
    ibps = (sfd -> pm == PM16BIT) ? sizeof (short) : sizeof (float);
     /* read down the file */
    for (; ((n = read (tp, buf, TBLKLEN)) > 0); )
	nsamps = n / ibps;
    if (n < 0) {
	fprintf (stderr, "restorsf: read error\n");
	return (-1);
    }

    ret -> flg |= RESTORED;	/* not really, just pretending */
    free (buf);
    return (0);
}

char   *str2;

/* get first string on a line */
char   *get1field (buf)
char   *buf;
{
    char   *rindex (), *str1, *c;
    c = rindex (buf, '\n');
    if (c != NULL)
	*c = NULL;		/* zap the newline */
    while (isspace (*buf))
	buf++;			/* strip preceeding space */
    for (c = buf; *c != NULL; c++) {
	if (isspace (*c))
	    break;
    }
    if (*c != NULL) {		/* it's space, isolate second field */
	*c++ = NULL;		/* terminate first string */
	while (isspace (*c))
	    c++;		/* strip preceeding space */
    /* rest of it is the second field pointed to by c */
	str2 = (char *) malloc ((unsigned) strlen (c) + 1);
	strcpy (str2, c);
    }
    else			/* end of string, only one field in line 
				*/
	str2 = NULL;
    str1 = (char *) malloc ((unsigned) strlen (buf) + 1);
    strcpy (str1, buf);
    return (str1);
}

/* get second string on a line */
char   *get2field () 
{
            return (str2);
}

/*
 * restorsf - incremental retrieve of sound files from magtape written by
 * dumpsf.  
 * See note at bottom of dumpsf.c for a description of the format of
 * these tapes.
 * Strategy: read arg list (or standard input) for a list of files
 * to be restored.  Format is either just a filename, indicating that that
 * file is to be retrieved from tape and written with the same name on the
 * sound system, or filename pairs indicating source and destination names.  
 * Filenames preceeded by flag -s, are sources, and
 * -d are destinations.
 * If a filename is preceeded by -s, as in -sfile1, file1 will be
 * sought on the tape, and written as the name of the next argument, which
 * must begin with -d, as in -dfile2.  Every file specified with -s must
 * be followed by exactly one file with -d or an error is generated.
 *
 * NOTE: All files with flag arguments must appear first, 
 * followed by files without flags.  E.g.,
 * % restorsf -sfile1 -dfile2 file3 file4...
 * will restore file1 as file2, then restore files 3 and 4...
 * 
 * After reading down the list of files, the destination names are checked
 * for write permission.  If you don't have write permission on a file, that
 * file will not be restored.
 * If a destination name conflicts with an
 * existing file that you can overwrite, you are asked to confirm 
 * that you want to delete the existing file.
 * 
 * Then the tape directory is checked.  If any source files are not on
 * this tape, you are informed of which ones.  Restoring commences.  When
 * all requested files have been extracted from this tape, you are told to
 * mount the next tape and the process continues until all files have been
 * restored, or you terminate the operation.
 * (Caveat: this version only extracts files from one tape per run.)
 */
E 1
