/* %M%	%I%	(CARL)	%G%	%U% */
# include <sys/types.h>
# include <stdio.h>
# include <signal.h>
# include <vaxuba/dsc.h>
# include <vaxuba/dsreg.h>
# include <carl/libsf.h>

#define TRUE 1
#define FALSE 0
#define IGNORE TRUE
#define DONT_IGNORE FALSE
#define ADCBASE 00
#define DSCDMA0 0
#define DSMAXADC 2

extern float sample_rate;
extern int arg_index;
extern char *arg_option;

int verbose, retry;
char *convover;
struct sndesc *sfd;
int adcfid;

char *dfltvalf[] = DFLTVALF;

short convs[]={-1,-1,-1,-1,-1};

extern int quitearly(), noint(), usage();

main(argc, argv)
	int argc; char **argv;
{
	extern long setfilts();
	int status, pid, w;
	struct sndesc *sfoargs();
	struct sfstab *dirinfo(), *d;
	char ch;
	long stblk, nsamps, fsamps, srate, dev;
	int i, j, quiet=0;
	long ipak;
	long filters = -1, brdmon = 0;
	long start, end; 

	sfd = sfoargs(argc, argv, &ipak, &start, &end, DFLTARGS, 
		dfltvalf, usage, IGNORE, TRUE);
	if (sfd == NULL) 
		exit(1);
	if (sfd->ncyls == 0) {
		fprintf(stderr, "record: must set time to record with -TN\n");
		usage();
	}
	arg_index=0;	/* reset crack */

	while ((ch = crack(argc, argv, "F|qvA|BM", IGNORE)) != NULL) {
		switch (ch) {
		case 'F':	/* set filters */ 
			filters = atoi(arg_option);
			switch (filters) {
				case 0: default: filters = DS20KHZ; break;
				case 1:	filters = DS10KHZ; break;
				case 2:	filters = DSBYPAS; break;
				case 3:	filters = DS5KHZ; break;
			}
			break;
		case 'q':		/* quiet mode */
			quiet++; 
			break;
		case 'v':		/* verbose */
			verbose++;
			break;
		case 'A':		/* ADC override */
			convover = arg_option;
			break;
		case 'B': 
			brdmon = DSBRD;
			break;
		case 'M': 
			brdmon = DSMON; 
			break; 
		}
	}

	again:
	stblk = sfd->cp->base * (sfd->blksiz / BPSECTOR);
	fsamps = sfd->fs = sfd->ncyls * sfd->blksiz /
		((sfd->pm == PM16BIT)? sizeof(short) : sizeof(float));
	if (!quiet)
		printf("Actual duration= %f\n",
			(float) fsamps/(sfd->nc * sfd->sr));

	nsamps = fsamps;
	if (convover == NULL) {	/* do the default converters */
		for (i = 0; i < sfd->nc; i++)
			convs[i] = ADCBASE + i;
	} else {
		for (i = j = 0; convover[i] != NULL && i < DSMAXADC; i++)
			if (convover[i] >= '1' && convover[i] <= '4') 
				convs[j++] = ADCBASE + convover[i] - '1';
	}
	srate = clck(sfd->sr); 	/* srate = 077 is 49152 KHz at CARL */
	sfd->sr = sample_rate;

	if (filters == -1)	/* set filters */
		filters = setfilts(sample_rate, AD);

	/* now get correct device to aim the dsc driver at */
	d = dirinfo(sfd->sfn);
	if (d != NULL) {
# ifdef MAJMIN
		dev = d->rdev;
# else MAJMIN
		dev = d->rdevn;
# endif MAJMIN
		if (verbose) 
			printf("snd dev=%s\n", d->snddev);
	} else {
		fprintf(stderr, "play: dirinfo failed on file %s\n", sfd->sfn);
		exit(1);
	}
	if ((adcfid = openadc()) < 0) { 
		fprintf(stderr, "can't get ADCs.\n"); 
		exit(1); 
	}
	if (!quiet) {
		char c, getans(); 
		c=getans("Press [RETURN] to record, anything else to abort\t");
		if (c != '\n') { 
			fprintf(stderr, "\naborting.\n"); 
			exit(1); 
		}
	}
	if ((pid = fork()) == 0) {
		catchint(noint);	/* child throws interrupts away */
		if (dsadc(sfd, adcfid, stblk, 0L, nsamps, srate, filters, 1L, 
			convs, dev, brdmon) < 0)
				exit(1);
		exit(0);
	}
	/* wait for process, or interrupts */
	catchint(quitearly);	/* parent catches interrupts */
	while ((w = wait(&status)) != pid && w != -1) 
		/* empty */ ;
	if (w == -1) 
		status = 1;

	if (retry) {
		retry = 0;
		goto again;
	}

	if (sclosesf(sfd) != 0) { 
		fprintf(stderr, "sclosesf failed\n"); 
		status = 2; 
	}

	exit(status);
}

catchint(introutine)
	int (*introutine)();
{
	register int i;
	
	for ( i = 0; i < NSIG; i++ )
		(void) signal(i, introutine);
}

noint() 
{ 
	/* empty */ 
}

quitearly(ind) 
	int ind;
{ 
	struct ds_fs dsf;
	int rstfid;

	if (adcfid > 0) {
		/* get ending time */
			if (ioctl(adcfid, DSDONE, &dsf) == -1) {
				perror("DSDONE"); 
				return;
			}
		if ((rstfid = open(DEVDSR0, 0)) < 0) {
			perror(DEVDSR0);
			return;
		} else
			(void) close(rstfid);
		if (ind == SIGINT) { 
			sfd->fs = dsf.bnosiz / sizeof(short);
			printf("recording stopped at %6.3f seconds\n", 
				sfd->fs/(sfd->nc*sfd->sr));
		} else if (ind == SIGQUIT)
			retry++;
	} 
}

usage()
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s",
"record [flags] [file]\n",
"\tflags: flag = (values:default)\n",
"\tcN = set number of channels to N (1, 2, 4:1),\n",
"\tRN =sample rate (",
DHISR,
"),\n",
"\tFN = set filters to N (0,1,2,3:0),\n",
"\tq  = quiet mode,\n",
"\tTN = set file size to N (expressed as time in seconds),\n",
"\tCN = set file size to N cylinders,\n",
"\tR =  remark(NULL),\n",
"\tI =  include(NULL),\n",
"\tp =  protection(0644)\n"
);
exit(1);
}
