/* %M%	%I%	(CARL)	%G%	%U% */
# include <stdio.h>
# include <sys/types.h>
/* # include <carl/sndio.h> */
# include <carl/libsf.h>
# include <vaxuba/dsc.h>
# include <vaxuba/dsreg.h>

#define DSCDMA0 0
#define DSCDSK0 0

/* from play.c */
extern int verbose;

/* how many buffers */
# define UBSIZE		2

extern char *valloc();

short *dsbuf;


char *dserrs[] = {
	"missing arguments/parameters",
	"converters in use",
	"buffer size wasn't modulo bsize",
	"buffer size was too small",
	"disk error",
	"converter error",
	"dsreset clobbered us"
};

dsadc(sfd, adcfid, stblk, stboff, nsamps, srate, filts, repeat, seq, dev, brdmon) 
	struct sndesc *sfd;
	int adcfid;
	long stblk, stboff, nsamps; 
	int srate, dev; 
	long filts, repeat;
	int brdmon;
	short *seq;
{
	extern struct sfstab *dirinfo();
	extern char *malloc();
	extern char *index();
	struct ds_seq dsseq;
	struct ds_err dserr;
	struct ds_fs dsf;
	register int erno;

	if (verbose)
		{
		printf("DSBNO=%D DSBOFF=%D DSCOUNT=%D ",
			stblk, stboff, nsamps * BP16BIT);
		printf("DSRATE=%O rep=%D ", 
			srate, repeat);
		printf("filts=");
		switch (filts) {
		    case DS20KHZ:	printf("%d", ASC_HZ20>>1);	break;
		    case DS10KHZ:	printf("%d", ASC_HZ10>>1);	break;
		    case DSBYPAS:	printf("%d", ASC_BYPASS>>1); 	break;
		    case DS5KHZ:	printf("%d", ASC_HZ05>>1);
		    }
		printf("\n");
		}

/*
 * 	if (sfd->sfn[0] == '/')
 * 		cp = sfd->sfn+1;
 * 	else
 * 		cp = sfd->sfn;
 * 
 * 	if ((cp = index(cp, '/')) == NULL) {
 * 		fprintf(stderr, "dsdac: no '/' in sfn\n");
 * 		return(1);
 * 	}
 * 
 * 	n = cp - sfd->sfn;
 * 	if ((cp = malloc(n+100)) == NULL) {
 * 		perror("malloc");
 * 		return(1);
 * 	}
 * 
 * 	strncpy(cp, sfd->sfn, n);
 * 	cp[n] = NULL;
 * 	if ((dp = dirinfo(cp)) == NULL) {
 * 		fprintf(stderr, "dsdac: dirinfo failed\n");
 * 		return(1);
 * 	}
 * 
 * 	if ((dsbuf = (short *) valloc((unsigned) dp->bsize * UBSIZE)) == NULL) {
 * 		perror("valloc");
 * 		return(1);
 * 	}
 */

	if ((dsbuf = (short *) valloc(sfd->bufsiz * UBSIZE)) == NULL) {
		perror("valloc");
		return(1);
	}

	if (setdsseq(adcfid, seq, DSCDMA0) < 0)	/* set up sequence ram */
		{
		fprintf(stderr, "converter sequence garbled\n");
		return(-1);
		}

	dsseq.dirt = srate;
	if (ioctl(adcfid, DSRATE, &dsseq) == -1) 
		{ perror("dsrate"); return(-1); }

	dsseq.dirt = dev;	/* set from rdevn field of sfstab */
	if (ioctl(adcfid, DSDEV, &dsseq) == -1)
		{ perror("dsdev"); return(-1); }

	/* add filter params */
	if (ioctl(adcfid, filts, (struct ds_fs *) NULL) == -1) 
	    { perror("filts"); return(-1); }

	while (repeat--)
		{
		/* amount of file to convert */
		dsf.bnosiz = nsamps * BP16BIT;	/* bytes to transfer */
		if (ioctl(adcfid, DSCOUNT, &dsf) == -1) 
			{ perror("dsount"); return(-1); }

		/* starting block in file */
		dsf.bnosiz = stblk;
		if (ioctl(adcfid, DSBNO, &dsf) == -1) 
			{ perror("dsbno"); return(-1); }

		/* byte offset in first block */
		dsf.bnosiz = stboff;
		if (ioctl(adcfid, DSBOFF, &dsf) == -1) 
			{ perror("dsboff"); return(-1); }

		/* set broadcast or monitor mode */
		if (brdmon != 0) {
			if (ioctl(adcfid, brdmon, &dsf) == -1)
			{ perror("brdmon"); return(-1); }
		}

		if (verbose) fprintf(stderr, "reading...");
		if (read(adcfid, (char *) dsbuf, sfd->bufsiz * UBSIZE) == -1) 
			{ 
			perror("read");
			if (ioctl(adcfid, DSERRS, &dserr) == -1) 
				{ perror("dserrs"); return(-1); }
			switch (dserr.errors) 
				{
				case EDS_ARGS : erno = 0; break;
				case EDS_ACC : erno = 1; break;
				case EDS_MOD : erno = 2; break;
				case EDS_SIZE : erno = 3; break;
				case EDS_DISK : erno = 4; break;
				case EDS_CERR : erno = 5; break;
				case EDS_RST : erno = 6; break;
				}
			fprintf(stderr, "%s dmacsr=%o, asccsr=%o, errors=%o\n", 
				dserrs[erno], 
				dserr.dma_csr & ((u_short) -1), 
				dserr.asc_csr & ((u_short) -1),
				dserr.errors & ((u_short) -1));
			}
		if (verbose) printf("!\n");
		}
	if (close(adcfid) < 0)
		perror("close");
	free((char *) dsbuf);
	return(0);
	}
