#include<stdio.h>
#include<math.h>
#include <carl/carl.h>
#include <carl/sndio.h>

extern float fsndi();

glitch(sfd, ind, cnt)
	CSNDFILE *sfd;
	long ind, cnt;
{
	float	in1, in2, oldslope, newslope, err;
	double	agerr = 0;
	long 	nsamps = 2;
	int	N = 10;
	char	ch;

	if ((cnt -=2) <= 0)
		return(-1);
	in1 = fsndi(sfd, ind++);
	in2 = fsndi(sfd, ind++);
	oldslope = in2 - in1;
	in1 = in2;
	while (cnt--) {
		in2 = fsndi(sfd, ind++);
		newslope = in2 - in1;
		err = newslope - oldslope;
		saveerr(nsamps, err, N);
		agerr += fabs(err);
		oldslope = newslope;
		in1 = in2;
		nsamps++;
	}
	diag(N);
	printf("average error=\t%f\n", agerr/nsamps);
}

#define HISTLEN 1024
float hist[HISTLEN];
int histind[HISTLEN];
int hi;

/*  hist contains the HISTLEN greatest errors in decreasing order */

saveerr(x, y, N)
	long	x;
	float	y;
	int	N;
{

	hi = N - 1;
	if (fabs(y) <= fabs(hist[hi]))
		return;
	while (fabs(y) > fabs(hist[--hi])) {
		hist[hi+1] = hist[hi];
		histind[hi+1] = histind[hi];
		if (hi == 0){
			hist[0] = y;
			histind[0] = x;
			return;
		}
	}
	hist[++hi] = y;
	histind[hi] = x;
	return;
}

diag(N)
	int N;
{
	register int i, j, k;

	float	list[HISTLEN];
	int	listind[HISTLEN];

	k = 0;

	/* try to group adjacent indices together */

	for (i=0; i < N; i++) if (histind[i] != 0){
		list[k] = hist[i];
		listind[k] = histind[i];
		k++;
		for (j=i+1; j < N; j++){
			if (abs(histind[j] - histind[i]) < 3){
				list[k] = hist[j];
				listind[k] = histind[j];
				histind[j] = 0;
				k++;
			}
		}
	}


	for (i=0; i < N; i++)
		printf("%d:\t%f\n",listind[i],list[i]);
}
