/* %M%	%I%	(CARL)	%G%	%U% */
extern char *valloc(), *calloc();
extern int inthappened;
# include <carl/carl.h>
# include <sys/types.h>
# include <carl/sndio.h>
# include <vaxuba/dsc.h>
# include <vaxuba/dsreg.h>
# include <stdio.h>
# include "play.h"
# include <errno.h>

extern int errno;

# ifdef ASW
extern int asw;	/* from playmain.c */
# endif ASW

# ifndef TRAKS
# define TRAKS	4
# endif  TRAKS

#define DSCDMA0 0
#define DSCDSK0 0	/* index into device table in driver for /snd */
#define DSCDSK1 1	/* index into device table in driver for /snd1 */
/* from play.c */
extern int verbose;
extern int noplay;

/* how many buffers */
# define UBSIZE		2

short *dsbuf;
long grepeat;

char ds[] = DEVDS0;

char *dserrs[] = {
	"missing arguments/parameters",
	"converters in use",
	"buffer size wasn't modulo bsize",
	"buffer size was too small",
	"disk error",
	"converter error",
	"dsreset clobbered us",
	""
};

extern long nblks(), mblks();

dsdac(sfd, stblk, stboff, nsamps, srate, filts, repeat, seq, dev) 
	CSNDFILE *sfd;
	long 	stblk; 	/* starting sector address */
	int	stboff; /* starting byte offset in block */
	long	nsamps; /* number of samples to convert */
	int	srate; 	/* sampling rate */
	int	filts; 	/* filter select */
	int	repeat; /* repeat count */
	short 	*seq;	/* converter address sequence */
	int 	dev;	/* media index */
{
# ifdef ASW
	extern char *connasw();
	extern char *disconnasw();
# endif ASW
	struct ds_seq dsseq;
	struct ds_err dserr;
	struct ds_fs dsf;
	register int dacfid, cnt=0, erno;
	long *blkbuf;

	if (verbose) {
		printf("DSBNO=%D DSBOFF=%D DSCOUNT=%D ",
			stblk, stboff, nsamps * BP16BIT);
		printf("DSRATE=%O rep=%D ", srate, repeat);
		printf("filts=");
		switch (filts) {
		    case DS20KHZ:	printf("%d", ASC_HZ20>>1);	break;
		    case DS10KHZ:	printf("%d", ASC_HZ10>>1);	break;
		    case DSBYPAS:	printf("%d", ASC_BYPASS>>1); 	break;
		    case DS5KHZ:	printf("%d", ASC_HZ05>>1);
		}
		printf("\n");
	}

	if (nsamps < 1) {
		fprintf(stderr, "dsdac: can't convert 0 samples!\n"); 
		return(-1);
	}

#ifdef SHORTFILEBUG
#define MINSIZE (2*8*1024)
	if (nsamps < MINSIZE) {
		fprintf(stderr, "dsdac: segment too short\n");
		return(-1);
	}
#endif

	/* ds driver will use this buffer for sample data transfer */
	if (dsbuf == NULL)
		if ((dsbuf = (short *) valloc((unsigned) 
		    sfd->bufsiz * UBSIZE)) == NULL) {
			perror("valloc");
			return(1);
		}

	grepeat = repeat;	/* so a [DEL] can stop repeating */
	while (grepeat-- > 0) {
		cnt = 0;
		while ((dacfid = open(ds, 1)) < 0) {
			if (inthappened) {
				fprintf(stderr, "inthappened=%d, aborting.\n",
					inthappened);
				return(0);
			}
			if (errno != ENXIO) {	/* convs. failing? */
				perror("dsdac:open");
				return(-1);
			}
			if (!cnt) { 		/* ENXIO means in use */
				cnt++; 
				fprintf(stderr,
					"waiting for DACs to be available...");
			}
			sleep(1);
		}
		if (cnt) 
			fprintf(stderr, " gotcha!\n");

#ifdef ASW
		/* set asw */
		if (asw) {
			char *cp;
			short i, xseq[MAXDACS+1];

			/*
			 * for now connect all 4 channels
			 * straight across.
			 */
			for (i = 0; i < MAXDACS; i++)
				xseq[i] = i;
			xseq[i] = -1;

			if ((cp = connasw("dacs", &xseq[0])) != NULL) {
				fprintf(stderr, "dsndac: connasw: %s\n", cp);
				goto errout;
			}
		}
#endif ASW

		if (setdsseq(dacfid, seq, 0)) 	/* set up sequence ram */
			{ close(dacfid); return(-1); }

		dsseq.dirt = srate;
		if (ioctl(dacfid, DSRATE, &dsseq) == -1) 
			{ perror("dsrate"); goto errout; }

		dsseq.dirt = dev;
		if (verbose)
			fprintf(stderr, "DSDEV: %d\n", dsseq.dirt);
		if (ioctl(dacfid, DSDEV, &dsseq) == -1)
			{ perror("dsdev"); goto errout; }

		/* add filter params */
		if (ioctl(dacfid, filts, (struct ds_fs *) NULL) == -1) 
		    { perror("filts"); goto errout; }

		/* amount of file to convert */
		dsf.bnosiz = nsamps * BP16BIT;	/* bytes to transfer */
		if (ioctl(dacfid, DSCOUNT, &dsf) == -1) 
			{ perror("dsount"); goto errout; }

		/* byte offset in first block */
		dsf.bnosiz = stboff;
		if (ioctl(dacfid, DSBOFF, &dsf) == -1) 
			{ perror("dsboff"); goto errout; }

		/* get block address buffer */
		dsf.bnosiz = nblks(sfd, stblk);
		if (verbose)
			fprintf(stderr, "nblks=%d\n", dsf.bnosiz);
		if ((blkbuf = (long *) calloc((unsigned) dsf.bnosiz, 
		    (unsigned) sizeof(long)))== NULL)
			{ perror("calloc"); goto errout; }
		/* tell dsc how many blocks to convert */
		if (ioctl(dacfid, DSNBLKS, &dsf) == -1) 
			{ perror("dsnblks"); goto errout; }

		/* fill buf with sector addresses, return # of blocks */
		if (mblks(sfd, blkbuf, stblk) <= 0) {
			fprintf(stderr, "dsdac: mblks failed\n");
			return(-1);
		}
		if (ioctl(dacfid, DSBLKS, (char *) blkbuf) == -1) 
			{ perror("dsblks"); goto errout; }

		if (verbose)
			break;
		if (write(dacfid, (char *) dsbuf, sfd->bufsiz * UBSIZE) == -1) {
		    if (!inthappened) {
			perror("write");
			if (ioctl(dacfid, DSERRS, &dserr) == -1) 
				{ perror("dserrs"); goto errout; }
			switch (dserr.errors) {
				case EDS_ARGS : erno = 0; break;
				case EDS_ACC : erno = 1; break;
				case EDS_MOD : erno = 2; break;
				case EDS_SIZE : erno = 3; break;
				case EDS_DISK : erno = 4; break;
				case EDS_CERR : erno = 5; break;
				case EDS_RST : erno = 6; break;
				default: erno = 7; break;
			}
			fprintf(stderr, "%s dmacsr=%o, asccsr=%o, errors=%o\n", 
				dserrs[erno], 
				dserr.dma_csr & ((u_short) -1), 
				dserr.asc_csr & ((u_short) -1),
				dserr.errors & ((u_short) -1));
		    }
		}
		close(dacfid);
	}
	free((char *) blkbuf);
	if (verbose) 
		printf("!\n");
#ifdef ASW
	if (asw) {
		char *cp;

		/* reset asw */
		if ((cp = disconnasw()) != NULL) {
			fprintf(stderr, "dsndac: disconnasw: %s\n", cp);
			return(1);
		}
	}
#endif ASW
	return(0);

errout:
	free((char *) blkbuf);
	close(dacfid);
#ifdef ASW
	if (asw) {
	char *cp;

	/* reset asw */
		if ((cp = disconnasw()) != NULL) {
			fprintf(stderr, "dsndac: disconnasw: %s\n", cp);
		}
	}
#endif ASW
	return(1);
}
