/* mix4.c	1.1	(IRCAM)	5/23/85	15:05:23 */
#include <math.h>
#include <stdio.h>
#include <carl/sndio.h>
#include <carl/carl.h>
#include <carl/procom.h>
#include <carl/snd.h>

#define MAXFUNC 128

char *pn[32];
int thread=0;
int verbose;
int entete;
int sr = 16000;

extern int sferror;
extern float sfexpr();

struct note {
	struct note *nxtn, *lstn;
	long begs, ends;
	float step, gain[4], fstep[4], faccu[4] ;
	unsigned func[4], chan, nchan;
	double accu;
	struct sndesc *sfd;
} *rootnote;

int dim[MAXFUNC];
float *fbuf[MAXFUNC];
int chans = 1;

extern struct sndesc *rootsfd;

extern char *arg_option;
extern int arg_index;
extern char crack();

main(argc, argv)
	char **argv;
{
	int showtime = 0, otty = isatty(1), unit, clck, trigger = 0;
             /*Isatty returns 1 if fildes is associated with a terminal
              *device, 0 otherwise. */
	float output[4], mixmax = 0;
				/*output can't be register variable */
	float fsndi();	/*read one sample at location sample, from file open on
			 * sfd, return it as a float */ 
	long maxlen, i, j; 
	char ch;
	float *bidon,bidon2,ttime;
	long tt;

	dim[0]=1;
	for (i=1; i<MAXFUNC ;i++) dim[i]=1024;
	falloc(0);
	*fbuf[0]=1;
	falloc(1);
	falloc(2);
	for (bidon = fbuf[1], bidon2 = 0; bidon<fbuf[1]+dim[1]; *bidon = bidon2 += 1.0/dim[1], bidon++);
	for (bidon = fbuf[2], bidon2 = 1; bidon<fbuf[2]+dim[2]; *bidon = bidon2 -= 1.0/dim[2], bidon++);
	while ((ch = crack(argc, argv, "R|c|svte", 0)) != NULL) {
		switch (ch) {
			case 'R' :
				sr = (int)sfexpr(arg_option, 1.0);
				fprintf (stderr, "sampling rate\t=\t%d\n",sr);
				break;
			case 'c' :
				chans = (int)sfexpr(arg_option, 1.0);
				if(chans < 1 || chans > 4) {
					fprintf (stderr, 
			"number of output channels is not between 1 and 4\n");
					exit(-1);
				}
				fprintf (stderr, 
					"number of output channels\t=\t%d\n",
						chans);
				break;
			case 's':	/* share open sound files */
				thread++;
				break;
			case 'v':	/* verbose */
				verbose++;
				break;
			case 't':
				showtime++;
				break;
			case 'e':	/* en-tete */
				entete++;
				break;
			default:
				mixhelp(0);
		}
	}
	if(!otty) whead();

	if ((maxlen = mixparse(argc, argv)) <= 0) 
						{
		fprintf(stderr, "mix: no output\n");
		exit(1);
	}

	unit = sr / 10 ;
	clck = 0;
	ttime = 0.1;
	for (i = 0; i < maxlen; i++) {
		register struct note *n;
		register float *bid1, bid2, scale, bid3;
		long samp;
		output[0] = output[1] = output[2] = output[3] = 0;
		for (n = rootnote; n != NULL; n = n->nxtn) {
			samp = (long) n->accu * n->chan + n->nchan;
			if (i < n->begs || i >= n->ends 
				    || samp >= n->sfd->fs)
				continue;
			scale = n->accu - (long) n->accu;
			bid2 = fsndi(n->sfd, samp);
			if (samp + n->chan < n->sfd->fs)
				bid3 = fsndi(n->sfd, samp + n->chan) - bid2;
			else
				bid3 = bid2 - fsndi(n->sfd, samp - n->chan);
			bid2 += bid3 * scale;
			for(j=0;j<chans;j++){
				bid1 = fbuf[n->func[j]] + (int) n->faccu[j];
 				output[j] += bid2 * n->gain[j] * (*bid1);
				n->faccu[j] = 
					n->faccu[j] + n->fstep[j] 
						< dim[n->func[j]] ?
					n->faccu[j] + n->fstep[j] 
						: dim[n->func[j]]-1;
			}
			n->accu += n->step;
			if(sferror) {
				fprintf(stderr, "mix: sferror=%d\n",sferror);
				exit(1); 
			}
		}
		for(j=0;j<chans;j++){
			if (output[j] < -1 || output[j] > 1){
				if (trigger == 0){
					fprintf(stderr,"mix: overflow\n");
					trigger++;
				}
			}
		}
		if (otty){
			printf("%d", i);
			for(j=0;j<chans;j++)
				printf("\t%f", output[j]);
			printf("\n");
		}
		else 
			for(j=0;j<chans;j++)
				putfloat(&output[j]);
		if (showtime) {
			clck++;
			if (clck == unit){
				clck = 0;
				fprintf(stderr,"%.1f ",ttime);
				ttime += 0.1;
			}
		}
		for(j=0;j<chans;j++)
			mixmax = 
				mixmax >= fabs(output[j]) ? 
					mixmax : fabs(output[j]);
	}
	fprintf(stderr,"\nmix: maximum absolute value = %f\n",mixmax);
	if (!otty) flushfloat();
}

mixhelp(x)
	int x;
{
fprintf(stderr, "%s%s%s%s%s%s%s%s",
"mix [flags] < scorefile\n",
" flags:\n",
" -s\tshare already-opened sound files between note statements\n",
" -v\tverbose, print digested form of score on stderr\n",
" -e\ten-tete, print the designation of the fields to be used\n",
" -RN\tset sampling rate to N (default=16000)\n",
" -t\tshow time\n",
" -c\tnumber of output channels\n"
);
exit(x);
}

#include <ctype.h>

scanbuf(buf)	/* reads a line and returns the number of fields
		 * puts in pn[] pointers for every field */
	char *buf;
{
	register char *c, *d;
	register int trigger = 0, i = 1;	/* pn[0] not used */

	while (isspace(*buf)) buf++;

	for (c = buf; *c != NULL; c++) {
		if (*c == ';') { *c = '\0' ; break; }
		if (!isspace(*c)) { 
			if (!trigger) { 
				if (*c == ',') {
					pn[i++] = c;	/* null p field */
					continue;
				}
				pn[i++] = c; 
				trigger++; 
			} 
			else {
				if (*c == ',') {
					*c = '\0';
					trigger = 0;
				}
			}
		}
		else { 
			*c = NULL; 
			trigger = 0; 
		}
	}
	return(i-1);
}

char buf[BUFSIZ]; 

long
mixparse(argc, argv)
	int argc; char **argv;
{
	struct sndesc *opensf();
	long max=0;
 
	if (entete) {
		int i;
		fprintf(stderr,
			"\nmix  btime  file  dur  offset  [chan]  [step]");
		for(i=1;i<=chans;i++)
			fprintf(stderr,"  g%d",i);
		fprintf(stderr," [");
		for(i=1;i<=chans;i++)
			fprintf(stderr," f%d ",i);
		fprintf(stderr,"]\n\n");
		fprintf(stderr,"mix: every line begening with the word ");
		fprintf(stderr," \"mix\" is a monophonic input of the mixer\n");
		fprintf(stderr,"btime (begin time), dur (duration), offset:");
		fprintf(stderr," in seconds or in samples (xxxS)\n");
		fprintf(stderr,"file: name of the soundfile\n");
		fprintf(stderr,"chan (optional): number of the selected ");
		fprintf(stderr,"channel of the input soundfile (c#)\n");	
		fprintf(stderr,"step (optional): step to read the input (s#)\n");
		fprintf(stderr,"g1");
		if(chans>1)
			fprintf(stderr,"..g%d",chans);
		fprintf(stderr,": gain for channel 1");
		if(chans>1)
			fprintf(stderr," to %d", chans);
		fprintf(stderr," of the output\n");
		fprintf(stderr,"f1");
		if(chans>1)
			fprintf(stderr,"..f%d",chans);
		fprintf(stderr," (optional): the envelope function for"); 
		fprintf(stderr," channel 1");
		if(chans>1)
			fprintf(stderr," to %d", chans);
		fprintf(stderr," of the output\n");
	}
	while ((fgets(buf, BUFSIZ, stdin) != NULL)) {
		register int n;
		register struct note *note;
		register short ii = 0, iii = 0;
		struct note *newnote();
		unsigned i = 0;
		float tmp1, tmp2;
		n = scanbuf(buf);
		if (comp(pn[1], "mix", 3)) {
		    if (n >= 6) if (*pn[6] == 'c') ii++;
		    if (n >= 6 + ii) if (*pn[6 + ii] == 's') iii++;
		    if ((n == 5 + ii + iii + chans) 
				|| (n == 5 + ii + iii + chans + chans)) {
			note = newnote();
			if (thread){ 	/* look for sfd opened already */
			    if((note->sfd=opensf(pn[3]))==NULL) { 
				fprintf(stderr, "mix: opensf failed\n");
				exit(1); 
			    }
			}
			else {
			    if((note->sfd=opensf(pn[3]))==NULL) { 
				fprintf(stderr, "mix: opensf failed\n");
				exit(1); 
			    }
			}
							/* sampling rate */
			tmp1 = sr;
							/* p2 - begin */
			note->begs = sfexpr(pn[2], tmp1);
							/* channels */
			note->chan = note->sfd->nc;
							/* p6 - channel# */
			note->nchan = ii ? (int)sfexpr(pn[6] + 1, 1.0) - 1 : 0;
			if(note->chan > 4 || note->nchan >= note->chan)
						chanerr();
							/* p5 - offset */
			note->accu = sfexpr(pn[5], note->sfd->sr);
							/* p6+ii - step */
			note->step = iii ? sfexpr(pn[6 + ii] + 1, 1.0) :
				note->sfd->sr / sr;
			ii += iii;
							/* p4 - duration */
			tmp2 = sfexpr(pn[4], tmp1);
			if (tmp2 < 0)	/* neg. time means EOF */
				tmp2 = (long)((note->sfd->fs /
					note->chan - note->accu) / note->step);
			note->ends = tmp2 + note->begs;
			max = max < note->ends ? note->ends : max;
				      /* p5+ii+1..p5+ii+chans - gain1..gain? */
			for(iii=0;iii<chans;iii++){
				note->gain[iii] = sfexpr(pn[6+ii+iii], 1.0);
							/* func1-? default 0 */
				note->faccu[iii] = note->func[iii] = 0;
			}
				      /* p5+ii+chans+1..p5+ii+chans+chans
							 - func1..func? */
			if ( n >= 6 + ii + chans) 
			for(iii=0;iii<chans;iii++){
				i = note->func[iii] =
					(short)sfexpr(pn[6+ii+iii+chans], 1.0);
				if (i >= MAXFUNC || fbuf[i] == NULL) exerr(i);
				if (tmp2 != 0)
					note->fstep[iii] =
						dim[note->func[iii]]/tmp2;
			}
			else
			for(iii=0;iii<chans;iii++)
				note->fstep[iii] = 0;
			if (verbose) 
				pnote(note);
		  }
		  else fprintf(stderr,"number of fields mismatch\n"); 
		}
		if (comp(pn[1], "gen", 3)) {
			ii = 0;
			if ( n >= 2 )
				if ( *pn[3] == '-' && *(pn[3] +1 ) == 'L'){
					i = (int) sfexpr(pn[3] + 2, 1.0);
					ii++;
				}
			if ( n >= (7 + ii) ){
				iii = (int) sfexpr(pn[2] , 1.0);
				if (fbuf[iii] == NULL && ii == 1) dim[iii] = i;
				if (falloc(iii)){
					if (!gen(iii, ii + 3, n)) dalloc(iii);
				}
			     else fprintf(stderr,"numero fonction incorrect\n");
			}
			else fprintf (stderr, "not enough fields\n");
		}
		if (comp(pn[1], "env", 3)) {
			ii = 0;
			if ( n >= 2 )
				if ( *pn[3] == '-' && *(pn[3] +1 ) == 'L'){
					i = (int) sfexpr(pn[3] + 2, 1.0);
					ii++;
				}
			if ( n >= (4 + ii) ){
				iii = (int) sfexpr(pn[2] , 1.0);
				if (fbuf[iii] == NULL && ii == 1) dim[iii] = i;
				if (falloc(iii)){
					float p, q;
					p = sfexpr(pn[3 + ii], 1.0);
					q = sfexpr(pn[4 + ii], 1.0);
					if (!env(iii, p, q)) {
						dalloc(iii);
						printf("pula\n"); }
				}
			     else fprintf(stderr,
					"numero fonction incorrect\n");
			}
			else fprintf (stderr, "not enough fields\n");
		}
	}
	return(max);
}

int comp(pont, string, n)
	char *pont;
	char string[];
	int n;
{
	int i;
	for(i=0; i<n; i++,pont++)  if (*pont != string[i]) return(0);
	return(1);
}
		
struct note *newnote()
{
	struct note *n;
	static struct note *last;

	n = (struct note *) malloc(sizeof(struct note));

	if (rootnote == NULL) {
		last = rootnote = n;
		n->lstn = n->nxtn = NULL;
	}
	else {
		last->nxtn = n;
		n->lstn = last;
		last = n;
		n->nxtn = NULL;
		}
	return(n);
}

pnote(n)
	struct note *n;
{
	int i;
	float sampr = sr, spr = n->sfd->sr;
	fprintf(stderr,
		"file: %s\nchans: %d chan#: %d\tstep: %6.3f\tsrate: %d\n",
		n->sfd->fullname,
		n->chan,
		n->nchan + 1,
		n->step,
		(long)n->sfd->sr);
	fprintf(stderr,
"begin: %6.3f[%d]\toffset: %6.3f[%d]\nend: %6.3f[%d]\tdur: %6.3f[%d]\n",
		n->begs/sampr,
		n->begs,
		n->accu/spr,
		(long)n->accu * n->chan + n->nchan,
		n->ends/sampr,
		n->ends - 1, 
		(n->ends - n->begs)/sampr,
		n->ends - n->begs);
	for(i=0;i<chans;i++)
		fprintf(stderr,"gain%1d: %6.3f\t",
		i + 1,
		n->gain[i]);
	fprintf(stderr,"\n");
	for(i=0;i<chans;i++)
		fprintf(stderr,"func%1d: %d\t",
		i + 1,
		n->func[i]);
#ifdef DEBUG
	fprintf(stderr,"\n");
	for(i=0;i<chans;i++)
		fprintf(stderr,"fstep%1d: %6.3f\t",
		i + 1,
		n->fstep[i]);
	fprintf(stderr,"\n");
	for(i=0;i<chans;i++)
		fprintf(stderr,"faccu%1d: %6.3f\t",
		i + 1,
		n->faccu[i]);
#endif
	fprintf(stderr,"\n");
}
exerr(i)
	int i;
{
	fprintf(stderr, "numero fonction incorrect: %d\n",i);
	exit(1);
}
chanerr()
{
	fprintf(stderr, "erreur canal\n");
	exit(1);
}
#include <math.h>

/* cc gen4.c -lfrm -lm -o gen4 */

gen(func, j, narg)
	int func, j, narg;
{
    float tcoef[100], vcoef[100], alpha[100], factor, *f, *ff, scale = 0.0;
    int i, length, seglen, nc=0, closed=1;

    length = dim[func];
    for(nc = 0; j < narg; nc++){
	tcoef[nc] = sfexpr(pn[j++], 1.0);
	if(nc > 0){
	    for(i = 0; i < nc; i++) if(tcoef[nc] <= tcoef[i]){
		fprintf(stderr,"GEN4: Non-increasing T values\n"); return(0);
	    }
	}
	vcoef[nc] = sfexpr(pn[j++], 1.0);
	if(j < narg) alpha[nc] = sfexpr(pn[j++], 1.0);
	if(fabs(vcoef[nc]) > scale)scale = fabs(vcoef[nc]);
    }

    for(i = 0; i < nc; i++)tcoef[i] *= (float) (length-closed)/tcoef[nc-1];
    if(scale == 0.0){ fprintf(stderr, "GEN4: all-zero f%d\n"); return(0); }

    for( 
	ff = f = fbuf[func], i=0; 
	    i < nc-1; 
		f += seglen-1, i++){
	seglen = floor(tcoef[i+1]+.5) - floor(tcoef[i]+.5) + 1;
	trans(vcoef[i], alpha[i], vcoef[i+1], seglen, f);
    }
	return(1); /* Return status of 0 if all went OK */
}
dalloc(n)
	int n;
{
	free (fbuf[n]);
	fbuf[n] = NULL;
	return(1);
}
falloc(n)
	int n;
{
	if (n<0 || n>=MAXFUNC) return(0);
	if (fbuf[n] != NULL) return(0);
	fbuf[n] = (float *) malloc(sizeof(float)*dim[n]);
	return(1);
}
env (x, p, q)
	int x;
	float p, q;
{
	int n;
	double max = 0, temp;
	if (p <= 0 || q <= 0) return(0);
	for (n = 0; n < dim[x] ; n++)
	{
		*(fbuf[x] + n) = temp = pow ((double)n/dim[x], p)
				* pow (1.0 - (double)n/dim[x], q);
		max = max < temp ? temp : max;
	}
	for (n = 0; n < dim[x] ; *(fbuf[x] + n++) *= (1.0/max));
	return(1);
}
whead()
{
	char srate[16], nchans[16];

	(void) sprintf(srate, "%f", (float)sr);
	(void) sprintf(nchans, "%d", chans);

	if (stdheader(stdout, "mix4_output", srate, nchans, H_FLOATSAM)) {
		fprintf(stderr, "stdheader failed\n");
		return(-1);
	}
	if (putheader(stdout)) {
		fprintf(stderr, "putheader failed\n");
		return(-1);
	}
	/*
	if (flushfloat() < 0) {
		fprintf(stderr, "flushfloat failed\n");
		return(-1);
	}
	*/
	return(0);
}
