/* sndi.c	1.1	(CARL)	7/25/84	13:44:37 */
#include <stdio.h>
#include <carl/libsf.h>
#define min(a,b) ((a) < (b) ? (a) : (b))

/*
 * sndi - read a block of sound samples
 *     sfd = sound file descriptor pointer,
 *     fx  = buffer array,
 *     st = index to starting sample in file,
 *     ns = number of samples to transfer
 *     op = special operations: 
 * 	  "s" = return samples as shorts
 * 	  "f" = return samples as floats
 */

long
sndi (sfd, cx, st, ns, op)
	struct sndesc  *sfd;
	char   *cx;
	long    st;
	long    ns;
	char   *op;
{
	extern char *index();
	long    stblk,
	        xoff,
	        xfrcnt,
	        curblk,
	        ssib;
	short  *sx = (short *) cx;
	float  *fx = (float *) cx;
	extern long    filsfb ();
	char    mkpack = PMFLOAT;

	if (op != NULL && index (op, PM16BIT) != NULL)
		mkpack = PM16BIT;
	if ((sfd->rw & SFREAD) == 0 || sfd->err)
		return (-1);
	if (st+ns >= sfd->fs) {/* truncate read */
		ns = sfd->fs - st;
		sfd->eof = TRUE;
	}
	else
		sfd->eof = FALSE;
	if (ns < 0)
		return (-1);	/* catch both st+ns > fs and ns < 0 */

	if (sfd->sb == NULL && sfd->fb == NULL) {/* get buffer */
		if (getsfbuf (sfd))
			return (-1);
	}

	stblk = st / sfd->nsib;/* starting buffer */
	ssib = st % sfd->nsib;/* starting sample in buffer */

	if (sfd->bdir == SFWRITE)/* finish all writes before doing any
				   reads */
		flushsf (sfd);

/*
 * index the byte in the sector, read ns samples, possibly  requiring
 * reading subsequent buffers, and maybe cylinders to get them all,
 * maybe less than a buffer.
 */

	for (curblk = stblk, xoff = 0, xfrcnt = min (sfd->nsib - ssib, ns);
			xfrcnt > 0;
			curblk += 1, ssib = 0, xoff += xfrcnt,
			xfrcnt = min (sfd->nsib, ns - xoff)
		) {
		register long   i;

		if (curblk != sfd->secptr) {
			if ((sfd->secptr = filsfb (sfd, curblk)) < 0)
				return (-1);
		}

		if (mkpack == 'f') {/* user wants floats */
			if (sfd->pm == PM16BIT) {
				/* and file is shorts */
				for (i = 0; i < xfrcnt; i++)
					fx[i+xoff] = sfd->sb[i+ssib] / 32767.0;
			}
			else {	/* and file is floats */
				for (i = 0; i < xfrcnt; i++)
					fx[i+xoff] = sfd->fb[i+ssib];
			}
		}
		else {		/* user wants shorts */
			if (sfd->pm == PMFLOAT) {
				/* and file is floats */
				for (i = 0; i < xfrcnt; i++)
					sx[i+xoff] = sfd->fb[i+ssib] * 32767.0;
			}
			else {	/* and file is shorts */
				for (i = 0; i < xfrcnt; i++)
					sx[i+xoff] = sfd->sb[i+ssib];
			}
		}
	}
	sfd->bdir = SFREAD;
	return (ns);
}
