/* ownspath.c	1.3	(CARL)	10/4/84	22:15:47 */

#include <stdio.h>
#include <pwd.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/* 
 * ownspath - check to see if a user owns the path.  Looks at a full
 * filename or pathname, and checks to see that the first subdirectory
 * matches the usr argument, returns >= 0 on success, -1 on failure.  
 * For instance, it returns 0 on input ownspath("/snd/dgl/frm", "dgl")
 * and returns -1 on ownspath("/snd/frm/dgl", "dgl");
 * Root and the disk superuser own all valid paths, and ownspath()
 * returns > 0 if the actual user is disk or root.
 */

ownspath (path, usr)
char   *path,
       *usr;
{
	extern char *strcpy();
	int 		entry;
	register int    rslt;
	register char  *c,
	               *d;
	char   *copy,
	       *sndsuperuser = SNDSUPERUSER;
	if (path == NULL || usr == NULL)
		return (-1);
	if (strlen(path) == 0 || strlen(usr) == 0)
		return(-1);
	if (!strcmp (usr, sndsuperuser))
		return (1);	/* Mr. Disk, sir. */
	if (getuid () == 0) {	/* its root; V7 UNIX does not setuid when 
				   the process is owned by root */
		struct passwd  *pw;
		extern struct passwd  *getpwnam ();

		pw = getpwnam (sndsuperuser);
		if (setuid (pw -> pw_uid) != 0) {
			perror("setuid");
			fprintf(stderr, "csound: ownspath failed\n");
			return(-1);
		}
		return (1);
	}
/* to get here means user has no special permissions */
	if ((copy = (char *) malloc ((unsigned) strlen (path) + 1)) == NULL)
		malerr("ownspath", 1);
	(void) strcpy (copy, path);
 /* disassemble path to extract username */
	for (c = copy; *c != '\0' && *c != '/'; c++)
		continue;				/* get first slash */
	if (*c == '\0')
		return (-1);
	for (c++; *c != '\0' && *c != '/'; c++)		/* get second / */
		continue;
	if (*c == '\0')
		return (-1);
	else
		c++;					/* step past it */
	for (d = c; *d != '\0' && *d != '/'; d++)	/* snarf name */
		continue;
	if (*d == NULL)					/* see note below */
		return(-1);
	else
		*d = '\0';				/* terminate it */
	rslt = (strcmp (c, usr)) ? -1 : 0;		/* equal? */
	free (copy);
	return (rslt);
}

/*
 * Note: to get here indicates that the user has no speical permission, and
 * is asking to create a new home directory on a csound filesystem, with a
 * name such as /snd/foo, for user foo.  Users are not allowed to install
 * themselves, but must be given system authorization.
 */
