/* mksfe.c	1.1	(CARL)	7/25/84	13:43:25 */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * Make an sfentry structure from an sndesc structure.  This routine
 * is used only by dumpsf and restorsf.  An sfentry structure is used
 * to create the directory entries that appear at the head of csound
 * dump tapes.
 */

struct sfentry *mksfe (sfd)
struct sndesc  *sfd;
{
	extern char *strcpy();
	struct sfentry *sfe;
	char   *allocat (), *sfestr ();
	if (sfd == NULL)
		return (NULL);
	if ((sfe = (struct sfentry *) malloc ((unsigned) 
	    sizeof (struct sfentry))) ==  NULL)
		    malerr("mksfe", 1);
	if ((sfe -> nsnd = allocat (sfd -> sfn, SNDEXT)) == NULL)
		    malerr("mksfe", 1);
	if ((sfe -> nsdf = allocat (sfd -> sfn, SDFEXT)) == NULL)
		    malerr("mksfe", 1);
	sfe -> status = sfd -> rw;/* current read/write status */
	sfe -> prot = sfd -> fprot;/* protection */
	sfe -> links = 1;	/* # links */
	if ((sfe -> owner = (char *) malloc ((unsigned) 
	    strlen (sfd -> sfown) + 1)) == NULL)
		    malerr("mksfe", 1);
	(void) strcpy (sfe -> owner, sfd -> sfown);/* file owner */
	sfe -> size = sfd -> ncyls;/* size in cylinders used */
	sfe -> rt = sfd -> rtflag;/* realtime? */
	sfe -> modate = sfd -> adate;/* time last modified */
	sfe -> dumpdate = sfd -> dumpd;/* date dumped */
	sfe -> tapekey = sfd -> tpkey;
	sfe -> entry = sfestr (sfe);/* make string entry */
	return (sfe);
}
