/* getsfile.c	1.1	(CARL)	7/25/84	13:42:53 */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * setsfile() and getsfile() manage the filename default-handling
 * routines.  setsfile() takes a partial filename spec. and sets up the
 * appropriate defaults for filling in the rest of the name.  getsfile()
 * also takes a partial filename spec. and returns a full pathname based
 * on defaults set up by setsfile().
 * 
 * There are three parts to a filename: /<device>/<path>/<body>.
 * setsfile() and getsfile() will handle getting any combination of just
 * the body, just the device, or the device and path.  setsfile(NULL) sets
 * the defaults to the union of the environment variable SFENVPATH
 * (defined in libsf.h)  and the built in defaults SFDEV and SFPATH, plus
 * the owner of the process, got with getprown().
 * 
 * getsfile() will accept just the body, just the device or the device and
 * path also.  getsfile(NULL) returns all the defaults built by the
 * previous call to setsfile().
 */



char   *actualdev = NULL;

char   *
getsfile (special)
	char   *special;
{
	extern char *strcpy(), *strcat();
	register char  *rtn, strln;

	if (special != NULL)
		strln = strlen (special);
	else
		strln = 0;
	if ((rtn = (char *) malloc ((unsigned) strlen(actualdev) + strln + 1)) 
	    == NULL)
		malerr("getsfile", 1);
	(void) strcpy (rtn, actualdev);
	(void) strcat (rtn, special);
	return (rtn);
}

setsfile (path)
	char   *path;
{
	extern char *index(), *strcpy();
	register char  *fullname,
	               *devend;
	char   *index (), *getsfn ();
	if (actualdev != NULL)
		free (actualdev);
	fullname = getsfn (path, 0);
	if (fullname == NULL)
		return;
	devend = index (fullname + 1, '/');
	if (devend != NULL) {
		if ((actualdev = (char *) malloc (
		    (unsigned) (devend - fullname + 1))) == NULL)
			malerr("setsfile", 1);
		*devend = NULL;
	}
	else
		actualdev = (char *) malloc ((unsigned) strlen (fullname) + 1);
	if (actualdev == NULL)
		malerr("setsfile", 1);
	(void) strcpy (actualdev, fullname);
	free (fullname);
}
