/* freesfd.c	1.1	(CARL)	7/25/84	13:42:22 */
#include <stdio.h>
#include <carl/libsf.h>

/* send an sfd back to the bit bucket */

/* root of all open sound file descriptors, declared in sfsetintr.c */
extern struct sndesc   *rootsfd;

freesfd (sdp)
struct sndesc  *sdp;
{
	struct dskblk  *cp;
	struct inclist *inc;
	struct comlist *com;

	if (sdp == NULL)
		return;
	for (cp = sdp -> cp; cp != NULL;) {
		if (cp -> next != NULL) {
			cp = cp -> next;
			free ((char *) cp -> last);
		}
		else {
			free ((char *) cp);/* free last link */
			break;
		}
	}
	for (inc = sdp -> inclsdf; inc != NULL;)
		if (inc -> incnext != NULL) {
			inc = inc -> incnext;
			free ((char *) inc -> inclast);
		}
		else {
			free ((char *) inc);/* free last link */
			break;
		}
	for (com = sdp -> comsdf; com != NULL;)
		if (com -> comnext != NULL) {
			com = com -> comnext;
			free ((char *) com -> comlast);
		}
		else {
			free ((char *) com);/* free last link */
			break;
		}
	if (sdp -> sfn != NULL)
		free (sdp -> sfn);
	if (sdp -> sfown != NULL)
		free (sdp -> sfown);
 /* manage the linked list of open sound file descriptors */
	if (sdp -> lstsdf == NULL) {
				/* this is the current root of list */
		rootsfd = sdp -> nxtsdf;
				/* make next one be the new root */
		if (rootsfd != NULL)/* if there is a next one */
			rootsfd -> lstsdf = NULL;
				/* then zero its back pointer */
	/* else rootsfd contains NULL */
	}
	else {			/* there is one before this one */
		sdp -> lstsdf -> nxtsdf = sdp -> nxtsdf;
				/* make foreward link */
		if (sdp -> nxtsdf != NULL)/* and there is one after us */
			sdp -> nxtsdf -> lstsdf = sdp -> lstsdf;
				/* make back link */
	}
	free ((char *) sdp);
	return;
}
