/* closesf.c	1.1	(CARL)	7/25/84	13:41:53 */
#include<stdio.h>
#include<carl/sndio.h>

/*
 * User-level proc. to close a sound file opened with opensf().  It
 * calls popen() to invoke the user command closesf to close the file,
 * and sends the text version of the file descriptor to closesf.
 * closesf is a set-user-id program that has write permission on the
 * sdf directory.  closesf() can thus be called in a program that does
 * not have such permission to still access sound files.
 */

extern int      sferror;

closesf (sfd)
struct sndesc  *sfd;
{
	char   *buf = "closesf";
	FILE * pp, *popen ();

	pp = popen (buf, "w");
	if (pp == NULL) {
		fprintf (stderr, "popen failed\n");
		sferror = IOER;
		return (-1);
	}

	if (wsdf (pp, sfd)) {
		fprintf (stderr, "closesf: wsdf failed\n");
		sferror = IOER;
		return (-1);
	}

	(void) pclose (pp);
	sferror = 0;		/* reset for next guy */
	return (0);
}
