/* addcp.c	1.1	(CARL)	7/25/84	13:41:26 */
#include <stdio.h>
#include <carl/libsf.h>

/*
 * sfd is a new sfd that is being constructed or modified.
 * cpentry is a string from an sdf file of the form
 * <base> <tab> <length> <tab> <flags> <NULL>
 * which specifies a cylinder block address.
 * The action is to build a linked list on the sfd of the disk blocks the
 * file points to.
 */

struct dskblk  *addcp (sfd, cpentry)
	struct sndesc  *sfd;
	char   *cpentry;
{
	extern char    *calloc (), *malloc (), *strcpy ();
	struct dskblk  *cdp,
	               *c;
	int     nscans;

	if ((cdp = (struct dskblk *) calloc (1, (unsigned) sizeof 
		(struct dskblk))) == NULL)
		    malerr("addcp", 1);
	nscans = sscanf (cpentry, "%c%d%d%d", &cdp -> flag, &cdp -> base,
			&cdp -> len, &cdp -> seq);
	if (nscans < 4 || nscans == EOF)
		return (NULL);
	if (sfd -> cp == NULL)	/* first time */
		sfd -> cp = cdp;
	else {			/*  link at end of list */
		for (c = sfd -> cp; c -> next != NULL; c = c -> next);
		c -> next = cdp;
		cdp -> last = c;
		cdp -> next = NULL;
	}
	if ((cdp -> dfn = (char *) malloc ((unsigned) 
	    strlen (sfd -> sfn) + 1)) == NULL)
		malerr("addcp", 1);
	(void) strcpy (cdp -> dfn, sfd -> sfn);
	cdp -> dsksfd = sfd;
	cdp -> cd = sfd -> cdate;
	return (cdp);
}
