/* accesf.c	1.1	(CARL)	7/25/84	13:41:23 */
#include <stdio.h>
#include <carl/libsf.h>

extern int      sferror;

/*
 * accesf looks for a named sdf file.  returns the sound file descriptor
 * if successful, else NULL.
 * It subjects name to filename expansion via getsfn() and tacks on the
 * SDFEXT extension.
 * The returned descriptor is not marked open for i/o.
 */

struct sndesc  *accesf (name)
char   *name;
{
	extern char    *malloc (), *strcpy (), *index (), *strcat ();
	extern struct sfstab  *dirinfo ();
	struct sfstab  *sfs;
	struct sndesc  *sfd,
	               *rsdf ();
	char   *o,
	       *p;
	char   *getsfn ();

	if (name == NULL)
		return (NULL);

	sferror = 0;
	if (ismlocked (name) < 0) {
		fprintf (stderr, "accesf: %s is masterlocked\n", 
			getsfile ((char *) NULL));
		sferror = SFNOFILE;
		return (NULL);
	}

	o = getsfn (name, 0);
	p = (char *) malloc ((unsigned) strlen (o) + strlen (SDFEXT) + 1);
	if (p == NULL) {
		sferror = SFDER;
		return (NULL);
	}
	(void) strcpy (p, o);
	(void) strcat (p, SDFEXT);
	sferror = 0;
	sfd = rsdf ((FILE *) NULL, p);
	free (o);
	free (p);
	if (sferror) {
		fprintf (stderr, "accesf: error reading %s\n", name);
		return (NULL);
	}
	if (sfd == NULL) {
		return (NULL);	/* file not found is an ok return */
	}
	if ((sfs = dirinfo (sfd -> sfn)) == NULL) {
		sferror = SFNOFILE;
		return (NULL);
	}
	if (index (sfs -> devmode, 'x')) {/* offline? */
		fprintf (stderr, "accesf: %s disabled\n", sfs -> sdfdir);
		sferror = SFNOFILE;
		return (NULL);
	}
 /* sfd->lkfile = sfs->lkdev; */
	sfd -> bufsiz = sfs -> bsize;
	sfd -> blksiz = sfs -> bpblock;
	return (sfd);
}

/*
 * main(argc, argv)
 * 	int argc; char **argv;
 * {
 * 
 * 	while (--argc)
 * 		{
 * 		struct sfentry *sfe, *accesf();
 * 		sfe = accesf(*++argv);
 * 		if (sfe != NULL)
 * 			printf("%s\n", sfe->entry);
 * 		}
 * 	}
 */
