h57666
s 00001/00001/00129
d D 1.4 84/09/09 23:09:53 disk 4 3
c sclosesf now only updates the free list if the file was
e
s 00000/00001/00130
d D 1.3 84/08/07 13:54:43 disk 3 2
c removed stray diagnostic message
e
s 00005/00006/00126
d D 1.2 84/08/06 15:39:40 disk 2 1
c fixed bug where ignall was not getting called always..
e
s 00132/00000/00000
d D 1.1 84/07/25 13:43:58 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * sclosesf - close a sound file.  System version of close.  closesf() is
 * the user version.  First see if file already closed, return ok if so.
 * If file open for writing, flush its buffers (if any),  update
 * allocation file by changing all cylinders from CLAIMED to USED, update
 * rtime and atime.  If open for reading, just update rtime.  Write out
 * sound descriptor file.
 */

extern int      sfintlevel;	/* has sclosesf been called at interrupt
				   level? */
extern int      interlock;	/* from allocsf.c */

int     norefupd;		/* if !=0, don't update time
				   referenced/altered */

extern  FILE * lockfopen ();
extern  FILE * lockfp;		/* from lockfopen.c */
extern  int	sferror;	/* from sopensf */

sclosesf (sfd)
D 2
struct sndesc  *sfd;
E 2
I 2
	struct sndesc  *sfd;
E 2
{
	extern long	time ();
	extern int     wsdf (), flushsf (), quitit ();
	struct dskblk  *rlist ();
	int     err = 0;
	struct dskblk  *head;
	FILE * fp;
	char   *allocat (), *getsfn (), *getsfile (), *alloc;

D 2
 /* FORCE sez to allow i/o in progress to complete, damn the torpedos */
E 2
I 2
D 3
	fprintf(stderr, "sclosesf file: %s\n", sfd->sfn);
E 3
E 2
	if (sfd == NULL)
		return (0);	/* you can close nothing */
	if (sfd -> rw == SFCLOSED && !fa_blocks (sfd -> cp))
		return (0);	/* don't close twice, but its ok */
	if ((err = checksfd (sfd)) != 0) {
		fprintf (stderr, 
			"sclosesf: sound descriptor not ok, can't close: %o\n",
				err);
		return (-1);
	}
I 2
	if (!sfintlevel)
		ignall ();/* ignore interrupts unless already ignored */
E 2

	if (sfd -> rw & SFREAD)	/* close file open for reading */
		if (norefupd == 0)
			/* modify ref. date */
			sfd -> rdate = time ((long *) NULL);

D 4
	if ((sfd -> rw & SFWRITE) || fa_blocks (sfd -> cp)) {
E 4
I 4
	if (sfd -> rw & SFWRITE) {
E 4
				/* close for writing */
		flushsf (sfd);	/* force out remaining i/o */
		if (norefupd == 0)
				/* modify a/r time */
			sfd -> rdate = sfd -> adate = time ((long *) NULL);

		setsfile (sfd -> sfn);
		alloc = getsfile (ALLOCNAME);
D 2
		if (!sfintlevel)
			ignall ();/* ignore interrupts unless already
				   ignored */
E 2
		(void) umask (~(0664));
		interlock = 1;	/* do interlocked read/write of free list */
		if ((fp = lockfopen (alloc, "r+")) == NULL) {
				/* update allocation file */
			fprintf (stderr, "sclosesf: lockfopen failed on: %s\n",
			    alloc);
			return (-1);
		}
		lockfp = fp;	/* save fid for wlist to use */
		if ((head = rlist (fp)) == NULL) {
			fprintf (stderr, "sclosesf: error reading: %s\n", 
				alloc);
			return (-1);
		}
		if (cklist(alloc, head) != 0) {
			fprintf (stderr, 
				"sclosesf: %s: contaminated free list\n",
				alloc);
			return(-1);
		}
		if (trim (head, sfd) != 0) {
			fprintf (stderr, 
 			    "sclosesf: warning, error trimming file: %s\n", 
				sfd -> sfn);
		}
		if (markall (head, sfd, TRUE) != 0) {
			fprintf (stderr, 
			    "sclosesf: allocation check error on file: %s\n",
			    sfd -> sfn);
			return (-1);
		}
	/* write allocation arena */
		if (wlist (head, alloc, 1) != 0) {
			fprintf (stderr, "sclosesf: error updating %s\n", 
				alloc);
			return (-1);
		}
		free (alloc);
	}

 /* write sound descriptor file */
	sfd -> rw = SFCLOSED;
	if (wsdf ((FILE *) NULL, sfd)) {
		fprintf (stderr, 
			"sclosesf: error closing file: %s\n", sfd -> sfn);
		sferror = IOER;
		return (-1);
	}

D 2
	freesfd (sfd);		/* free the sfd structure */
E 2
	if (!sfintlevel)
		catchall (quitit);
	sync ();		/* for multiple cpu file systems */
I 2
	freesfd (sfd);		/* free the sfd structure */
E 2
	return (err);
}

fa_blocks (cp)
struct dskblk  *cp;
{
	struct dskblk  *p;

	for (p = cp; p != NULL; p = p -> next) {
		if (p -> flag == ALLOCATED || p -> flag == FREED)
			return (1);
	}
	return (0);
}
E 1
