h37772
s 00021/00007/00058
d D 1.3 84/10/04 22:15:47 root 3 2
c fixed ownspath to avoid allowing users to create home 
c directories in a new filesystem.
e
s 00001/00005/00064
d D 1.2 84/07/31 17:18:19 root 2 1
c removed setgid; group stuff was dropped long ago
e
s 00069/00000/00000
d D 1.1 84/07/25 13:43:37 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
I 2

E 2
#include <stdio.h>
#include <pwd.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/* 
 * ownspath - check to see if a user owns the path.  Looks at a full
 * filename or pathname, and checks to see that the first subdirectory
 * matches the usr argument, returns >= 0 on success, -1 on failure.  
 * For instance, it returns 0 on input ownspath("/snd/dgl/frm", "dgl")
 * and returns -1 on ownspath("/snd/frm/dgl", "dgl");
 * Root and the disk superuser own all valid paths, and ownspath()
 * returns > 0 if the actual user is disk or root.
 */

ownspath (path, usr)
char   *path,
       *usr;
{
	extern char *strcpy();
I 3
	int 		entry;
E 3
	register int    rslt;
	register char  *c,
	               *d;
	char   *copy,
	       *sndsuperuser = SNDSUPERUSER;
	if (path == NULL || usr == NULL)
		return (-1);
	if (strlen(path) == 0 || strlen(usr) == 0)
		return(-1);
	if (!strcmp (usr, sndsuperuser))
		return (1);	/* Mr. Disk, sir. */
	if (getuid () == 0) {	/* its root; V7 UNIX does not setuid when 
				   the process is owned by root */
		struct passwd  *pw;
		extern struct passwd  *getpwnam ();

		pw = getpwnam (sndsuperuser);
		if (setuid (pw -> pw_uid) != 0) {
			perror("setuid");
D 2
			fprintf(stderr, "csound: ownspath failed\n");
			return(-1);
		}
		if (setgid (pw -> pw_gid) != 0) {
			perror("setgid");
E 2
			fprintf(stderr, "csound: ownspath failed\n");
			return(-1);
		}
		return (1);
	}
I 3
/* to get here means user has no special permissions */
E 3
	if ((copy = (char *) malloc ((unsigned) strlen (path) + 1)) == NULL)
		malerr("ownspath", 1);
	(void) strcpy (copy, path);
 /* disassemble path to extract username */
D 3
	for (c = copy; *c != NULL && *c != '/'; c++)
		/* empty */;				/* get first slash */
	if (c == NULL)
E 3
I 3
	for (c = copy; *c != '\0' && *c != '/'; c++)
		continue;				/* get first slash */
	if (*c == '\0')
E 3
		return (-1);
D 3
	for (c++; *c != NULL && *c != '/'; c++);	/* get second / */
	if (c == NULL)
E 3
I 3
	for (c++; *c != '\0' && *c != '/'; c++)		/* get second / */
		continue;
	if (*c == '\0')
E 3
		return (-1);
	else
		c++;					/* step past it */
D 3
	for (d = c; *d != NULL && *d != '/'; d++);	/* snarf name */
	*d = NULL;					/* terminate it */
E 3
I 3
	for (d = c; *d != '\0' && *d != '/'; d++)	/* snarf name */
		continue;
	if (*d == NULL)					/* see note below */
		return(-1);
	else
		*d = '\0';				/* terminate it */
E 3
	rslt = (strcmp (c, usr)) ? -1 : 0;		/* equal? */
	free (copy);
	return (rslt);
}
I 3

/*
 * Note: to get here indicates that the user has no speical permission, and
 * is asking to create a new home directory on a csound filesystem, with a
 * name such as /snd/foo, for user foo.  Users are not allowed to install
 * themselves, but must be given system authorization.
 */
E 3
E 1
