h34640
s 00074/00000/00000
d D 1.1 84/07/25 13:42:51 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/sndio.h>
extern char *malloc(), *calloc(), *realloc();

/* getsfbuf - claim and initialize a buffer */

/* if this is != 0, it stipulates an override for the size of a buffer */
/* this is exported to sopensf and opensf */
int    sfbufsiz;

extern int      sferror;	/* from sopensf */

setsfbuf (size)
	int    size;
{
	if (size % 512) {
		fprintf (stderr, "setsfbuf: size must be modulo 512\n");
		sferror = SFBNDER;
		return (-1);
	}
	sfbufsiz = size;
	return (0);
}


getsfbuf (sfd)
struct sndesc  *sfd;
{
	/* set size of buffer in bytes */
	register char  *x;

	if ((x = (char *) calloc ((unsigned) sfd -> bufsiz, 
	    (unsigned) sizeof (char))) == NULL)
		malerr("getsfbuf", 1);
	if (sfd -> pm == PM16BIT)
		sfd -> sb = (short *) x;
	else
		sfd -> fb = (float *) x;
	sfd -> secptr = -1;	/* force reading/writing first buffer */
	sfd -> sbptr = 0;
	sfd -> sbcnt = sfd -> nsib = sfd -> bufsiz / sfd -> ssize;
	return(0);
}

/*
 * stunsf - "stun" a sound file
 * 
 * This routine sanitarily removes the buffer associated with a particular
 * sound file.  Thus, if you have zillions of sound files open, you can
 * reduce the space that inactive sound files occupy without the expense
 * of a closesf() operation by stunning them.
 * 
 * A stunned sound file still has a totally valid sfd structure, linked on
 * the list of open files.  Essentially, the sfd is made to look just like
 * it did when it came from opensf().  Subsequent read/write operations
 * will claim and fill a new buffer automatically, so you need not keep
 * track of which files are stunned.  Given the computational and i/o
 * expense connected with closesf(), it is better to stun a file than
 * close it if there is any chance it will be used again.
 */

stunsf (sfd)
	struct sndesc  *sfd;
{
	if (sfd -> pm == PM16BIT) {
		if (sfd -> sb)
			free ((char *) sfd -> sb);
	}
	else {
		if (sfd -> fb)
			free ((char *) sfd -> fb);
	}
}
E 1
