h45091
s 00110/00000/00000
d D 1.1 84/07/25 13:41:55 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/* cpsfd - copy an sfd.  
 * Note: the following fields are not copied: cp, cdate, rdate, adate,
 * dumpd and tpkey.  Ncyls is copied even though cp isn't so you can use it
 * to claim new cylinders.  The typical use of a copied sfd is to hand it
 * to sopensf() to clone a copy of a file, as is done in the program cpsf. 
 * None of the working fields (buffer pointers, etc.)
 * of the sfd are copied, so you get a 'virgin'
 * sfd.
 */

char    fields[] =
{
    FSR, FPM, FNC, FSFOWN, FSFN, FRTFLAG, FNCYLS, FFS, FREM, FINC, FPROT, NULL
};

struct sndesc  *cpsfd (sfd)
struct sndesc  *sfd;
{
	struct sndesc  *setsfd (), *nsfd;
	char   *c,
	        ct[2];
	struct inclist *inc;
	struct comlist *com;

	if (sfd == NULL)
		return (NULL);
	if ((nsfd = (struct sndesc *) calloc (sizeof (struct sndesc), 1)) 
		== NULL)
		    malerr("cpsfd", 1);
	ct[1] = NULL;
	for (c = fields; *c != NULL; c++) {
		ct[0] = *c;
		switch (*c) {
			case FSR: 
				nsfd -> sr = sfd -> sr;
				break;
			case FPM: 
				nsfd -> pm = sfd -> pm;
				break;
			case FNC: 
				nsfd -> nc = sfd -> nc;
				break;
			case FSFOWN: 
				nsfd = setsfd (nsfd, ct, sfd -> sfown);
				break;
			case FSFN: 
				nsfd = setsfd (nsfd, ct, sfd -> sfn);
				break;
			case FRTFLAG: 
				nsfd -> rtflag = sfd -> rtflag;
				break;
			case FNCYLS: 
				nsfd -> ncyls = sfd -> ncyls;
				break;
			case FFS: 
				nsfd -> fs = sfd -> fs;
				break;
			case FREM: 
				if (sfd -> comsdf == NULL)
					break;
				for (
					com = sfd -> comsdf; 
					com != NULL; 
					com = com -> comnext
				    )
					if (linkcom (nsfd, com -> cmt) < 0)
						goto err;
				break;
			case FINC: 
				if (sfd -> inclsdf == NULL)
					break;
				for (
					inc = sfd -> inclsdf; 
					inc != NULL; 
					inc = inc -> incnext
				    )
					if (linkinc (nsfd, inc -> fn) < 0)
						goto err;
				break;
			case FPROT: 
				nsfd -> fprot = sfd -> fprot;
		}
		if (nsfd == NULL)
			goto err;	/* checks on return status of setsfd */
	}

	return (nsfd);
err: 	freesfd (nsfd);
	return (NULL);
}


/*
 * char *args[] = {"test"};
 * 
 * main(argv, argc)
 * 	int argv; char **argc;
 * {
 *     struct sndesc *sopensf(), *sfd, *nsfd;
 *     sfd = sopensf("baz", "r", NULL);
 *     nsfd = cpsfd(sfd, "f", args);
 *     psdf(stdout, nsfd, 1);
 *     sclosesf(sfd);
 *     }
 */
E 1
