/* cpsf.c	1.3	(CARL)	9/11/84	10:22:50 */
#include <stdio.h>
#include <carl/libsf.h>
#include <math.h>
#define min(a,b) ((a) < (b) ? (a) : (b))


int debug;
long geticb(), getocb();

extern char *getprown();	/* from libsf */
int interact;

main(argc, argv)
    	int argc; char *argv[];
{
	char *iname = NULL;
	char *oname = NULL;
	char *fulli, *fullo, *getsfn(), *getofile(), ch;

	sfsetiname(argv[0]);		/* pass name to interrupt routines */

	while ((ch = crack(argc, argv, "ibh", 0)) != NULL) {
		switch (ch) {
			case 'i':	
			    interact++; 
			    break;
			case 'b':
			    debug++;
			    break;
			case 'h':
				usage(0);
			default:
				usage(1);

		}
	}

	if (arg_index < argc-2)
		usage(1);
	iname = argv[arg_index++];
	oname = argv[arg_index];
	fulli = getsfn(iname, 0);
	fullo = getofile(iname, oname);
	if (cpsf(fulli, fullo))
		exit(1);
	exit(0);
}

cpsf(fulli, fullo)
	char *fulli, *fullo;
{
	struct sndesc *isfd, *osfd, *tsfd, 
	    *sopensf(), *cpsfd(), *setsfd(), *accesf();
	int ifid, ofid, interact=0;
	long from, to, Lcf, t, f;
	char *getsfn(), *getofile(), *buf;
	struct	sfstab	*osfstab, *dirinfo();

	if (!strcmp(fulli, fullo)) {
		fprintf(stderr, "cpsf: input name same as output: %s, %s\n",
		    fulli, fullo);
		return(1);
	}
	if (interact) {
		if ((tsfd = accesf(fullo)) != NULL) {
			char prompt[80];
			sprintf(prompt, "%s%s%s", "File exists: ", 
				fullo, " overwrite?");
			if (!yes(prompt, 0))
				return(0);
			freesfd(tsfd);
		}
	}

	if ((isfd = sopensf(fulli, "r", NULL)) == NULL) {
		fprintf(stderr, "sopensf failed on %s\n", fulli);
		return(1);
	}
	tsfd = cpsfd(isfd);	/* copy the input sfd */
	free(tsfd->sfn);			/* stick in the output name */
	tsfd = setsfd(tsfd, "f", fullo);
	tsfd = setsfd(tsfd, "t", "r");	/* force it to be realtime */
	if (!ingroup(SUPERGROUP))
		tsfd = setsfd(tsfd, "o", getprown());
	osfstab = dirinfo(fullo);	/* get the cylinder size for out */
	tsfd -> ncyls = (long) ceil((double) isfd -> fs * isfd -> ssize / osfstab -> bpblock);
	if ((osfd = sopensf(NULL, "w", tsfd)) == NULL) {
		sclosesf(isfd); 
		return(1); 
	}

	if (close(isfd->fid) < 0) {
		perror("close");
		return(1);
	}
	if (close(osfd->fid) < 0) {
		perror("close");
		return(1);
	}
	if ((ifid = getrawdev(isfd->sfn, 0)) == -1) {
		fprintf(stderr, "cpsf: aborting\n");
		exit(1);
	}
	if ((ofid = getrawdev(osfd->sfn, 1)) == -1) {
		fprintf(stderr, "cpsf: aborting\n");
		exit(1);
	}

	Lcf = isfd->blksiz == osfd->blksiz 
		? osfd->blksiz : LARGEST_COMMON_FACTOR;
	buf = (char *) malloc(Lcf);

	for (	from = geticb(isfd) * isfd->blksiz, 
		to = getocb(osfd) * osfd->blksiz, t = f = 0; 
		from >= 0 && to >= 0;
		) {

		register long n;

		if ((n = lseek(ifid, from + f, 0)) < 0) {
			perror("lseek"); 
			return(n); 
		}
		if ((n = read(ifid, buf, Lcf)) != Lcf) {
			perror("read"); 
			return(n); 
		}
		if ((n = lseek(ofid, to + t, 0)) < 0) {
			perror("lseek"); 
			return(n); 
		}
		if ((n = write(ofid, buf, Lcf)) != Lcf) {
			perror("write"); 
			return(n); 
		}
		osfd->fs += Lcf / osfd->ssize;
		if(osfd->fs > isfd->fs){
			osfd->fs = isfd->fs;
			break;
		}
		f += Lcf;
		t += Lcf;
		if (f >= isfd->blksiz) {
			from = geticb(isfd) * isfd->blksiz;
			f = 0;
		}
		if (t >= osfd->blksiz) {
			to = getocb(osfd) * osfd->blksiz;
			t = 0;
		}
	}

	free(buf);
	if (sclosesf(isfd) < 0)
	    fprintf(stderr, "error closing %s\n", isfd->sfn);
	if (sclosesf(osfd) < 0)
	    fprintf(stderr, "error closing %s\n", isfd->sfn);
	if (close(ifid)<0) 	/* ifid == ofid */
	    perror("close");
	return(0);
}

long geticb(sfd)
	CSNDFILE *sfd;
{
	static long cnt;
	static struct dskblk *p;

	if (sfd == NULL)
		return(-1);
	if (sfd->cp == NULL)
		return(-1);
	if (p == NULL)	/* first time? */
		p = sfd->cp;
	if (cnt >= p->len) {
		if (p->next != NULL)
			p = p->next;
		else
			return(-1);
		cnt = 0;
	}
	return(cnt++ + p->base);
}

long getocb(sfd)
	CSNDFILE *sfd;
{
	static long cnt;
	static struct dskblk *p;

	if (sfd == NULL)
		return(-1);
	if (sfd->cp == NULL)
		return(-1);
	if (p == NULL)	/* first time? */
		p = sfd->cp;
	if (cnt >= p->len) {
		if (p->next != NULL)
			p = p->next;
		else
			return(-1);
		cnt = 0;
	}
	return(cnt++ + p->base);
}

usage(x)
	int x;
{
	fprintf(stderr, "%s%s",
	"usage: cpsf [-i] source destination\n",
	"or:    cpsf < filename_pairs\n"
	);
	exit(x);
}

yes(question, autopilot)
	char *question; int autopilot;
{
	char ans[80];
	FILE *fopen(), *fp;
	printf("%s\t",question);
	if (autopilot) { printf("y\n"); return(1); }
	fflush(stdout);
	fp = fopen("/dev/tty", "r");
	fgets(ans, 80, fp);
	fclose(fp);
	return(ans[0] == 'Y' || ans[0] == 'y');
}
