h16206
s 00001/00000/00229
d D 1.3 84/09/11 10:22:50 root 3 2
c added sccs header
e
s 00189/00250/00040
d D 1.2 84/09/11 10:19:00 root 2 1
c This is a revision of an older version of cpsf which 
c is substantially faster than the version it replaces, because it 
c does direct, raw i/o without any copying.  It was fixed by 
c Dan Timis at IRCAM to work on filesystems of different grain 
c size, so it could be reinstated.
e
s 00290/00000/00000
d D 1.1 84/07/25 14:19:39 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 3
/* %M%	%I%	(CARL)	%G%	%U% */
E 3
I 1
D 2
/* %M%	%I%	(CARL)	%G%	%U% */
E 2
#include <stdio.h>
#include <carl/libsf.h>
I 2
#include <math.h>
#define min(a,b) ((a) < (b) ? (a) : (b))
E 2

D 2
extern int sferror;  /* from sopensf */
E 2

D 2
/* see note at bottom */
E 2
I 2
int debug;
long geticb(), getocb();
E 2

D 2
int verbose=0;
char *oname = NULL;
#define MAXFILES 128
int files[MAXFILES];
int repeats[MAXFILES];
int cmdfile, contiguous, noncontiguous;
char *cmdfiles[MAXFILES];
E 2
I 2
extern char *getprown();	/* from libsf */
int interact;
E 2

D 2
struct sndesc **isfd;

E 2
main(argc, argv)
    	int argc; char *argv[];
{
D 2
    extern char *gets(), *strcpy();
    extern long sndo(), filsfb();
    extern char *malloc();
    struct sndesc *osfd=NULL, *tsfd=NULL, *xsfd=NULL,
	*sopensf(), *cpsfd(), *setsfd();
    int i=0, n, error;
    long olen=0, obyts;
E 2
I 2
	char *iname = NULL;
	char *oname = NULL;
	char *fulli, *fullo, *getsfn(), *getofile(), ch;
E 2

D 2
    sfsetiname(argv[0]);		/* pass name to interrupt routines */
E 2
I 2
	sfsetiname(argv[0]);		/* pass name to interrupt routines */
E 2

D 2
    n = catparse(argc, argv)-1;		/* n == # input files */
E 2
I 2
	while ((ch = crack(argc, argv, "ibh", 0)) != NULL) {
		switch (ch) {
			case 'i':	
			    interact++; 
			    break;
			case 'b':
			    debug++;
			    break;
			case 'h':
				usage(0);
			default:
				usage(1);
E 2

D 2
    oname = argv[files[n]];		

    if (!isatty(0))			/* read a command file */
	{
	char buf[128], *index();
	n = 0;
	while(gets(buf) != NULL)
		{
		if (!strlen(buf))
			continue;
		cmdfiles[n] = (char *) malloc((unsigned) strlen(buf)+1);
		(void) strcpy(cmdfiles[n++], buf);
		if (n >= MAXFILES)
			{
			fprintf(stderr, "cpsf: too many files, limit is: %d\n",
				MAXFILES);
			exit(1);
			}
E 2
		}
D 2
	cmdfile++;
E 2
	}

D 2
    for (i = 0; i < n; i++)
	{
	if (!cmdfile)
	    {
	    if (!strcmp(oname, argv[files[i]]))
		{
		fprintf(stderr, "cpsf: input name: %s same as output: %s\n",
		    argv[files[i]], oname);
E 2
I 2
	if (arg_index < argc-2)
		usage(1);
	iname = argv[arg_index++];
	oname = argv[arg_index];
	fulli = getsfn(iname, 0);
	fullo = getofile(iname, oname);
	if (cpsf(fulli, fullo))
E 2
		exit(1);
D 2
		}
	    }
	else
	    {
	    if (!strcmp(oname, cmdfiles[i]))
		{
		fprintf(stderr, "cpsf: input name: %s same as output: %s\n",
		    cmdfiles[i], oname);
		exit(1);
		}
	    }
	}
E 2
I 2
	exit(0);
}
E 2

D 2
    isfd = (struct sndesc **) malloc((unsigned) sizeof(struct sndesc *) * n);
E 2
I 2
cpsf(fulli, fullo)
	char *fulli, *fullo;
{
	struct sndesc *isfd, *osfd, *tsfd, 
	    *sopensf(), *cpsfd(), *setsfd(), *accesf();
	int ifid, ofid, interact=0;
	long from, to, Lcf, t, f;
	char *getsfn(), *getofile(), *buf;
	struct	sfstab	*osfstab, *dirinfo();
E 2

D 2
    for (i = 0; i < n; i++)	/* now that they're blessed, open them */
	{
	if (!cmdfile)
	    {
	    if ((xsfd = sopensf(argv[files[i]], "r", (struct sndesc *) NULL)) 
		== NULL)
		{
		fprintf(stderr, "sopensf failed on %s\n", argv[files[i]]);
		goto quit;
E 2
I 2
	if (!strcmp(fulli, fullo)) {
		fprintf(stderr, "cpsf: input name same as output: %s, %s\n",
		    fulli, fullo);
		return(1);
	}
	if (interact) {
		if ((tsfd = accesf(fullo)) != NULL) {
			char prompt[80];
			sprintf(prompt, "%s%s%s", "File exists: ", 
				fullo, " overwrite?");
			if (!yes(prompt, 0))
				return(0);
			freesfd(tsfd);
E 2
		}
D 2
	    }
	else
	    {
	    if ((xsfd = sopensf(cmdfiles[i], "r", (struct sndesc *) NULL)) 
		== NULL)
		{
		fprintf(stderr, "sopensf failed on %s\n", cmdfiles[i]);
		goto quit;
		}
	    }
	isfd[i] = xsfd;
	olen += isfd[i]->fs * repeats[i];
E 2
	}

D 2
    for (error = 0, i = 1; i < n; i++)	/* check them for catability */
	{
	if (isfd[i]->pm != isfd[0]->pm)
	    {
	    fprintf(stderr, "cpsf: packing mode conflict between %s and %s\n",
		isfd[0]->sfn, isfd[i]->sfn);
	    error++;
	    }
	if (isfd[i]->nc != isfd[0]->nc)
	    {
	    fprintf(stderr, "cpsf: # channels conflict between %s and %s\n",
		isfd[0]->sfn, isfd[i]->sfn);
	    error++;
	    }
E 2
I 2
	if ((isfd = sopensf(fulli, "r", NULL)) == NULL) {
		fprintf(stderr, "sopensf failed on %s\n", fulli);
		return(1);
E 2
	}
D 2
    if (error) 
	goto quit;
E 2
I 2
	tsfd = cpsfd(isfd);	/* copy the input sfd */
	free(tsfd->sfn);			/* stick in the output name */
	tsfd = setsfd(tsfd, "f", fullo);
	tsfd = setsfd(tsfd, "t", "r");	/* force it to be realtime */
	if (!ingroup(SUPERGROUP))
		tsfd = setsfd(tsfd, "o", getprown());
	osfstab = dirinfo(fullo);	/* get the cylinder size for out */
	tsfd -> ncyls = (long) ceil((double) isfd -> fs * isfd -> ssize / osfstab -> bpblock);
	if ((osfd = sopensf(NULL, "w", tsfd)) == NULL) {
		sclosesf(isfd); 
		return(1); 
	}
E 2

D 2
    /* output file will have attributes of first input file */
    tsfd = cpsfd(isfd[0]);		/* copy the input sfd */
    tsfd = setsfd(tsfd, "f", oname);	/* change name to output file */
    if (contiguous)
	tsfd = setsfd(tsfd, "t", "r");	/* force it to be contiguous */
    else if (noncontiguous)
	tsfd = setsfd(tsfd, "t", "n");	/* force it to be non-contiguous */
    obyts = olen * isfd[0]->ssize;	/* output file size in bytes */
    tsfd->ncyls=(obyts/isfd[0]->blksiz) /* howmany cylinders will it need? */
	+((obyts%isfd[0]->blksiz)?1:0);	/* round up if necessary */
    osfd = sopensf((char *) NULL, "wF", tsfd);
    if (osfd == NULL) 
	{ 
	for (i = 0; i < n; i++)
	    {
	    if (sclosesf(isfd[i]) != 0) 
		fprintf(stderr, "cpsf: sclosesf failed\n");
E 2
I 2
	if (close(isfd->fid) < 0) {
		perror("close");
		return(1);
	}
	if (close(osfd->fid) < 0) {
		perror("close");
		return(1);
	}
	if ((ifid = getrawdev(isfd->sfn, 0)) == -1) {
		fprintf(stderr, "cpsf: aborting\n");
E 2
		exit(1);
D 2
	    }
	exit(1); 
E 2
	}
D 2
    getsfbuf(osfd);
E 2
I 2
	if ((ofid = getrawdev(osfd->sfn, 1)) == -1) {
		fprintf(stderr, "cpsf: aborting\n");
		exit(1);
	}
E 2

D 2
    for (i = 0; i < n; i++)		/* foreach file, do a copy */
	{	
	register long iblk, niblks;
	register long rem;
	char *x, *p, *shrt="s", *flt="f";
E 2
I 2
	Lcf = isfd->blksiz == osfd->blksiz 
		? osfd->blksiz : LARGEST_COMMON_FACTOR;
	buf = (char *) malloc(Lcf);
E 2

D 2
	getsfbuf(isfd[i]);
	niblks = isfd[i]->fs / isfd[i]->nsib;
	rem = isfd[i]->fs % isfd[i]->nsib;
	if (verbose) 
		printf("copying %s\n", isfd[i]->sfn);
	x = isfd[i]->pm == PM16BIT ? (char *) isfd[i]->sb :(char *) isfd[i]->fb;
	p = isfd[i]->pm == PM16BIT ? shrt : flt;
	for (iblk = 0; iblk < niblks; iblk++) {
	    if (filsfb(isfd[i], iblk) != iblk) {	/* fill input buffer */
		fprintf(stderr, "cpsf: filsfb error 1\n");
		goto out;
	    }
	    if (sndo(osfd, x, osfd->fs, (long) isfd[i]->nsib, p) 
		!= (long) isfd[i]->nsib) {
		    fprintf(stderr, "cpsf: sndo error 1\n");
		    goto quit;
	    }
	}
	if (rem != 0) {
	    if (filsfb(isfd[i], niblks) != niblks) {
		fprintf(stderr, "cpsf: filsfb error 2\n");
		goto out;
	    }
	    if (sndo(osfd, x, osfd->fs, rem, p) != rem) {
		    fprintf(stderr, "cpsf: sndo error 2\n");
		    goto quit;
	    }
	}
	if (repeats[i] > 1) 
		{ repeats[i]--; i--; }	/* do it again */
	else				/* done with this file */
		if (sclosesf(isfd[i]) != 0) {
			fprintf(stderr, "cpsf: sclosesf failed\n");
			goto out;
E 2
I 2
	for (	from = geticb(isfd) * isfd->blksiz, 
		to = getocb(osfd) * osfd->blksiz, t = f = 0; 
		from >= 0 && to >= 0;
		) {

		register long n;

		if ((n = lseek(ifid, from + f, 0)) < 0) {
			perror("lseek"); 
			return(n); 
E 2
		}
I 2
		if ((n = read(ifid, buf, Lcf)) != Lcf) {
			perror("read"); 
			return(n); 
		}
		if ((n = lseek(ofid, to + t, 0)) < 0) {
			perror("lseek"); 
			return(n); 
		}
		if ((n = write(ofid, buf, Lcf)) != Lcf) {
			perror("write"); 
			return(n); 
		}
		osfd->fs += Lcf / osfd->ssize;
		if(osfd->fs > isfd->fs){
			osfd->fs = isfd->fs;
			break;
		}
		f += Lcf;
		t += Lcf;
		if (f >= isfd->blksiz) {
			from = geticb(isfd) * isfd->blksiz;
			f = 0;
		}
		if (t >= osfd->blksiz) {
			to = getocb(osfd) * osfd->blksiz;
			t = 0;
		}
E 2
	}
D 2
    osfd->fs = olen;	/* final val may be less than running figure */
    if (ssfallclose() != 0)
	exit(1);
    exit(0);
quit:
    fprintf(stderr, "cpsf: aborting\n");
    (void) ssfallclose();
out:
    exit(1);
E 2
I 2

	free(buf);
	if (sclosesf(isfd) < 0)
	    fprintf(stderr, "error closing %s\n", isfd->sfn);
	if (sclosesf(osfd) < 0)
	    fprintf(stderr, "error closing %s\n", isfd->sfn);
	if (close(ifid)<0) 	/* ifid == ofid */
	    perror("close");
	return(0);
E 2
}

D 2
catparse(argc, argv)
	int argc; char **argv;
E 2
I 2
long geticb(sfd)
	CSNDFILE *sfd;
E 2
{
D 2
char *index(), flag, *option;
register int i, j;
float sfexpr();
E 2
I 2
	static long cnt;
	static struct dskblk *p;
E 2

D 2
for (i = 0; i < MAXFILES; i++) repeats[i]=1;
E 2
I 2
	if (sfd == NULL)
		return(-1);
	if (sfd->cp == NULL)
		return(-1);
	if (p == NULL)	/* first time? */
		p = sfd->cp;
	if (cnt >= p->len) {
		if (p->next != NULL)
			p = p->next;
		else
			return(-1);
		cnt = 0;
	}
	return(cnt++ + p->base);
}
E 2

D 2
for (i = 1, j = 0; i < argc; i++)
	if (*argv[i] == '-')	/* itsa flag */
		{
		flag = *(argv[i]+1);
		option = argv[i]+2;
		if (flag == 'r')	/* itsa repeat */
			repeats[j] = sfexpr(option, 1.0);
E 2
I 2
long getocb(sfd)
	CSNDFILE *sfd;
{
	static long cnt;
	static struct dskblk *p;

	if (sfd == NULL)
		return(-1);
	if (sfd->cp == NULL)
		return(-1);
	if (p == NULL)	/* first time? */
		p = sfd->cp;
	if (cnt >= p->len) {
		if (p->next != NULL)
			p = p->next;
E 2
		else
D 2
		if (flag == 'c')	/* contiguous file? */
			contiguous++;
		else
		if (flag == 'n')	/* non-contiguous file? */
			noncontiguous++;
		else
		if (flag == 'v')	/* verbosity */
			verbose++;
		else
		if (flag == 'h')	/* wants some help */
			cathelp();
		else
			{
			fprintf(stderr, "illegal flag: %s\n", argv[i]);
			exit(1);
			}
		}
	else
		/* itsa file */
		files[j++] = i;	/* we'll use this to index argv */
return(j);
E 2
I 2
			return(-1);
		cnt = 0;
	}
	return(cnt++ + p->base);
E 2
}

D 2
cathelp()
E 2
I 2
usage(x)
	int x;
E 2
{
D 2
	printf("%s%s%s%s%s%s%s",
	    "usage: cpsf [flags] [-rN] source [[-rN] source]... destination\n",
	    " flags:\n",
	    " -rN means repeat the next source N times\n",
	    " -c force file to be contiguous\n",
	    " -n force file to be non-contiguous\n",
	    " -fX read commands from file X\n",
	    " -v  makes cpsf more verbose.\n");
	exit(1);
E 2
I 2
	fprintf(stderr, "%s%s",
	"usage: cpsf [-i] source destination\n",
	"or:    cpsf < filename_pairs\n"
	);
	exit(x);
E 2
}

D 2
/*
 * cpsf - concatenate sound files
 * Method:
 * open all input files, figure out how long output file must be
 * check for compatability of input files
 * 	can't have stereo and mono combined, 
 * 	sampling rates must agree,
 * 	packing modes must agree.
 * copy the sfd for input file 0 to form attributes of output file
 * 	force it to be a realtime file (could be optional)
 * 	change the name of the copied sfd to be the output file name
 * open the output file
 * loop through files concatenating.
 * 	some arcane things are done with the i/o operations:
 * 		filsfb() fills the input buffer for the current input
 * 		file with a block.
 * 		sndo() writes out that block, pointed to by x. 
 * 		The starting sample is equal to the number of output 
 * 		samples written so far, osfd->fs.
 * 		the number of samples is the size of the input buffer,
 * 		which is set up to be the same as the output buffer:
 * 		osfd->nsib.
 * 		finally, the argument p will either have "s" or "f" to
 * 		tell sndo() whether the buffer got by filsfb() contains
 * 		shorts or floats.
 *	the purpose of using filsfb(), not sndi(), is that we can always
 *	read raw blocks without alignment problems, and we also don't
 *	need to unpack shorts into floats, which means we also don't need to
 *	do the copy implied by moving sndi()'s input buffer to the array
 *	that normally interfaces to the user.  Avoiding these copies and
 *	floats/fixes saves an incredible amount of time.
 *	we must use sndo() instead of wrtsfb() to write it out because
 *	at the end of an input file, there may by a few samples in the last
 *	buffer, and we must align the next file to begin on the very next
 *	sample, which sndo() does, and wrtsfb() does not.
 *	the reason for explicitly managing buffers for sndo() is to be
 *	able to use the default size in calculating the transfer.
 *	for file input buffers, when we're done with the file, we're done
 *	with the buffer too, so stunsf() removes the buffer.
 */
E 2
I 2
yes(question, autopilot)
	char *question; int autopilot;
{
	char ans[80];
	FILE *fopen(), *fp;
	printf("%s\t",question);
	if (autopilot) { printf("y\n"); return(1); }
	fflush(stdout);
	fp = fopen("/dev/tty", "r");
	fgets(ans, 80, fp);
	fclose(fp);
	return(ans[0] == 'Y' || ans[0] == 'y');
}
E 2
E 1
