/* %M%	%I%	(CARL)	%G%	%U% */
#include <carl/libsf.h>
#include <stdio.h>

/*
 * closesf - user level program to close sound file.
 * it has two modes:
 * 1) reads sfd off standard input of file to be closed
 * 2) reads command line args for files to be closed
 * If there are no arguments (argc == 1), it reads one sdf off
 * the standard input.  If there are one or more arguments, it
 * takes them as filenames to be closed.
 * Note that the implication of this is that
 * a file closed in mode 2 is merely forced shut, there is no way to
 * update the sdf file before closing it; whatever is already in the sdf file
 * is taken as the state of the file.  A file closed in
 * mode 1 is updated by the fact that its sfd comes off the standard
 * input and this presumably is different in some (possibly important)
 * way from the current contents of the existing sdf for that file.
 * Therefore: use mode 2 only for panic closes, like at interrupt level.
 * The libsf subroutine closesf() uses mode 1.
 */

extern int sferror;
extern int nlrsdf;	/* from libsf/rsdf.c */

main(argc, argv)
	char **argv;
{
	extern struct sndesc *rsdf(), *accesf();
	struct sndesc *sfd; 

	if (argc == 1) {
		nlrsdf = 1;
		sfd = rsdf(stdin, (char *) NULL);
		nlrsdf = 0;
		if (sfd == NULL || sferror != 0) {
			fprintf(stderr, "closesf: rsdf failed\n");
			exit(1);
		}
		if (sclosesf(sfd)) {
			fprintf(stderr, "closesf: sclosesf failed\n");
			exit(1);
		}
	} else {
		while (--argc) {
			sferror = 0;
			if ((sfd = accesf(*++argv)) == NULL) 
				continue;
			else {
				if (sclosesf(sfd)) {
					fprintf(stderr, "sclosesf failed\n");
					continue;
				}
			}
		}
	}
	exit(0);
}
