/* Second-Order Filter */
/* y[i] = gain * (a0*x[i] - a1*x[i-1] - a2*x[i-2] + b1*y[i-1] + b2*y[i-2]) */

#include "mm.head.h"
#include "ug.head.h"

#define	IN	1
#define	GAIN	2
#define	A0	3
#define	A1	4
#define	A2	5
#define	B1	6
#define	B2	7
#define	XM1	8
#define	XM2	9
#define	YM1	10
#define	YM2	11

flt

UGHEAD{
    UGINIT;
    UGLOOP{

	VAL(OUT) = VAL(GAIN) * (
		    VAL(A0)*VAL(IN)
		    + VAL(A1)*VAL(XM1)
		    + VAL(A2)*VAL(XM2)
		    + VAL(B1)*VAL(YM1)
		    + VAL(B2)*VAL(YM2)
		);
		VAL(YM2) = VAL(YM1);
		VAL(YM1) = VAL(OUT);
		VAL(XM2) = VAL(XM1);
		VAL(XM1) = VAL(IN);

	UGEND(0)
    }
}
